/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.config;

import com.microsoft.azure.spring.data.cosmosdb.core.mapping.DocumentDbMappingContext;
import com.microsoft.azure.spring.data.cosmosdb.repository.DocumentDbRepository;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.DocumentDbRepositoryFactoryBean;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;

public class DocumentDbRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    public String getModuleName() {
        return "cosmosdb";
    }

    public String getModulePrefix() {
        return "cosmosdb";
    }

    public String getRepositoryFactoryBeanClassName() {
        return DocumentDbRepositoryFactoryBean.class.getName();
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(DocumentDbRepository.class);
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.emptyList();
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        if (!registry.containsBeanDefinition("documentDbMappingContext")) {
            RootBeanDefinition definition = new RootBeanDefinition(DocumentDbMappingContext.class);
            definition.setRole(2);
            definition.setSource(config.getSource());
            registry.registerBeanDefinition("documentDbMappingContext", (BeanDefinition)definition);
        }
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        super.postProcess(builder, source);
    }
}

