/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.support;

import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.PartitionKey;
import com.microsoft.azure.spring.data.cosmosdb.core.DocumentDbOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.query.Criteria;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CriteriaType;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.repository.DocumentDbRepository;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.DocumentDbEntityInformation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleDocumentDbRepository<T, ID extends Serializable>
implements DocumentDbRepository<T, ID> {
    private final DocumentDbOperations operation;
    private final DocumentDbEntityInformation<T, ID> information;
    private final DocumentCollection collection;

    public SimpleDocumentDbRepository(DocumentDbEntityInformation<T, ID> metadata, ApplicationContext applicationContext) {
        this.operation = (DocumentDbOperations)applicationContext.getBean(DocumentDbOperations.class);
        this.information = metadata;
        this.collection = this.createCollectionIfNotExists();
    }

    public SimpleDocumentDbRepository(DocumentDbEntityInformation<T, ID> metadata, DocumentDbOperations dbOperations) {
        this.operation = dbOperations;
        this.information = metadata;
        this.collection = this.createCollectionIfNotExists();
    }

    private DocumentCollection createCollectionIfNotExists() {
        return this.operation.createCollectionIfNotExists(this.information);
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"entity must not be null");
        if (this.information.isNew(entity)) {
            return this.operation.insert(this.information.getCollectionName(), entity, this.createKey(this.information.getPartitionKeyFieldValue(entity)));
        }
        this.operation.upsert(this.information.getCollectionName(), entity, this.createKey(this.information.getPartitionKeyFieldValue(entity)));
        return entity;
    }

    private PartitionKey createKey(String partitionKeyValue) {
        if (StringUtils.isEmpty((Object)partitionKeyValue)) {
            return null;
        }
        return new PartitionKey((Object)partitionKeyValue);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Iterable entities should not be null");
        entities.forEach(this::save);
        return entities;
    }

    public Iterable<T> findAll() {
        return this.operation.findAll(this.information.getCollectionName(), this.information.getJavaType());
    }

    public List<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"Iterable ids should not be null");
        ArrayList entities = new ArrayList();
        ids.forEach(id -> this.findById((ID)id).ifPresent(entities::add));
        return entities;
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"id must not be null");
        if (id instanceof String && !StringUtils.hasText((String)((String)id))) {
            return Optional.empty();
        }
        Object result = this.operation.findById(this.information.getCollectionName(), id, this.information.getJavaType());
        return result == null ? Optional.empty() : Optional.of(result);
    }

    public long count() {
        return this.operation.count(this.information.getCollectionName());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"id to be deleted should not be null");
        this.operation.deleteById(this.information.getCollectionName(), id, null);
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"entity to be deleted should not be null");
        String partitionKeyValue = this.information.getPartitionKeyFieldValue(entity);
        this.operation.deleteById(this.information.getCollectionName(), this.information.getId(entity), partitionKeyValue == null ? null : new PartitionKey((Object)partitionKeyValue));
    }

    public void deleteAll() {
        this.operation.deleteAll(this.information.getCollectionName(), this.information.getJavaType());
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Iterable entities should not be null");
        entities.forEach(this::delete);
    }

    public boolean existsById(ID primaryKey) {
        Assert.notNull(primaryKey, (String)"primaryKey should not be null");
        return this.findById(primaryKey).isPresent();
    }

    public Iterable<T> findAll(@NonNull Sort sort) {
        Assert.notNull((Object)sort, (String)"sort of findAll should not be null");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL)).with(sort);
        return this.operation.find(query, this.information.getJavaType(), this.information.getCollectionName());
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"pageable should not be null");
        return this.operation.findAll(pageable, this.information.getJavaType(), this.information.getCollectionName());
    }
}

