/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.spring.data.cosmosdb.DocumentDbFactory;
import com.microsoft.azure.spring.data.cosmosdb.config.DocumentDBConfig;
import com.microsoft.azure.spring.data.cosmosdb.config.DocumentDbConfigurationSupport;
import com.microsoft.azure.spring.data.cosmosdb.core.DocumentDbTemplate;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.MappingDocumentDbConverter;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.DocumentDbPersistentEntity;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.DocumentDbPersistentProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mapping.context.MappingContext;

@Configuration
public abstract class AbstractDocumentDbConfiguration
extends DocumentDbConfigurationSupport {
    @Qualifier(value="cosmosdbObjectMapper")
    @Autowired(required=false)
    private ObjectMapper objectMapper;

    public abstract DocumentDBConfig getConfig();

    @Bean
    public DocumentClient documentClient() {
        return this.documentDbFactory().getDocumentClient();
    }

    @Bean
    public DocumentDbFactory documentDbFactory() {
        return new DocumentDbFactory(this.getConfig());
    }

    @Bean
    public DocumentDbTemplate documentDbTemplate() throws ClassNotFoundException {
        DocumentDBConfig config = this.getConfig();
        return new DocumentDbTemplate(this.documentDbFactory(), this.mappingDocumentDbConverter(), config.getDatabase());
    }

    @Bean
    public MappingDocumentDbConverter mappingDocumentDbConverter() throws ClassNotFoundException {
        return new MappingDocumentDbConverter((MappingContext<? extends DocumentDbPersistentEntity<?>, DocumentDbPersistentProperty>)this.documentDbMappingContext(), this.objectMapper);
    }
}

