/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core;

import com.microsoft.azure.documentdb.Database;
import com.microsoft.azure.documentdb.Document;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.documentdb.DocumentClientException;
import com.microsoft.azure.documentdb.DocumentCollection;
import com.microsoft.azure.documentdb.FeedOptions;
import com.microsoft.azure.documentdb.FeedResponse;
import com.microsoft.azure.documentdb.IndexingPolicy;
import com.microsoft.azure.documentdb.PartitionKey;
import com.microsoft.azure.documentdb.PartitionKeyDefinition;
import com.microsoft.azure.documentdb.RequestOptions;
import com.microsoft.azure.documentdb.Resource;
import com.microsoft.azure.documentdb.SqlParameter;
import com.microsoft.azure.documentdb.SqlParameterCollection;
import com.microsoft.azure.documentdb.SqlQuerySpec;
import com.microsoft.azure.spring.data.cosmosdb.DocumentDbFactory;
import com.microsoft.azure.spring.data.cosmosdb.common.CosmosdbUtils;
import com.microsoft.azure.spring.data.cosmosdb.config.DocumentDBConfig;
import com.microsoft.azure.spring.data.cosmosdb.core.DocumentDbOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.MappingDocumentDbConverter;
import com.microsoft.azure.spring.data.cosmosdb.core.generator.CountQueryGenerator;
import com.microsoft.azure.spring.data.cosmosdb.core.generator.FindQuerySpecGenerator;
import com.microsoft.azure.spring.data.cosmosdb.core.query.Criteria;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CriteriaType;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentDbPageRequest;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.exception.DatabaseCreationException;
import com.microsoft.azure.spring.data.cosmosdb.exception.DocumentDBAccessException;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.DocumentDbEntityInformation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DocumentDbTemplate
implements DocumentDbOperations,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DocumentDbTemplate.class);
    private static final String COUNT_VALUE_KEY = "_aggregate";
    private final DocumentClient documentClient;
    private final DocumentDbFactory documentDbFactory;
    private final MappingDocumentDbConverter mappingDocumentDbConverter;
    private final String databaseName;
    private Database databaseCache;
    private List<String> collectionCache;

    public DocumentDbTemplate(DocumentDbFactory documentDbFactory, MappingDocumentDbConverter mappingDocumentDbConverter, String dbName) {
        Assert.notNull((Object)documentDbFactory, (String)"DocumentDbFactory must not be null!");
        Assert.notNull((Object)mappingDocumentDbConverter, (String)"MappingDocumentDbConverter must not be null!");
        this.databaseName = dbName;
        this.documentDbFactory = documentDbFactory;
        this.documentClient = this.documentDbFactory.getDocumentClient();
        this.mappingDocumentDbConverter = mappingDocumentDbConverter;
        this.collectionCache = new ArrayList<String>();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }

    @Override
    public <T> T insert(T objectToSave, PartitionKey partitionKey) {
        Assert.notNull(objectToSave, (String)"entityClass should not be null");
        return this.insert(this.getCollectionName(objectToSave.getClass()), objectToSave, partitionKey);
    }

    @Override
    public <T> T insert(String collectionName, T objectToSave, PartitionKey partitionKey) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(objectToSave, (String)"objectToSave should not be null");
        Document document = this.mappingDocumentDbConverter.writeDoc(objectToSave);
        log.debug("execute createDocument in database {} collection {}", (Object)this.databaseName, (Object)collectionName);
        try {
            Resource result = this.getDocumentClient().createDocument(this.getCollectionLink(this.databaseName, collectionName), (Object)document, this.getRequestOptions(partitionKey, null), false).getResource();
            if (result instanceof Document) {
                Document documentInserted = (Document)result;
                Class<?> domainClass = objectToSave.getClass();
                return (T)this.mappingDocumentDbConverter.read(domainClass, documentInserted);
            }
            return null;
        }
        catch (DocumentClientException e) {
            throw new DocumentDBAccessException("insert exception", e);
        }
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        return this.findById(this.getCollectionName(entityClass), id, entityClass);
    }

    private boolean isIdFieldAsPartitionKey(@NonNull Class<?> domainClass) {
        DocumentDbEntityInformation information = new DocumentDbEntityInformation(domainClass);
        String partitionKeyName = information.getPartitionKeyFieldName();
        String idName = information.getIdField().getName();
        return partitionKeyName != null && partitionKeyName.equals(idName);
    }

    @Override
    public <T> T findById(String collectionName, Object id, Class<T> domainClass) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(domainClass, (String)"entityClass should not be null");
        this.assertValidId(id);
        try {
            PartitionKey partitionKey = this.isIdFieldAsPartitionKey(domainClass) ? new PartitionKey(id) : null;
            RequestOptions options = this.getRequestOptions(partitionKey, null);
            String documentLink = this.getDocumentLink(this.databaseName, collectionName, id);
            Resource document = this.getDocumentClient().readDocument(documentLink, options).getResource();
            if (document instanceof Document) {
                return this.mappingDocumentDbConverter.read(domainClass, (Document)document);
            }
            return null;
        }
        catch (DocumentClientException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw new DocumentDBAccessException("findById exception", e);
        }
    }

    @Override
    public <T> void upsert(T object, PartitionKey partitionKey) {
        Assert.notNull(object, (String)"Upsert object should not be null");
        this.upsert(this.getCollectionName(object.getClass()), object, partitionKey);
    }

    @Override
    public <T> void upsert(String collectionName, T object, PartitionKey partitionKey) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(object, (String)"Upsert object should not be null");
        try {
            Document originalDoc = object instanceof Document ? (Document)object : this.mappingDocumentDbConverter.writeDoc(object);
            log.debug("execute upsert document in database {} collection {}", (Object)this.databaseName, (Object)collectionName);
            String collectionLink = this.getCollectionSelfLink(collectionName);
            RequestOptions options = this.getRequestOptions(partitionKey, null);
            this.getDocumentClient().upsertDocument(collectionLink, (Object)originalDoc, options, false);
        }
        catch (DocumentClientException ex) {
            throw new DocumentDBAccessException("Failed to upsert document to database.", ex);
        }
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        return this.findAll(this.getCollectionName(entityClass), entityClass);
    }

    @Override
    public <T> List<T> findAll(String collectionName, Class<T> domainClass) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(domainClass, (String)"entityClass should not be null");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        List<Document> results = this.findDocuments(query, domainClass, collectionName);
        return results.stream().map(d -> this.getConverter().read(domainClass, (Document)d)).collect(Collectors.toList());
    }

    @Override
    public void deleteAll(@NonNull String collectionName, @NonNull Class<?> domainClass) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        this.delete(query, domainClass, collectionName);
    }

    @Override
    public void deleteCollection(@NonNull String collectionName) {
        Assert.hasText((String)collectionName, (String)"collectionName should have text.");
        try {
            this.getDocumentClient().deleteCollection(this.getCollectionLink(this.databaseName, collectionName), null);
            this.collectionCache.remove(collectionName);
        }
        catch (DocumentClientException ex) {
            throw new DocumentDBAccessException("failed to delete collection: " + collectionName, ex);
        }
    }

    @Override
    public String getCollectionName(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"domainClass should not be null");
        return new DocumentDbEntityInformation(domainClass).getCollectionName();
    }

    private Database createDatabaseIfNotExists(String dbName) {
        try {
            List dbList = this.getDocumentClient().queryDatabases(new SqlQuerySpec("SELECT * FROM root r WHERE r.id=@id", new SqlParameterCollection(new SqlParameter[]{new SqlParameter("@id", (Object)dbName)})), null).getQueryIterable().toList();
            if (!dbList.isEmpty()) {
                return (Database)dbList.get(0);
            }
            Database db = new Database();
            db.setId(dbName);
            log.debug("execute createDatabase {}", (Object)dbName);
            Resource resource = this.getDocumentClient().createDatabase(db, null).getResource();
            if (resource instanceof Database) {
                return (Database)resource;
            }
            String errorMessage = MessageFormat.format("create database {0} and get unexpected result: {1}", dbName, resource.getSelfLink());
            log.error(errorMessage);
            throw new DatabaseCreationException(errorMessage);
        }
        catch (DocumentClientException ex) {
            throw new DocumentDBAccessException("createOrGetDatabase exception", ex);
        }
    }

    private DocumentCollection createCollection(@NonNull String dbName, String partitionKeyFieldName, @NonNull DocumentDbEntityInformation information) {
        DocumentCollection collection = new DocumentCollection();
        String collectionName = information.getCollectionName();
        IndexingPolicy policy = information.getIndexingPolicy();
        Integer timeToLive = information.getTimeToLive();
        RequestOptions requestOptions = this.getRequestOptions(null, information.getRequestUnit());
        collection.setId(collectionName);
        collection.setIndexingPolicy(policy);
        if (information.getIndexingPolicy().getAutomatic().booleanValue()) {
            collection.setDefaultTimeToLive(timeToLive);
        }
        if (partitionKeyFieldName != null && !partitionKeyFieldName.isEmpty()) {
            PartitionKeyDefinition partitionKeyDefinition = new PartitionKeyDefinition();
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(this.getPartitionKeyPath(partitionKeyFieldName));
            partitionKeyDefinition.setPaths(paths);
            collection.setPartitionKey(partitionKeyDefinition);
        }
        log.debug("execute createCollection in database {} collection {}", (Object)dbName, (Object)collectionName);
        try {
            Resource resource = this.getDocumentClient().createCollection(this.getDatabaseLink(dbName), collection, requestOptions).getResource();
            if (resource instanceof DocumentCollection) {
                collection = (DocumentCollection)resource;
            }
            return collection;
        }
        catch (DocumentClientException e) {
            throw new DocumentDBAccessException("createCollection exception", e);
        }
    }

    @Override
    public DocumentCollection createCollectionIfNotExists(@NonNull DocumentDbEntityInformation information) {
        if (this.databaseCache == null) {
            this.databaseCache = this.createDatabaseIfNotExists(this.databaseName);
        }
        String collectionName = information.getCollectionName();
        String partitionKeyFieldName = information.getPartitionKeyFieldName();
        List collectionList = this.getDocumentClient().queryCollections(this.getDatabaseLink(this.databaseName), new SqlQuerySpec("SELECT * FROM root r WHERE r.id=@id", new SqlParameterCollection(new SqlParameter[]{new SqlParameter("@id", (Object)collectionName)})), null).getQueryIterable().toList();
        if (!collectionList.isEmpty()) {
            return (DocumentCollection)collectionList.get(0);
        }
        return this.createCollection(this.databaseName, partitionKeyFieldName, information);
    }

    @Override
    public void deleteById(String collectionName, Object id, PartitionKey partitionKey) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        this.assertValidId(id);
        log.debug("execute deleteById in database {} collection {}", (Object)this.databaseName, (Object)collectionName);
        try {
            RequestOptions options = this.getRequestOptions(partitionKey, null);
            this.getDocumentClient().deleteDocument(this.getDocumentLink(this.databaseName, collectionName, id.toString()), options);
        }
        catch (DocumentClientException ex) {
            throw new DocumentDBAccessException("deleteById exception", ex);
        }
    }

    private String getDatabaseLink(String databaseName) {
        return "dbs/" + databaseName;
    }

    private String getCollectionLink(String databaseName, String collectionName) {
        return this.getDatabaseLink(databaseName) + "/colls/" + collectionName;
    }

    private String getDocumentLink(String databaseName, String collectionName, Object documentId) {
        return this.getCollectionLink(databaseName, collectionName) + "/docs/" + documentId;
    }

    private String getPartitionKeyPath(String partitionKey) {
        return "/" + partitionKey;
    }

    @NonNull
    private DocumentDBConfig getDocumentDbConfig() {
        return this.documentDbFactory.getConfig();
    }

    private RequestOptions getRequestOptions(PartitionKey key, Integer requestUnit) {
        RequestOptions options = CosmosdbUtils.getCopyFrom(this.getDocumentDbConfig().getRequestOptions());
        if (key != null) {
            options.setPartitionKey(key);
        }
        if (requestUnit != null) {
            options.setOfferThroughput(requestUnit);
        }
        return options;
    }

    private <T> List<T> executeQuery(@NonNull SqlQuerySpec sqlQuerySpec, boolean isCrossPartition, @NonNull Class<T> domainClass, String collectionName) {
        FeedResponse<Document> feedResponse = this.executeQuery(sqlQuerySpec, isCrossPartition, collectionName);
        List result = feedResponse.getQueryIterable().toList();
        return result.stream().map(r -> this.getConverter().read(domainClass, (Document)r)).collect(Collectors.toList());
    }

    private FeedResponse<Document> executeQuery(@NonNull SqlQuerySpec sqlQuerySpec, boolean isCrossPartition, String collectionName) {
        FeedOptions feedOptions = new FeedOptions();
        String selfLink = this.getCollectionSelfLink(collectionName);
        feedOptions.setEnableCrossPartitionQuery(Boolean.valueOf(isCrossPartition));
        return this.getDocumentClient().queryDocuments(selfLink, sqlQuerySpec, feedOptions);
    }

    private FeedResponse<Document> executeQuery(@NonNull SqlQuerySpec sqlQuerySpec, FeedOptions feedOptions, String collectionName) {
        String selfLink = this.getCollectionSelfLink(collectionName);
        return this.getDocumentClient().queryDocuments(selfLink, sqlQuerySpec, feedOptions);
    }

    @Override
    public <T, ID> List<T> findByIds(Iterable<ID> ids, Class<T> entityClass, String collectionName) {
        Assert.notNull(ids, (String)"Id list should not be null");
        Assert.notNull(entityClass, (String)"entityClass should not be null.");
        Assert.hasText((String)collectionName, (String)"collection should not be null, empty or only whitespaces");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.IN, "id", Collections.singletonList(ids)));
        return this.find(query, entityClass, collectionName);
    }

    @Override
    public <T> List<T> find(@NonNull DocumentQuery query, @NonNull Class<T> domainClass, String collectionName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(domainClass, (String)"domainClass should not be null.");
        Assert.hasText((String)collectionName, (String)"collection should not be null, empty or only whitespaces");
        try {
            SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generate(query);
            boolean isCrossPartitionQuery = query.isCrossPartitionQuery(this.getPartitionKeyNames(domainClass));
            return this.executeQuery(sqlQuerySpec, isCrossPartitionQuery, domainClass, collectionName);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new DocumentDBAccessException("Failed to execute find operation from " + collectionName, e);
        }
    }

    @Override
    public <T> Boolean exists(@NonNull DocumentQuery query, @NonNull Class<T> domainClass, String collectionName) {
        return this.find(query, domainClass, collectionName).size() > 0;
    }

    private List<Document> findDocuments(@NonNull DocumentQuery query, @NonNull Class<?> domainClass, @NonNull String collectionName) {
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generate(query);
        boolean isCrossPartitionQuery = query.isCrossPartitionQuery(this.getPartitionKeyNames(domainClass));
        FeedResponse<Document> response = this.executeQuery(sqlQuerySpec, isCrossPartitionQuery, collectionName);
        return response.getQueryIterable().toList();
    }

    private void deleteDocument(@NonNull Document document, @NonNull List<String> partitionKeyNames) {
        try {
            Assert.isTrue((partitionKeyNames.size() <= 1 ? 1 : 0) != 0, (String)"Only one Partition is supported.");
            PartitionKey partitionKey = null;
            if (!partitionKeyNames.isEmpty() && StringUtils.hasText((String)partitionKeyNames.get(0))) {
                partitionKey = new PartitionKey(document.get(partitionKeyNames.get(0)));
            }
            RequestOptions options = this.getRequestOptions(partitionKey, null);
            this.getDocumentClient().deleteDocument(document.getSelfLink(), options);
        }
        catch (DocumentClientException e) {
            throw new DocumentDBAccessException("Failed to delete document: " + document.getSelfLink(), e);
        }
    }

    @Override
    public <T> List<T> delete(@NonNull DocumentQuery query, @NonNull Class<T> domainClass, @NonNull String collectionName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(domainClass, (String)"domainClass should not be null.");
        Assert.hasText((String)collectionName, (String)"collection should not be null, empty or only whitespaces");
        List<Document> results = this.findDocuments(query, domainClass, collectionName);
        List<String> partitionKeyName = this.getPartitionKeyNames(domainClass);
        results.forEach(d -> this.deleteDocument((Document)d, partitionKeyName));
        return results.stream().map(d -> this.getConverter().read(domainClass, (Document)d)).collect(Collectors.toList());
    }

    @Override
    public <T> Page<T> findAll(Pageable pageable, Class<T> domainClass, String collectionName) {
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL)).with(pageable);
        if (pageable.getSort().isSorted()) {
            query.with(pageable.getSort());
        }
        return this.paginationQuery(query, domainClass, collectionName);
    }

    @Override
    public <T> Page<T> paginationQuery(DocumentQuery query, Class<T> domainClass, String collectionName) {
        Assert.isTrue((query.getPageable().getPageSize() > 0 ? 1 : 0) != 0, (String)"pageable should have page size larger than 0");
        Assert.hasText((String)collectionName, (String)"collection should not be null, empty or only whitespaces");
        Pageable pageable = query.getPageable();
        FeedOptions feedOptions = new FeedOptions();
        if (pageable instanceof DocumentDbPageRequest) {
            feedOptions.setRequestContinuation(((DocumentDbPageRequest)pageable).getRequestContinuation());
        }
        feedOptions.setPageSize(Integer.valueOf(pageable.getPageSize()));
        feedOptions.setEnableCrossPartitionQuery(Boolean.valueOf(query.isCrossPartitionQuery(this.getPartitionKeyNames(domainClass))));
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generate(query);
        FeedResponse<Document> response = this.executeQuery(sqlQuerySpec, feedOptions, collectionName);
        Iterator it = response.getQueryIterator();
        ArrayList<T> result = new ArrayList<T>();
        for (int index = 0; it.hasNext() && index < pageable.getPageSize(); ++index) {
            Document doc = (Document)it.next();
            if (doc == null) continue;
            T entity = this.mappingDocumentDbConverter.read(domainClass, doc);
            result.add(entity);
        }
        DocumentDbPageRequest pageRequest = DocumentDbPageRequest.of(pageable.getPageNumber(), pageable.getPageSize(), response.getResponseContinuation());
        return new PageImpl(result, (Pageable)pageRequest, this.count(query, domainClass, collectionName));
    }

    @Override
    public long count(String collectionName) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be empty");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        SqlQuerySpec querySpec = new CountQueryGenerator().generate(query);
        return this.getCountValue(querySpec, true, collectionName);
    }

    @Override
    public <T> long count(DocumentQuery query, Class<T> domainClass, String collectionName) {
        Assert.notNull(domainClass, (String)"domainClass should not be null");
        Assert.hasText((String)collectionName, (String)"collectionName should not be empty");
        SqlQuerySpec querySpec = new CountQueryGenerator().generate(query);
        boolean isCrossPartitionQuery = query.isCrossPartitionQuery(this.getPartitionKeyNames(domainClass));
        return this.getCountValue(querySpec, isCrossPartitionQuery, collectionName);
    }

    private long getCountValue(SqlQuerySpec querySpec, boolean isCrossPartitionQuery, String collectionName) {
        FeedResponse<Document> feedResponse = this.executeQuery(querySpec, isCrossPartitionQuery, collectionName);
        Object value = ((Document)feedResponse.getQueryIterable().toList().get(0)).getHashMap().get(COUNT_VALUE_KEY);
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new IllegalStateException("Unexpected value type " + value.getClass() + " of value: " + value);
    }

    private String getCollectionSelfLink(@NonNull String collectionName) {
        return String.format("dbs/%s/colls/%s", this.databaseName, collectionName);
    }

    @Override
    public MappingDocumentDbConverter getConverter() {
        return this.mappingDocumentDbConverter;
    }

    private List<String> getPartitionKeyNames(Class<?> domainClass) {
        DocumentDbEntityInformation entityInfo = new DocumentDbEntityInformation(domainClass);
        if (entityInfo.getPartitionKeyFieldName() == null) {
            return new ArrayList<String>();
        }
        return Collections.singletonList(entityInfo.getPartitionKeyFieldName());
    }

    private void assertValidId(Object id) {
        Assert.notNull((Object)id, (String)"id should not be null");
        if (id instanceof String) {
            Assert.hasText((String)id.toString(), (String)"id should not be empty or only whitespaces.");
        }
    }

    private DocumentClient getDocumentClient() {
        return this.documentClient;
    }
}

