/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core.convert;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class ZonedDateTimeDeserializer
extends JsonDeserializer<ZonedDateTime> {
    public ZonedDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this.parse(jsonParser);
    }

    public ZonedDateTime parse(JsonParser jsonParser) throws IOException {
        if (jsonParser.getValueAsString() == null) {
            return null;
        }
        try {
            return ZonedDateTime.parse(jsonParser.getValueAsString(), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:s:SSSXXX"));
        }
        catch (DateTimeParseException e) {
            throw new JsonParseException(jsonParser, jsonParser.getValueAsString(), (Throwable)e);
        }
    }
}

