/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core.query;

import com.microsoft.azure.spring.data.cosmosdb.core.query.CriteriaType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.lang.NonNull;

public class Criteria {
    private String subject;
    private List<Object> subjectValues;
    private final CriteriaType type;
    private final List<Criteria> subCriteria;

    private Criteria(CriteriaType type) {
        this.type = type;
        this.subCriteria = new ArrayList<Criteria>();
    }

    public static Criteria getInstance(CriteriaType type, @NonNull String subject, @NonNull List<Object> values) {
        Criteria criteria = new Criteria(type);
        criteria.subject = subject;
        criteria.subjectValues = values;
        return criteria;
    }

    public static Criteria getInstance(CriteriaType type, @NonNull Criteria left, @NonNull Criteria right) {
        Criteria criteria = new Criteria(type);
        criteria.subCriteria.add(left);
        criteria.subCriteria.add(right);
        return criteria;
    }

    public static Criteria getInstance(CriteriaType type) {
        return new Criteria(type);
    }

    public String getSubject() {
        return this.subject;
    }

    public List<Object> getSubjectValues() {
        return this.subjectValues;
    }

    public CriteriaType getType() {
        return this.type;
    }

    public List<Criteria> getSubCriteria() {
        return this.subCriteria;
    }
}

