/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core;

import com.azure.data.cosmos.AccessCondition;
import com.azure.data.cosmos.AccessConditionType;
import com.azure.data.cosmos.CosmosClient;
import com.azure.data.cosmos.CosmosContainerProperties;
import com.azure.data.cosmos.CosmosContainerResponse;
import com.azure.data.cosmos.CosmosItemProperties;
import com.azure.data.cosmos.CosmosItemRequestOptions;
import com.azure.data.cosmos.CosmosItemResponse;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.PartitionKey;
import com.azure.data.cosmos.SqlQuerySpec;
import com.microsoft.azure.spring.data.cosmosdb.CosmosDbFactory;
import com.microsoft.azure.spring.data.cosmosdb.common.CosmosdbUtils;
import com.microsoft.azure.spring.data.cosmosdb.common.Memoizer;
import com.microsoft.azure.spring.data.cosmosdb.core.CosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.ResponseDiagnosticsProcessor;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.MappingCosmosConverter;
import com.microsoft.azure.spring.data.cosmosdb.core.generator.CountQueryGenerator;
import com.microsoft.azure.spring.data.cosmosdb.core.generator.FindQuerySpecGenerator;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CosmosPageImpl;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CosmosPageRequest;
import com.microsoft.azure.spring.data.cosmosdb.core.query.Criteria;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CriteriaType;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.exception.CosmosDBExceptionUtils;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.CosmosEntityInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CosmosTemplate
implements CosmosOperations,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CosmosTemplate.class);
    private static final String COUNT_VALUE_KEY = "_aggregate";
    private final MappingCosmosConverter mappingCosmosConverter;
    private final String databaseName;
    private final ResponseDiagnosticsProcessor responseDiagnosticsProcessor;
    private final boolean isPopulateQueryMetrics;
    private final CosmosClient cosmosClient;
    private Function<Class<?>, CosmosEntityInformation<?, ?>> entityInfoCreator = Memoizer.memoize(this::getCosmosEntityInformation);

    public CosmosTemplate(CosmosDbFactory cosmosDbFactory, MappingCosmosConverter mappingCosmosConverter, String dbName) {
        Assert.notNull((Object)cosmosDbFactory, (String)"CosmosDbFactory must not be null!");
        Assert.notNull((Object)mappingCosmosConverter, (String)"MappingCosmosConverter must not be null!");
        this.mappingCosmosConverter = mappingCosmosConverter;
        this.databaseName = dbName;
        this.cosmosClient = cosmosDbFactory.getCosmosClient();
        this.responseDiagnosticsProcessor = cosmosDbFactory.getConfig().getResponseDiagnosticsProcessor();
        this.isPopulateQueryMetrics = cosmosDbFactory.getConfig().isPopulateQueryMetrics();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    }

    @Override
    public <T> T insert(T objectToSave, PartitionKey partitionKey) {
        Assert.notNull(objectToSave, (String)"entityClass should not be null");
        return this.insert(this.getCollectionName(objectToSave.getClass()), objectToSave, partitionKey);
    }

    @Override
    public <T> T insert(String collectionName, T objectToSave, PartitionKey partitionKey) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(objectToSave, (String)"objectToSave should not be null");
        CosmosItemProperties originalItem = this.mappingCosmosConverter.writeCosmosItemProperties(objectToSave);
        log.debug("execute createItem in database {} collection {}", (Object)this.databaseName, (Object)collectionName);
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        options.partitionKey(partitionKey);
        Class<?> domainClass = objectToSave.getClass();
        CosmosItemResponse response = (CosmosItemResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).createItem((Object)originalItem, options).doOnNext(cosmosItemResponse -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to insert item", throwable)).block();
        assert (response != null);
        return (T)this.mappingCosmosConverter.read(domainClass, response.properties());
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        return this.findById(this.getCollectionName(entityClass), id, entityClass);
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass, PartitionKey partitionKey) {
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        Assert.notNull((Object)partitionKey, (String)"partitionKey should not be null");
        this.assertValidId(id);
        String collectionName = this.getCollectionName(entityClass);
        return (T)this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).getItem(id.toString(), (Object)partitionKey).read().flatMap(cosmosItemResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse, null);
            return Mono.justOrEmpty(this.toDomainObject(entityClass, cosmosItemResponse.properties()));
        }).onErrorResume(throwable -> CosmosDBExceptionUtils.findAPIExceptionHandler("Failed to find item", throwable)).block();
    }

    @Override
    public <T> T findById(String collectionName, Object id, Class<T> domainClass) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(domainClass, (String)"entityClass should not be null");
        this.assertValidId(id);
        String query = String.format("select * from root where root.id = '%s'", id.toString());
        FeedOptions options = new FeedOptions();
        options.enableCrossPartitionQuery(Boolean.valueOf(true));
        options.populateQueryMetrics(this.isPopulateQueryMetrics);
        return (T)this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).queryItems(query, options).flatMap(cosmosItemFeedResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, cosmosItemFeedResponse);
            return Mono.justOrEmpty(cosmosItemFeedResponse.results().stream().map(cosmosItem -> this.mappingCosmosConverter.read(domainClass, (CosmosItemProperties)cosmosItem)).findFirst());
        }).onErrorResume(throwable -> CosmosDBExceptionUtils.findAPIExceptionHandler("Failed to find item", throwable)).blockFirst();
    }

    @Override
    public <T> void upsert(T object, PartitionKey partitionKey) {
        Assert.notNull(object, (String)"Upsert object should not be null");
        this.upsert(this.getCollectionName(object.getClass()), object, partitionKey);
    }

    @Override
    public <T> void upsert(String collectionName, T object, PartitionKey partitionKey) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(object, (String)"Upsert object should not be null");
        CosmosItemProperties originalItem = this.mappingCosmosConverter.writeCosmosItemProperties(object);
        log.debug("execute upsert item in database {} collection {}", (Object)this.databaseName, (Object)collectionName);
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        options.partitionKey(partitionKey);
        this.applyVersioning(object.getClass(), originalItem, options);
        CosmosItemResponse cosmosItemResponse = (CosmosItemResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).upsertItem((Object)originalItem, options).doOnNext(response -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to upsert item", throwable)).block();
        assert (cosmosItemResponse != null);
    }

    @Override
    public <T> List<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        return this.findAll(this.getCollectionName(entityClass), entityClass);
    }

    @Override
    public <T> List<T> findAll(String collectionName, Class<T> domainClass) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(domainClass, (String)"entityClass should not be null");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        List<CosmosItemProperties> items = this.findItems(query, domainClass, collectionName);
        return items.stream().map(d -> this.getConverter().read(domainClass, (CosmosItemProperties)d)).collect(Collectors.toList());
    }

    @Override
    public void deleteAll(@NonNull String collectionName, @NonNull Class<?> domainClass) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        this.delete(query, domainClass, collectionName);
    }

    @Override
    public void deleteCollection(@NonNull String collectionName) {
        Assert.hasText((String)collectionName, (String)"collectionName should have text.");
        this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).delete().doOnNext(response -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to delete collection", throwable)).block();
    }

    @Override
    public String getCollectionName(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"domainClass should not be null");
        return this.entityInfoCreator.apply(domainClass).getCollectionName();
    }

    @Override
    public CosmosContainerProperties createCollectionIfNotExists(@NonNull CosmosEntityInformation<?, ?> information) {
        CosmosContainerResponse response = (CosmosContainerResponse)this.cosmosClient.createDatabaseIfNotExists(this.databaseName).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to create database", throwable)).flatMap(cosmosDatabaseResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosDatabaseResponse, null);
            return cosmosDatabaseResponse.database().createContainerIfNotExists(information.getCollectionName(), "/" + information.getPartitionKeyFieldName(), information.getRequestUnit().intValue()).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to create container", throwable)).doOnNext(cosmosContainerResponse -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosContainerResponse, null));
        }).block();
        assert (response != null);
        return response.properties();
    }

    @Override
    public void deleteById(String collectionName, Object id, PartitionKey partitionKey) {
        Assert.hasText((String)collectionName, (String)"collectionName should not be null, empty or only whitespaces");
        this.assertValidId(id);
        log.debug("execute deleteById in database {} container {}", (Object)this.databaseName, (Object)collectionName);
        if (partitionKey == null) {
            partitionKey = PartitionKey.None;
        }
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        options.partitionKey(partitionKey);
        this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).getItem(id.toString(), (Object)partitionKey).delete(options).doOnNext(response -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to delete item", throwable)).block();
    }

    @Override
    public <T, ID> List<T> findByIds(Iterable<ID> ids, Class<T> entityClass, String collectionName) {
        Assert.notNull(ids, (String)"Id list should not be null");
        Assert.notNull(entityClass, (String)"entityClass should not be null.");
        Assert.hasText((String)collectionName, (String)"collection should not be null, empty or only whitespaces");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.IN, "id", Collections.singletonList(ids)));
        return this.find(query, entityClass, collectionName);
    }

    @Override
    public <T> List<T> find(@NonNull DocumentQuery query, @NonNull Class<T> domainClass, String collectionName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(domainClass, (String)"domainClass should not be null.");
        Assert.hasText((String)collectionName, (String)"container should not be null, empty or only whitespaces");
        return this.findItems(query, domainClass, collectionName).stream().map(cosmosItemProperties -> this.toDomainObject(domainClass, (CosmosItemProperties)cosmosItemProperties)).collect(Collectors.toList());
    }

    @Override
    public <T> Boolean exists(@NonNull DocumentQuery query, @NonNull Class<T> domainClass, String collectionName) {
        return this.find(query, domainClass, collectionName).size() > 0;
    }

    @Override
    public <T> List<T> delete(@NonNull DocumentQuery query, @NonNull Class<T> domainClass, @NonNull String collectionName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(domainClass, (String)"domainClass should not be null.");
        Assert.hasText((String)collectionName, (String)"container should not be null, empty or only whitespaces");
        List<CosmosItemProperties> results = this.findItems(query, domainClass, collectionName);
        List<String> partitionKeyName = this.getPartitionKeyNames(domainClass);
        return results.stream().map(cosmosItemProperties -> {
            CosmosItemResponse cosmosItemResponse = this.deleteItem((CosmosItemProperties)cosmosItemProperties, partitionKeyName, collectionName, domainClass);
            return this.getConverter().read(domainClass, cosmosItemResponse.properties());
        }).collect(Collectors.toList());
    }

    @Override
    public <T> Page<T> findAll(Pageable pageable, Class<T> domainClass, String collectionName) {
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL)).with(pageable);
        if (pageable.getSort().isSorted()) {
            query.with(pageable.getSort());
        }
        return this.paginationQuery(query, domainClass, collectionName);
    }

    @Override
    public <T> Page<T> paginationQuery(DocumentQuery query, Class<T> domainClass, String collectionName) {
        Assert.isTrue((query.getPageable().getPageSize() > 0 ? 1 : 0) != 0, (String)"pageable should have page size larger than 0");
        Assert.hasText((String)collectionName, (String)"container should not be null, empty or only whitespaces");
        Pageable pageable = query.getPageable();
        FeedOptions feedOptions = new FeedOptions();
        if (pageable instanceof CosmosPageRequest) {
            feedOptions.requestContinuation(((CosmosPageRequest)pageable).getRequestContinuation());
        }
        feedOptions.maxItemCount(Integer.valueOf(pageable.getPageSize()));
        feedOptions.enableCrossPartitionQuery(Boolean.valueOf(query.isCrossPartitionQuery(this.getPartitionKeyNames(domainClass))));
        feedOptions.populateQueryMetrics(this.isPopulateQueryMetrics);
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generateCosmos(query);
        FeedResponse feedResponse = (FeedResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).queryItems(sqlQuerySpec, feedOptions).doOnNext(propertiesFeedResponse -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, propertiesFeedResponse)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to query items", throwable)).next().block();
        assert (feedResponse != null);
        Iterator it = feedResponse.results().iterator();
        ArrayList<T> result = new ArrayList<T>();
        for (int index = 0; it.hasNext() && index < pageable.getPageSize(); ++index) {
            CosmosItemProperties cosmosItemProperties = (CosmosItemProperties)it.next();
            if (cosmosItemProperties == null) continue;
            T entity = this.mappingCosmosConverter.read(domainClass, cosmosItemProperties);
            result.add(entity);
        }
        long total = this.count(query, domainClass, collectionName);
        int contentSize = result.size();
        int pageSize = contentSize < pageable.getPageSize() && contentSize > 0 ? contentSize : pageable.getPageSize();
        CosmosPageRequest pageRequest = CosmosPageRequest.of(pageable.getOffset(), pageable.getPageNumber(), pageSize, feedResponse.continuationToken(), query.getSort());
        return new CosmosPageImpl(result, (Pageable)pageRequest, total);
    }

    @Override
    public long count(String collectionName) {
        Assert.hasText((String)collectionName, (String)"container name should not be empty");
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        Long count = this.getCountValue(query, true, collectionName);
        assert (count != null);
        return count;
    }

    @Override
    public <T> long count(DocumentQuery query, Class<T> domainClass, String collectionName) {
        Assert.notNull(domainClass, (String)"domainClass should not be null");
        Assert.hasText((String)collectionName, (String)"container name should not be empty");
        boolean isCrossPartitionQuery = query.isCrossPartitionQuery(this.getPartitionKeyNames(domainClass));
        Long count = this.getCountValue(query, isCrossPartitionQuery, collectionName);
        assert (count != null);
        return count;
    }

    @Override
    public MappingCosmosConverter getConverter() {
        return this.mappingCosmosConverter;
    }

    private Long getCountValue(DocumentQuery query, boolean isCrossPartitionQuery, String containerName) {
        SqlQuerySpec querySpec = new CountQueryGenerator().generateCosmos(query);
        FeedOptions options = new FeedOptions();
        options.enableCrossPartitionQuery(Boolean.valueOf(isCrossPartitionQuery));
        options.populateQueryMetrics(this.isPopulateQueryMetrics);
        return (Long)this.executeQuery(querySpec, containerName, options).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to get count value", throwable)).doOnNext(response -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, response)).next().map(r -> ((CosmosItemProperties)r.results().get(0)).getLong(COUNT_VALUE_KEY)).block();
    }

    private Flux<FeedResponse<CosmosItemProperties>> executeQuery(SqlQuerySpec sqlQuerySpec, String collectionName, FeedOptions options) {
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).queryItems(sqlQuerySpec, options).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to execute query", throwable));
    }

    private List<String> getPartitionKeyNames(Class<?> domainClass) {
        CosmosEntityInformation<?, ?> entityInfo = this.entityInfoCreator.apply(domainClass);
        if (entityInfo.getPartitionKeyFieldName() == null) {
            return new ArrayList<String>();
        }
        return Collections.singletonList(entityInfo.getPartitionKeyFieldName());
    }

    private void assertValidId(Object id) {
        Assert.notNull((Object)id, (String)"id should not be null");
        if (id instanceof String) {
            Assert.hasText((String)id.toString(), (String)"id should not be empty or only whitespaces.");
        }
    }

    private List<CosmosItemProperties> findItems(@NonNull DocumentQuery query, @NonNull Class<?> domainClass, @NonNull String containerName) {
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generateCosmos(query);
        boolean isCrossPartitionQuery = query.isCrossPartitionQuery(this.getPartitionKeyNames(domainClass));
        FeedOptions feedOptions = new FeedOptions();
        feedOptions.enableCrossPartitionQuery(Boolean.valueOf(isCrossPartitionQuery));
        feedOptions.populateQueryMetrics(this.isPopulateQueryMetrics);
        return (List)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(sqlQuerySpec, feedOptions).flatMap(cosmosItemFeedResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, cosmosItemFeedResponse);
            return Flux.fromIterable((Iterable)cosmosItemFeedResponse.results());
        }).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to find items", throwable)).collectList().block();
    }

    private CosmosItemResponse deleteItem(@NonNull CosmosItemProperties cosmosItemProperties, @NonNull List<String> partitionKeyNames, String containerName, @NonNull Class<?> domainClass) {
        Assert.isTrue((partitionKeyNames.size() <= 1 ? 1 : 0) != 0, (String)"Only one Partition is supported.");
        PartitionKey partitionKey = null;
        if (!partitionKeyNames.isEmpty() && StringUtils.hasText((String)partitionKeyNames.get(0))) {
            partitionKey = new PartitionKey(cosmosItemProperties.get(partitionKeyNames.get(0)));
        }
        if (partitionKey == null) {
            partitionKey = PartitionKey.None;
        }
        CosmosItemRequestOptions options = new CosmosItemRequestOptions((Object)partitionKey);
        this.applyVersioning(domainClass, cosmosItemProperties, options);
        return (CosmosItemResponse)this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).getItem(cosmosItemProperties.id(), (Object)partitionKey).delete(options).doOnNext(response -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, response, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to delete item", throwable)).block();
    }

    private <T> T toDomainObject(@NonNull Class<T> domainClass, CosmosItemProperties cosmosItemProperties) {
        return this.mappingCosmosConverter.read(domainClass, cosmosItemProperties);
    }

    private void applyVersioning(Class<?> domainClass, CosmosItemProperties cosmosItemProperties, CosmosItemRequestOptions options) {
        if (this.entityInfoCreator.apply(domainClass).isVersioned()) {
            AccessCondition accessCondition = new AccessCondition();
            accessCondition.type(AccessConditionType.IF_MATCH);
            accessCondition.condition(cosmosItemProperties.etag());
            options.accessCondition(accessCondition);
        }
    }

    private CosmosEntityInformation<?, ?> getCosmosEntityInformation(Class<?> domainClass) {
        return new CosmosEntityInformation(domainClass);
    }
}

