/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core;

import com.azure.data.cosmos.CosmosClient;
import com.azure.data.cosmos.CosmosContainerResponse;
import com.azure.data.cosmos.CosmosItemProperties;
import com.azure.data.cosmos.CosmosItemRequestOptions;
import com.azure.data.cosmos.FeedOptions;
import com.azure.data.cosmos.FeedResponse;
import com.azure.data.cosmos.PartitionKey;
import com.azure.data.cosmos.SqlQuerySpec;
import com.microsoft.azure.spring.data.cosmosdb.CosmosDbFactory;
import com.microsoft.azure.spring.data.cosmosdb.common.CosmosdbUtils;
import com.microsoft.azure.spring.data.cosmosdb.core.ReactiveCosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.ResponseDiagnosticsProcessor;
import com.microsoft.azure.spring.data.cosmosdb.core.convert.MappingCosmosConverter;
import com.microsoft.azure.spring.data.cosmosdb.core.generator.CountQueryGenerator;
import com.microsoft.azure.spring.data.cosmosdb.core.generator.FindQuerySpecGenerator;
import com.microsoft.azure.spring.data.cosmosdb.core.query.Criteria;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CriteriaType;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.exception.CosmosDBExceptionUtils;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.CosmosEntityInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveCosmosTemplate
implements ReactiveCosmosOperations,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ReactiveCosmosTemplate.class);
    private static final String COUNT_VALUE_KEY = "_aggregate";
    private final MappingCosmosConverter mappingCosmosConverter;
    private final String databaseName;
    private final CosmosClient cosmosClient;
    private final ResponseDiagnosticsProcessor responseDiagnosticsProcessor;
    private final boolean isPopulateQueryMetrics;
    private final List<String> collectionCache;

    public ReactiveCosmosTemplate(CosmosDbFactory cosmosDbFactory, MappingCosmosConverter mappingCosmosConverter, String dbName) {
        Assert.notNull((Object)cosmosDbFactory, (String)"CosmosDbFactory must not be null!");
        Assert.notNull((Object)mappingCosmosConverter, (String)"MappingCosmosConverter must not be null!");
        this.mappingCosmosConverter = mappingCosmosConverter;
        this.databaseName = dbName;
        this.collectionCache = new ArrayList<String>();
        this.cosmosClient = cosmosDbFactory.getCosmosClient();
        this.responseDiagnosticsProcessor = cosmosDbFactory.getConfig().getResponseDiagnosticsProcessor();
        this.isPopulateQueryMetrics = cosmosDbFactory.getConfig().isPopulateQueryMetrics();
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
    }

    @Override
    public Mono<CosmosContainerResponse> createCollectionIfNotExists(CosmosEntityInformation information) {
        return this.cosmosClient.createDatabaseIfNotExists(this.databaseName).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to create database", throwable)).flatMap(cosmosDatabaseResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosDatabaseResponse, null);
            return cosmosDatabaseResponse.database().createContainerIfNotExists(information.getCollectionName(), "/" + information.getPartitionKeyFieldName(), information.getRequestUnit().intValue()).map(cosmosContainerResponse -> {
                CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosContainerResponse, null);
                this.collectionCache.add(information.getCollectionName());
                return cosmosContainerResponse;
            }).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to create collection", throwable));
        });
    }

    @Override
    public <T> Flux<T> findAll(String containerName, Class<T> entityClass) {
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        return this.find(query, entityClass, containerName);
    }

    @Override
    public <T> Flux<T> findAll(Class<T> entityClass) {
        return this.findAll(entityClass.getSimpleName(), entityClass);
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        return this.findById(this.getContainerName(entityClass), id, entityClass);
    }

    @Override
    public <T> Mono<T> findById(String containerName, Object id, Class<T> entityClass) {
        Assert.hasText((String)containerName, (String)"collectionName should not be null, empty or only whitespaces");
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        this.assertValidId(id);
        String query = String.format("select * from root where root.id = '%s'", id.toString());
        FeedOptions options = new FeedOptions();
        options.enableCrossPartitionQuery(Boolean.valueOf(true));
        options.populateQueryMetrics(this.isPopulateQueryMetrics);
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(query, options).flatMap(cosmosItemFeedResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, cosmosItemFeedResponse);
            return Mono.justOrEmpty(cosmosItemFeedResponse.results().stream().map(cosmosItem -> this.toDomainObject(entityClass, (CosmosItemProperties)cosmosItem)).findFirst());
        }).onErrorResume(throwable -> CosmosDBExceptionUtils.findAPIExceptionHandler("Failed to find item", throwable)).next();
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass, PartitionKey partitionKey) {
        Assert.notNull(entityClass, (String)"entityClass should not be null");
        this.assertValidId(id);
        String containerName = this.getContainerName(entityClass);
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).getItem(id.toString(), (Object)partitionKey).read().flatMap(cosmosItemResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse, null);
            return Mono.justOrEmpty(this.toDomainObject(entityClass, cosmosItemResponse.properties()));
        }).onErrorResume(throwable -> CosmosDBExceptionUtils.findAPIExceptionHandler("Failed to find item", throwable));
    }

    @Override
    public <T> Mono<T> insert(T objectToSave, PartitionKey partitionKey) {
        Assert.notNull(objectToSave, (String)"entityClass should not be null");
        return this.insert(this.getContainerName(objectToSave.getClass()), objectToSave, partitionKey);
    }

    public <T> Mono<T> insert(T objectToSave) {
        Assert.notNull(objectToSave, (String)"objectToSave should not be null");
        Class<?> domainClass = objectToSave.getClass();
        CosmosItemProperties originalItem = this.mappingCosmosConverter.writeCosmosItemProperties(objectToSave);
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(this.getContainerName(objectToSave.getClass())).createItem((Object)originalItem, new CosmosItemRequestOptions()).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to insert item", throwable)).flatMap(cosmosItemResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse, null);
            return Mono.just(this.toDomainObject(domainClass, cosmosItemResponse.properties()));
        });
    }

    @Override
    public <T> Mono<T> insert(String containerName, Object objectToSave, PartitionKey partitionKey) {
        Assert.hasText((String)containerName, (String)"containerName should not be null, empty or only whitespaces");
        Assert.notNull((Object)objectToSave, (String)"objectToSave should not be null");
        Class<?> domainClass = objectToSave.getClass();
        CosmosItemProperties originalItem = this.mappingCosmosConverter.writeCosmosItemProperties(objectToSave);
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        if (partitionKey != null) {
            options.partitionKey(partitionKey);
        }
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).createItem((Object)originalItem, options).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to insert item", throwable)).flatMap(cosmosItemResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse, null);
            return Mono.just(this.toDomainObject(domainClass, cosmosItemResponse.properties()));
        });
    }

    @Override
    public <T> Mono<T> upsert(T object, PartitionKey partitionKey) {
        return this.upsert(this.getContainerName(object.getClass()), object, partitionKey);
    }

    @Override
    public <T> Mono<T> upsert(String containerName, T object, PartitionKey partitionKey) {
        Class<?> domainClass = object.getClass();
        CosmosItemProperties originalItem = this.mappingCosmosConverter.writeCosmosItemProperties(object);
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        if (partitionKey != null) {
            options.partitionKey(partitionKey);
        }
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).upsertItem((Object)originalItem, options).flatMap(cosmosItemResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse, null);
            return Mono.just(this.toDomainObject(domainClass, cosmosItemResponse.properties()));
        }).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to upsert item", throwable));
    }

    @Override
    public Mono<Void> deleteById(String containerName, Object id, PartitionKey partitionKey) {
        Assert.hasText((String)containerName, (String)"container name should not be null, empty or only whitespaces");
        this.assertValidId(id);
        if (partitionKey == null) {
            partitionKey = PartitionKey.None;
        }
        CosmosItemRequestOptions options = new CosmosItemRequestOptions();
        options.partitionKey(partitionKey);
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).getItem(id.toString(), (Object)partitionKey).delete(options).doOnNext(cosmosItemResponse -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to delete item", throwable)).then();
    }

    @Override
    public Mono<Void> deleteAll(String containerName, String partitionKeyName) {
        Assert.hasText((String)containerName, (String)"container name should not be null, empty or only whitespaces");
        Assert.notNull((Object)partitionKeyName, (String)"partitionKeyName should not be null");
        Criteria criteria = Criteria.getInstance(CriteriaType.ALL);
        DocumentQuery query = new DocumentQuery(criteria);
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generateCosmos(query);
        FeedOptions options = new FeedOptions();
        boolean isCrossPartitionQuery = query.isCrossPartitionQuery(Collections.singletonList(partitionKeyName));
        options.enableCrossPartitionQuery(Boolean.valueOf(isCrossPartitionQuery));
        options.populateQueryMetrics(this.isPopulateQueryMetrics);
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(sqlQuerySpec, options).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to query items", throwable)).flatMap(cosmosItemFeedResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, cosmosItemFeedResponse);
            return Flux.fromIterable((Iterable)cosmosItemFeedResponse.results());
        }).flatMap(cosmosItemProperties -> this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).getItem(cosmosItemProperties.id(), cosmosItemProperties.get(partitionKeyName)).delete().doOnNext(cosmosItemResponse -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to delete items", throwable))).then();
    }

    @Override
    public <T> Flux<T> delete(DocumentQuery query, Class<T> entityClass, String containerName) {
        Assert.notNull((Object)query, (String)"DocumentQuery should not be null.");
        Assert.notNull(entityClass, (String)"domainClass should not be null.");
        Assert.hasText((String)containerName, (String)"container name should not be null, empty or only whitespaces");
        Flux<CosmosItemProperties> results = this.findItems(query, entityClass, containerName);
        List<String> partitionKeyName = this.getPartitionKeyNames(entityClass);
        return results.flatMap(d -> this.deleteItem((CosmosItemProperties)d, partitionKeyName, containerName)).flatMap(cosmosItemProperties -> Mono.just(this.toDomainObject(entityClass, (CosmosItemProperties)cosmosItemProperties)));
    }

    @Override
    public <T> Flux<T> find(DocumentQuery query, Class<T> entityClass, String containerName) {
        return this.findItems(query, entityClass, containerName).map(cosmosItemProperties -> this.toDomainObject(entityClass, (CosmosItemProperties)cosmosItemProperties));
    }

    @Override
    public Mono<Boolean> exists(DocumentQuery query, Class<?> entityClass, String containerName) {
        return this.count(query, true, containerName).flatMap(count -> Mono.just((Object)(count > 0L ? 1 : 0)));
    }

    @Override
    public Mono<Boolean> existsById(Object id, Class<?> entityClass, String containerName) {
        return this.findById(containerName, id, entityClass).flatMap(o -> Mono.just((Object)(o != null ? 1 : 0)));
    }

    @Override
    public Mono<Long> count(String containerName) {
        DocumentQuery query = new DocumentQuery(Criteria.getInstance(CriteriaType.ALL));
        return this.count(query, true, containerName);
    }

    @Override
    public Mono<Long> count(DocumentQuery query, String containerName) {
        return this.count(query, true, containerName);
    }

    @Override
    public MappingCosmosConverter getConverter() {
        return this.mappingCosmosConverter;
    }

    public Mono<Long> count(DocumentQuery query, boolean isCrossPartitionQuery, String containerName) {
        return this.getCountValue(query, isCrossPartitionQuery, containerName);
    }

    private Mono<Long> getCountValue(DocumentQuery query, boolean isCrossPartitionQuery, String containerName) {
        SqlQuerySpec querySpec = new CountQueryGenerator().generateCosmos(query);
        FeedOptions options = new FeedOptions();
        options.enableCrossPartitionQuery(Boolean.valueOf(isCrossPartitionQuery));
        options.populateQueryMetrics(this.isPopulateQueryMetrics);
        return this.executeQuery(querySpec, containerName, options).doOnNext(feedResponse -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, feedResponse)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to get count value", throwable)).next().map(r -> ((CosmosItemProperties)r.results().get(0)).getLong(COUNT_VALUE_KEY));
    }

    private Flux<FeedResponse<CosmosItemProperties>> executeQuery(SqlQuerySpec sqlQuerySpec, String collectionName, FeedOptions options) {
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(collectionName).queryItems(sqlQuerySpec, options).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to execute query", throwable));
    }

    @Override
    public void deleteContainer(@NonNull String containerName) {
        Assert.hasText((String)containerName, (String)"containerName should have text.");
        this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).delete().doOnNext(cosmosContainerResponse -> CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosContainerResponse, null)).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to delete container", throwable)).block();
        this.collectionCache.remove(containerName);
    }

    @Override
    public String getContainerName(Class<?> domainClass) {
        Assert.notNull(domainClass, (String)"domainClass should not be null");
        return new CosmosEntityInformation(domainClass).getCollectionName();
    }

    private Flux<CosmosItemProperties> findItems(@NonNull DocumentQuery query, @NonNull Class<?> domainClass, @NonNull String containerName) {
        SqlQuerySpec sqlQuerySpec = new FindQuerySpecGenerator().generateCosmos(query);
        boolean isCrossPartitionQuery = query.isCrossPartitionQuery(this.getPartitionKeyNames(domainClass));
        FeedOptions feedOptions = new FeedOptions();
        feedOptions.enableCrossPartitionQuery(Boolean.valueOf(isCrossPartitionQuery));
        feedOptions.populateQueryMetrics(this.isPopulateQueryMetrics);
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).queryItems(sqlQuerySpec, feedOptions).flatMap(cosmosItemFeedResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, null, cosmosItemFeedResponse);
            return Flux.fromIterable((Iterable)cosmosItemFeedResponse.results());
        }).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to query items", throwable));
    }

    private void assertValidId(Object id) {
        Assert.notNull((Object)id, (String)"id should not be null");
        if (id instanceof String) {
            Assert.hasText((String)id.toString(), (String)"id should not be empty or only whitespaces.");
        }
    }

    private List<String> getPartitionKeyNames(Class<?> domainClass) {
        CosmosEntityInformation entityInfo = new CosmosEntityInformation(domainClass);
        if (entityInfo.getPartitionKeyFieldName() == null) {
            return new ArrayList<String>();
        }
        return Collections.singletonList(entityInfo.getPartitionKeyFieldName());
    }

    private Mono<CosmosItemProperties> deleteItem(@NonNull CosmosItemProperties cosmosItemProperties, @NonNull List<String> partitionKeyNames, String containerName) {
        Assert.isTrue((partitionKeyNames.size() <= 1 ? 1 : 0) != 0, (String)"Only one Partition is supported.");
        PartitionKey partitionKey = null;
        if (!partitionKeyNames.isEmpty() && StringUtils.hasText((String)partitionKeyNames.get(0))) {
            partitionKey = new PartitionKey(cosmosItemProperties.get(partitionKeyNames.get(0)));
        }
        CosmosItemRequestOptions options = new CosmosItemRequestOptions(partitionKey);
        return this.cosmosClient.getDatabase(this.databaseName).getContainer(containerName).getItem(cosmosItemProperties.id(), (Object)partitionKey).delete(options).map(cosmosItemResponse -> {
            CosmosdbUtils.fillAndProcessResponseDiagnostics(this.responseDiagnosticsProcessor, cosmosItemResponse, null);
            return cosmosItemProperties;
        }).onErrorResume(throwable -> CosmosDBExceptionUtils.exceptionHandler("Failed to delete item", throwable));
    }

    private <T> T toDomainObject(@NonNull Class<T> domainClass, CosmosItemProperties cosmosItemProperties) {
        return this.mappingCosmosConverter.read(domainClass, cosmosItemProperties);
    }
}

