/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.core.query;

import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.springframework.data.repository.query.parser.Part;

public enum CriteriaType {
    ALL(""),
    IS_EQUAL("="),
    OR("OR"),
    AND("AND"),
    NOT("<>"),
    BEFORE("<"),
    AFTER(">"),
    IN("IN"),
    NOT_IN("NOT IN"),
    IS_NULL("IS_NULL"),
    IS_NOT_NULL("NOT IS_NULL"),
    LESS_THAN("<"),
    LESS_THAN_EQUAL("<="),
    GREATER_THAN(">"),
    GREATER_THAN_EQUAL(">="),
    CONTAINING("CONTAINS"),
    ENDS_WITH("ENDSWITH"),
    STARTS_WITH("STARTSWITH"),
    TRUE("= true"),
    FALSE("= false"),
    BETWEEN("BETWEEN");

    private String sqlKeyword;
    private static final Map<Part.Type, CriteriaType> PART_TREE_TYPE_TO_CRITERIA;

    public static boolean isPartTypeUnSupported(@NonNull Part.Type partType) {
        if (partType == null) {
            throw new NullPointerException("partType");
        }
        return !CriteriaType.isPartTypeSupported(partType);
    }

    public static boolean isPartTypeSupported(@NonNull Part.Type partType) {
        if (partType == null) {
            throw new NullPointerException("partType");
        }
        return PART_TREE_TYPE_TO_CRITERIA.containsKey(partType);
    }

    public static CriteriaType toCriteriaType(@NonNull Part.Type partType) {
        if (partType == null) {
            throw new NullPointerException("partType");
        }
        CriteriaType criteriaType = PART_TREE_TYPE_TO_CRITERIA.get(partType);
        if (criteriaType == null) {
            throw new UnsupportedOperationException("Unsupported part type: " + partType);
        }
        return criteriaType;
    }

    public static boolean isClosed(CriteriaType type) {
        switch (type) {
            case AND: 
            case OR: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinary(CriteriaType type) {
        switch (type) {
            case AND: 
            case OR: 
            case IN: 
            case NOT_IN: 
            case NOT: 
            case IS_EQUAL: 
            case BEFORE: 
            case AFTER: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case CONTAINING: 
            case ENDS_WITH: 
            case STARTS_WITH: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFunction(CriteriaType type) {
        switch (type) {
            case CONTAINING: 
            case ENDS_WITH: 
            case STARTS_WITH: 
            case IS_NULL: 
            case IS_NOT_NULL: {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnary(CriteriaType type) {
        switch (type) {
            case IS_NULL: 
            case IS_NOT_NULL: 
            case TRUE: 
            case FALSE: {
                return true;
            }
        }
        return false;
    }

    @ConstructorProperties(value={"sqlKeyword"})
    private CriteriaType(String sqlKeyword) {
        this.sqlKeyword = sqlKeyword;
    }

    public String getSqlKeyword() {
        return this.sqlKeyword;
    }

    static {
        HashMap<Part.Type, CriteriaType> map = new HashMap<Part.Type, CriteriaType>();
        map.put(Part.Type.NEGATING_SIMPLE_PROPERTY, NOT);
        map.put(Part.Type.IS_NULL, IS_NULL);
        map.put(Part.Type.IS_NOT_NULL, IS_NOT_NULL);
        map.put(Part.Type.SIMPLE_PROPERTY, IS_EQUAL);
        map.put(Part.Type.BEFORE, BEFORE);
        map.put(Part.Type.AFTER, AFTER);
        map.put(Part.Type.IN, IN);
        map.put(Part.Type.NOT_IN, NOT_IN);
        map.put(Part.Type.GREATER_THAN, GREATER_THAN);
        map.put(Part.Type.CONTAINING, CONTAINING);
        map.put(Part.Type.ENDING_WITH, ENDS_WITH);
        map.put(Part.Type.STARTING_WITH, STARTS_WITH);
        map.put(Part.Type.GREATER_THAN_EQUAL, GREATER_THAN_EQUAL);
        map.put(Part.Type.LESS_THAN, LESS_THAN);
        map.put(Part.Type.LESS_THAN_EQUAL, LESS_THAN_EQUAL);
        map.put(Part.Type.TRUE, TRUE);
        map.put(Part.Type.FALSE, FALSE);
        map.put(Part.Type.BETWEEN, BETWEEN);
        PART_TREE_TYPE_TO_CRITERIA = Collections.unmodifiableMap(map);
    }
}

