/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.query;

import com.microsoft.azure.spring.data.cosmosdb.core.ReactiveCosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.ReactiveCosmosEntityMetadata;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.ReactiveCosmosParameterAccessor;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.ReactiveCosmosParameterParameterAccessor;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.ReactiveCosmosQueryExecution;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.ReactiveCosmosQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;

public abstract class AbstractReactiveCosmosQuery
implements RepositoryQuery {
    private final ReactiveCosmosQueryMethod method;
    private final ReactiveCosmosOperations operations;

    public AbstractReactiveCosmosQuery(ReactiveCosmosQueryMethod method, ReactiveCosmosOperations operations) {
        this.method = method;
        this.operations = operations;
    }

    public Object execute(Object[] parameters) {
        ReactiveCosmosParameterParameterAccessor accessor = new ReactiveCosmosParameterParameterAccessor(this.method, parameters);
        DocumentQuery query = this.createQuery(accessor);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        String collection = ((ReactiveCosmosEntityMetadata)this.method.getEntityInformation()).getCollectionName();
        ReactiveCosmosQueryExecution execution = this.getExecution(accessor);
        return execution.execute(query, processor.getReturnedType().getDomainType(), collection);
    }

    private ReactiveCosmosQueryExecution getExecution(ReactiveCosmosParameterAccessor accessor) {
        if (this.isDeleteQuery()) {
            return new ReactiveCosmosQueryExecution.DeleteExecution(this.operations);
        }
        if (this.method.isPageQuery()) {
            throw new IllegalArgumentException("Paged Query is not supported by reactive cosmos db");
        }
        if (this.isExistsQuery()) {
            return new ReactiveCosmosQueryExecution.ExistsExecution(this.operations);
        }
        return new ReactiveCosmosQueryExecution.MultiEntityExecution(this.operations);
    }

    public ReactiveCosmosQueryMethod getQueryMethod() {
        return this.method;
    }

    protected abstract DocumentQuery createQuery(ReactiveCosmosParameterAccessor var1);

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isExistsQuery();
}

