/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.query;

import com.microsoft.azure.spring.data.cosmosdb.core.CosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.query.CosmosPageRequest;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import org.springframework.data.domain.Pageable;

public interface CosmosQueryExecution {
    public Object execute(DocumentQuery var1, Class<?> var2, String var3);

    public static final class PagedExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;
        private final Pageable pageable;

        public PagedExecution(CosmosOperations operations, Pageable pageable) {
            this.operations = operations;
            this.pageable = pageable;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String collection) {
            if (this.pageable.getPageNumber() != 0 && !(this.pageable instanceof CosmosPageRequest)) {
                throw new IllegalStateException("Not the first page but Pageable is not a valid CosmosPageRequest, requestContinuation is required for non first page request");
            }
            query.with(this.pageable);
            return this.operations.paginationQuery(query, type, collection);
        }
    }

    public static final class DeleteExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;

        public DeleteExecution(CosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String collection) {
            return this.operations.delete(query, type, collection);
        }
    }

    public static final class ExistsExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;

        public ExistsExecution(CosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String collection) {
            return this.operations.exists(query, type, collection);
        }
    }

    public static final class MultiEntityExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;

        public MultiEntityExecution(CosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String collection) {
            return this.operations.find(query, type, collection);
        }
    }

    public static final class CollectionExecution
    implements CosmosQueryExecution {
        private final CosmosOperations operations;

        public CollectionExecution(CosmosOperations operations) {
            this.operations = operations;
        }

        @Override
        public Object execute(DocumentQuery query, Class<?> type, String collection) {
            return this.operations.getCollectionName(type);
        }
    }
}

