/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.exception;

import com.azure.data.cosmos.CosmosClientException;
import com.microsoft.azure.spring.data.cosmosdb.exception.CosmosDBAccessException;
import org.springframework.util.StringUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;

public class CosmosDBExceptionUtils {
    public static <T> Mono<T> exceptionHandler(String message, Throwable throwable) {
        if (StringUtils.isEmpty((Object)message)) {
            message = "Failed to access cosmosdb database";
        }
        Throwable unwrappedThrowable = Exceptions.unwrap((Throwable)throwable);
        throw new CosmosDBAccessException(message, unwrappedThrowable);
    }

    public static <T> Mono<T> findAPIExceptionHandler(String message, Throwable throwable) {
        CosmosClientException cosmosClientException;
        Throwable unwrappedThrowable = Exceptions.unwrap((Throwable)throwable);
        if (unwrappedThrowable instanceof CosmosClientException && (cosmosClientException = (CosmosClientException)unwrappedThrowable).statusCode() == 404) {
            return Mono.empty();
        }
        return CosmosDBExceptionUtils.exceptionHandler(message, unwrappedThrowable);
    }
}

