/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.query;

import com.microsoft.azure.spring.data.cosmosdb.core.CosmosOperations;
import com.microsoft.azure.spring.data.cosmosdb.core.mapping.CosmosPersistentProperty;
import com.microsoft.azure.spring.data.cosmosdb.core.query.DocumentQuery;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.AbstractCosmosQuery;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.CosmosParameterAccessor;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.CosmosQueryCreator;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.CosmosQueryMethod;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeCosmosQuery
extends AbstractCosmosQuery {
    private final PartTree tree;
    private final MappingContext<?, CosmosPersistentProperty> mappingContext;
    private final ResultProcessor processor;

    public PartTreeCosmosQuery(CosmosQueryMethod method, CosmosOperations operations) {
        super(method, operations);
        this.processor = method.getResultProcessor();
        this.tree = new PartTree(method.getName(), this.processor.getReturnedType().getDomainType());
        this.mappingContext = operations.getConverter().getMappingContext();
    }

    @Override
    protected DocumentQuery createQuery(CosmosParameterAccessor accessor) {
        CosmosQueryCreator creator = new CosmosQueryCreator(this.tree, accessor, this.mappingContext);
        DocumentQuery query = (DocumentQuery)creator.createQuery();
        if (this.tree.isLimiting()) {
            throw new NotImplementedException("Limiting is not supported.");
        }
        return query;
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.tree.isDelete();
    }

    @Override
    protected boolean isExistsQuery() {
        return this.tree.isExistsProjection();
    }
}

