/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.eventhub.checkpoint;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventprocessorhost.PartitionContext;
import com.microsoft.azure.spring.integration.core.api.CheckpointConfig;
import com.microsoft.azure.spring.integration.core.api.CheckpointMode;
import com.microsoft.azure.spring.integration.eventhub.checkpoint.CheckpointManager;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class BatchCheckpointManager
extends CheckpointManager {
    private static final Logger log = LoggerFactory.getLogger(BatchCheckpointManager.class);
    private final ConcurrentHashMap<String, EventData> lastEventByPartition = new ConcurrentHashMap();

    BatchCheckpointManager(CheckpointConfig checkpointConfig) {
        super(checkpointConfig);
        Assert.isTrue((this.checkpointConfig.getCheckpointMode() == CheckpointMode.BATCH ? 1 : 0) != 0, () -> "BatchCheckpointManager should have checkpointMode batch");
    }

    @Override
    public void onMessage(PartitionContext context, EventData eventData) {
        this.lastEventByPartition.put(context.getPartitionId(), eventData);
    }

    @Override
    public void completeBatch(PartitionContext context) {
        EventData eventData = this.lastEventByPartition.get(context.getPartitionId());
        context.checkpoint().whenComplete((v, t) -> {
            if (t != null) {
                this.logCheckpointFail(context, eventData, (Throwable)t);
            } else {
                this.logCheckpointSuccess(context, eventData);
            }
        });
    }

    @Override
    protected Logger getLogger() {
        return log;
    }
}

