/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.eventhub.checkpoint;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventprocessorhost.PartitionContext;
import com.microsoft.azure.spring.integration.core.api.CheckpointConfig;
import com.microsoft.azure.spring.integration.core.api.CheckpointMode;
import com.microsoft.azure.spring.integration.eventhub.checkpoint.CheckpointManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class PartitionCountCheckpointManager
extends CheckpointManager {
    private static final Logger log = LoggerFactory.getLogger(PartitionCountCheckpointManager.class);
    private final ConcurrentHashMap<String, AtomicInteger> countByPartition = new ConcurrentHashMap();

    PartitionCountCheckpointManager(CheckpointConfig checkpointConfig) {
        super(checkpointConfig);
        Assert.isTrue((this.checkpointConfig.getCheckpointMode() == CheckpointMode.PARTITION_COUNT ? 1 : 0) != 0, () -> "PartitionCountCheckpointManager should have checkpointMode partition_count");
    }

    @Override
    public void onMessage(PartitionContext context, EventData eventData) {
        String partitionId = context.getPartitionId();
        this.countByPartition.computeIfAbsent(partitionId, k -> new AtomicInteger(0));
        AtomicInteger count = this.countByPartition.get(partitionId);
        if (count.incrementAndGet() >= this.checkpointConfig.getCheckpointCount()) {
            context.checkpoint(eventData).whenComplete((v, t) -> {
                if (t != null) {
                    this.logCheckpointFail(context, eventData, (Throwable)t);
                } else {
                    this.logCheckpointSuccess(context, eventData);
                    count.set(0);
                }
            });
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }
}

