/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.eventhub.checkpoint;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventprocessorhost.PartitionContext;
import com.microsoft.azure.spring.integration.core.api.CheckpointConfig;
import com.microsoft.azure.spring.integration.core.api.CheckpointMode;
import com.microsoft.azure.spring.integration.eventhub.checkpoint.CheckpointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class RecordCheckpointManager
extends CheckpointManager {
    private static final Logger log = LoggerFactory.getLogger(RecordCheckpointManager.class);

    RecordCheckpointManager(CheckpointConfig checkpointConfig) {
        super(checkpointConfig);
        Assert.isTrue((this.checkpointConfig.getCheckpointMode() == CheckpointMode.RECORD ? 1 : 0) != 0, () -> "RecordCheckpointManager should have checkpointMode record");
    }

    @Override
    public void onMessage(PartitionContext context, EventData eventData) {
        context.checkpoint(eventData).whenComplete((v, t) -> {
            if (t != null) {
                this.logCheckpointFail(context, eventData, (Throwable)t);
            } else {
                this.logCheckpointSuccess(context, eventData);
            }
        });
    }

    @Override
    protected Logger getLogger() {
        return log;
    }
}

