/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.eventhub.checkpoint;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventprocessorhost.PartitionContext;
import com.microsoft.azure.spring.integration.core.api.CheckpointConfig;
import com.microsoft.azure.spring.integration.core.api.CheckpointMode;
import com.microsoft.azure.spring.integration.eventhub.checkpoint.CheckpointManager;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

class TimeCheckpointManager
extends CheckpointManager {
    private static final Logger log = LoggerFactory.getLogger(TimeCheckpointManager.class);
    private final AtomicReference<LocalDateTime> lastCheckpointTime = new AtomicReference<LocalDateTime>(LocalDateTime.now());

    TimeCheckpointManager(CheckpointConfig checkpointConfig) {
        super(checkpointConfig);
        Assert.isTrue((this.checkpointConfig.getCheckpointMode() == CheckpointMode.TIME ? 1 : 0) != 0, () -> "TimeCheckpointManager should have checkpointMode time");
    }

    @Override
    public void onMessage(PartitionContext context, EventData eventData) {
        LocalDateTime now = LocalDateTime.now();
        if (Duration.between(now, this.lastCheckpointTime.get()).compareTo(this.checkpointConfig.getCheckpointInterval()) > 0) {
            context.checkpoint(eventData).whenComplete((v, t) -> {
                if (t != null) {
                    this.logCheckpointFail(context, eventData, (Throwable)t);
                } else {
                    this.logCheckpointSuccess(context, eventData);
                    this.lastCheckpointTime.set(now);
                }
            });
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }
}

