/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.eventhub.impl;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventprocessorhost.CloseReason;
import com.microsoft.azure.eventprocessorhost.IEventProcessor;
import com.microsoft.azure.eventprocessorhost.PartitionContext;
import com.microsoft.azure.spring.integration.core.AzureCheckpointer;
import com.microsoft.azure.spring.integration.core.api.CheckpointConfig;
import com.microsoft.azure.spring.integration.core.api.CheckpointMode;
import com.microsoft.azure.spring.integration.eventhub.checkpoint.CheckpointManager;
import com.microsoft.azure.spring.integration.eventhub.converter.EventHubMessageConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;

public class EventHubProcessor
implements IEventProcessor {
    private static final Logger log = LoggerFactory.getLogger(EventHubProcessor.class);
    private final Consumer<Message<?>> consumer;
    private final Class<?> payloadType;
    private final CheckpointConfig checkpointConfig;
    private final EventHubMessageConverter messageConverter;
    private final CheckpointManager checkpointManager;

    public EventHubProcessor(Consumer<Message<?>> consumer, Class<?> payloadType, CheckpointConfig checkpointConfig, EventHubMessageConverter messageConverter) {
        this.consumer = consumer;
        this.payloadType = payloadType;
        this.checkpointConfig = checkpointConfig;
        this.messageConverter = messageConverter;
        this.checkpointManager = CheckpointManager.of(checkpointConfig);
    }

    public void onOpen(PartitionContext context) throws Exception {
        log.info("Partition {} is opening", (Object)context.getPartitionId());
    }

    public void onClose(PartitionContext context, CloseReason reason) throws Exception {
        log.info("Partition {} is closing for reason {}", (Object)context.getPartitionId(), (Object)reason);
    }

    public void onEvents(PartitionContext context, Iterable<EventData> events) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("azure_raw_partition_id", context.getPartitionId());
        for (EventData e : events) {
            AzureCheckpointer checkpointer = new AzureCheckpointer(() -> context.checkpoint(e));
            if (this.checkpointConfig.getCheckpointMode() == CheckpointMode.MANUAL) {
                headers.put("azure_checkpointer", (String)checkpointer);
            }
            this.consumer.accept(this.messageConverter.toMessage(e, (Map)new MessageHeaders(headers), this.payloadType));
            this.checkpointManager.onMessage(context, e);
        }
        this.checkpointManager.completeBatch(context);
    }

    public void onError(PartitionContext context, Throwable error) {
        log.error("Partition {} onError", (Object)context.getPartitionId(), (Object)error);
    }
}

