/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.servicebus.factory;

import com.microsoft.azure.management.servicebus.ServiceBusNamespace;
import com.microsoft.azure.servicebus.IMessageSender;
import com.microsoft.azure.servicebus.IQueueClient;
import com.microsoft.azure.servicebus.QueueClient;
import com.microsoft.azure.servicebus.ReceiveMode;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.spring.cloud.context.core.util.Memoizer;
import com.microsoft.azure.spring.cloud.context.core.util.Tuple;
import com.microsoft.azure.spring.integration.servicebus.ServiceBusRuntimeException;
import com.microsoft.azure.spring.integration.servicebus.factory.AbstractServiceBusSenderFactory;
import com.microsoft.azure.spring.integration.servicebus.factory.ServiceBusQueueClientFactory;
import java.util.function.Function;
import org.springframework.util.StringUtils;

public class DefaultServiceBusQueueClientFactory
extends AbstractServiceBusSenderFactory
implements ServiceBusQueueClientFactory {
    private final Function<String, IQueueClient> queueClientCreator = Memoizer.memoize(this::createQueueClient);

    public DefaultServiceBusQueueClientFactory(String connectionString) {
        super(connectionString);
    }

    private IQueueClient createQueueClient(String destination) {
        if (this.resourceManagerProvider != null && StringUtils.hasText((String)this.namespace)) {
            ServiceBusNamespace serviceBusNamespace = (ServiceBusNamespace)this.resourceManagerProvider.getServiceBusNamespaceManager().getOrCreate((Object)this.namespace);
            this.resourceManagerProvider.getServiceBusQueueManager().getOrCreate((Object)Tuple.of((Object)serviceBusNamespace, (Object)destination));
        }
        try {
            return new QueueClient(new ConnectionStringBuilder(this.connectionString, destination), ReceiveMode.PEEKLOCK);
        }
        catch (ServiceBusException | InterruptedException e) {
            throw new ServiceBusRuntimeException("Failed to create service bus queue client", e);
        }
    }

    @Override
    public IQueueClient getOrCreateClient(String name) {
        return this.queueClientCreator.apply(name);
    }

    @Override
    public IMessageSender getOrCreateSender(String name) {
        return this.getOrCreateClient(name);
    }
}

