/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.servicebus.queue.support;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.IMessageHandler;
import com.microsoft.azure.servicebus.IQueueClient;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.spring.integration.core.api.PartitionSupplier;
import com.microsoft.azure.spring.integration.servicebus.ServiceBusRuntimeException;
import com.microsoft.azure.spring.integration.servicebus.factory.ServiceBusQueueClientFactory;
import com.microsoft.azure.spring.integration.servicebus.queue.ServiceBusQueueTemplate;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.springframework.messaging.Message;

public class ServiceBusQueueTestOperation
extends ServiceBusQueueTemplate {
    private final Multimap<String, IMessage> topicsByName = ArrayListMultimap.create();
    private final Multimap<String, IMessageHandler> handlersByQueue = ArrayListMultimap.create();

    public ServiceBusQueueTestOperation(ServiceBusQueueClientFactory clientFactory) {
        super(clientFactory);
    }

    public static <E> Optional<E> getRandom(Collection<E> e) {
        return e.stream().skip((int)((double)e.size() * Math.random())).findFirst();
    }

    @Override
    public <U> CompletableFuture<Void> sendAsync(String name, Message<U> message, PartitionSupplier partitionSupplier) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        IMessage azureMessage = (IMessage)this.getMessageConverter().fromMessage(message, IMessage.class);
        this.topicsByName.put((Object)name, (Object)azureMessage);
        ServiceBusQueueTestOperation.getRandom(this.handlersByQueue.get((Object)name)).map(c -> c.onMessageAsync(azureMessage));
        future.complete(null);
        return future;
    }

    @Override
    protected void internalSubscribe(String name, Consumer<Message<?>> consumer, Class<?> payloadType) {
        IQueueClient queueClient = ((ServiceBusQueueClientFactory)this.senderFactory).getOrCreateClient(name);
        ServiceBusQueueTemplate.QueueMessageHandler handler = new ServiceBusQueueTemplate.QueueMessageHandler(consumer, payloadType, queueClient);
        try {
            queueClient.registerMessageHandler(handler);
        }
        catch (ServiceBusException | InterruptedException e) {
            throw new ServiceBusRuntimeException("Failed to internalSubscribe message handler", e);
        }
        this.handlersByQueue.put((Object)name, handler);
    }

    @Override
    public boolean unsubscribe(String name) {
        this.handlersByQueue.removeAll((Object)name);
        return true;
    }
}

