/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.cognitive.bing;

import com.microsoft.azure.synapse.ml.cognitive.bing.BingImageSearch;
import com.microsoft.azure.synapse.ml.cognitive.bing.BingImagesResponse;
import com.microsoft.azure.synapse.ml.cognitive.bing.BingImagesResponse$;
import com.microsoft.azure.synapse.ml.core.utils.AsyncUtils$;
import com.microsoft.azure.synapse.ml.stages.Lambda;
import com.microsoft.azure.synapse.ml.stages.Lambda$;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.spark.injections.UDFUtils$;
import org.apache.spark.ml.ComplexParamsReadable;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.util.Try;

public final class BingImageSearch$
implements ComplexParamsReadable<BingImageSearch>,
scala.Serializable {
    public static BingImageSearch$ MODULE$;

    static {
        new BingImageSearch$();
    }

    public MLReader<BingImageSearch> read() {
        return ComplexParamsReadable.read$((ComplexParamsReadable)this);
    }

    public Object load(String path) {
        return MLReadable.load$((MLReadable)this, (String)path);
    }

    public Lambda getUrlTransformer(String imageCol, String urlCol) {
        Function1 fromRow = BingImagesResponse$.MODULE$.makeFromRowConverter();
        return Lambda$.MODULE$.apply((Function1 & Serializable & scala.Serializable)x$1 -> x$1.withColumn(urlCol, functions$.MODULE$.explode(UDFUtils$.MODULE$.oldUdf((Function1 & Serializable & scala.Serializable)rOpt -> Option$.MODULE$.apply(rOpt).map((Function1 & Serializable & scala.Serializable)r -> (Seq)((BingImagesResponse)fromRow.apply(r)).value().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.contentUrl(), Seq$.MODULE$.canBuildFrom())), (DataType)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$)).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(imageCol)})))).select(urlCol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
    }

    public Lambda downloadFromUrls(String pathCol, String bytesCol, int concurrency, int timeout) {
        return Lambda$.MODULE$.apply((Function1 & Serializable & scala.Serializable)df -> {
            StructType outputSchema = df.schema().add(bytesCol, (DataType)BinaryType$.MODULE$, true);
            ExpressionEncoder encoder = RowEncoder$.MODULE$.apply(outputSchema);
            return df.toDF().mapPartitions((Function1 & Serializable & scala.Serializable)rows -> {
                Iterator futures = rows.map((Function1 & Serializable & scala.Serializable)row -> new Tuple2((Object)Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> IOUtils.toByteArray((URL)new URL((String)row.getAs(pathCol))), (ExecutionContext)ExecutionContext$.MODULE$.global()), row));
                return AsyncUtils$.MODULE$.bufferedAwaitSafeWithContext(futures, concurrency, (Duration)Duration$.MODULE$.fromNanos((long)timeout * (long)1000000.0), (ExecutionContext)ExecutionContext$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Try bytesOpt = (Try)tuple2._1();
                    Row row = (Row)tuple2._2();
                    byte[] bytes = (byte[])bytesOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
                    Row row2 = Row$.MODULE$.fromSeq((Seq)row.toSeq().$colon$plus((Object)bytes, Seq$.MODULE$.canBuildFrom()));
                    return row2;
                });
            }, (Encoder)encoder);
        });
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BingImageSearch$() {
        MODULE$ = this;
        MLReadable.$init$((MLReadable)this);
        ComplexParamsReadable.$init$((ComplexParamsReadable)this);
    }
}

