/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.cognitive.search;

import com.microsoft.azure.synapse.ml.cognitive.search.AddDocuments;
import com.microsoft.azure.synapse.ml.cognitive.search.AzureSearchAPIConstants$;
import com.microsoft.azure.synapse.ml.cognitive.search.AzureSearchProtocol$;
import com.microsoft.azure.synapse.ml.cognitive.search.HasActionCol;
import com.microsoft.azure.synapse.ml.cognitive.search.HasIndexName;
import com.microsoft.azure.synapse.ml.cognitive.search.HasServiceName;
import com.microsoft.azure.synapse.ml.cognitive.search.IndexField;
import com.microsoft.azure.synapse.ml.cognitive.search.IndexInfo;
import com.microsoft.azure.synapse.ml.cognitive.search.IndexParser;
import com.microsoft.azure.synapse.ml.cognitive.search.SearchIndex$;
import com.microsoft.azure.synapse.ml.core.contracts.HasOutputCol;
import com.microsoft.azure.synapse.ml.io.http.ErrorUtils$;
import com.microsoft.azure.synapse.ml.io.http.HasErrorCol;
import com.microsoft.azure.synapse.ml.io.powerbi.StreamMaterializer;
import com.microsoft.azure.synapse.ml.stages.HasBatchSize;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.log4j.LogManager;
import org.apache.spark.injections.UDFUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spray.json.package$;

public final class AzureSearchWriter$
implements IndexParser,
Logging {
    public static AzureSearchWriter$ MODULE$;
    private final org.apache.log4j.Logger Logger;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new AzureSearchWriter$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public IndexInfo parseIndexJson(String str) {
        return IndexParser.parseIndexJson$(this, str);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public org.apache.log4j.Logger Logger() {
        return this.Logger;
    }

    private Option<Row> checkForErrors(boolean fatal, Row errorRow, Row inputRow) {
        return Option$.MODULE$.apply((Object)errorRow).map((Function1 & Serializable & scala.Serializable)r -> {
            String message = new StringBuilder(37).append("Service Exception:\n\t ").append(r.toString()).append(" \n for input:\n\t ").append(inputRow.toString()).toString();
            if (fatal) {
                throw new RuntimeException(message);
            }
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            return r;
        });
    }

    private Dataset<Row> filterOutNulls(Dataset<Row> df, String collectionColName) {
        return df.withColumn(collectionColName, functions$.MODULE$.expr(new StringBuilder(28).append("filter(").append(collectionColName).append(", x -> x is not null)").toString()));
    }

    private Seq<IndexField> convertFields(Seq<StructField> fields, String keyCol, String searchActionCol, Option<String> prefix) {
        return (Seq)((TraversableLike)fields.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$convertFields$1(searchActionCol, x$1)))).map((Function1 & Serializable & scala.Serializable)sf -> {
            String innerType;
            String fullName = (String)prefix.map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(0).append((String)x$2).append(sf.name()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> sf.name());
            Tuple2<String, Option<Seq<IndexField>>> tuple2 = MODULE$.sparkTypeToEdmType(sf.dataType(), MODULE$.sparkTypeToEdmType$default$2());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String string = innerType = (String)tuple2._1();
            String innerType2 = string;
            String string2 = keyCol;
            String string3 = fullName;
            return new IndexField(sf.name(), innerType2, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)(!(string2 != null ? !string2.equals(string3) : string3 != null) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)) : None$.MODULE$), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, MODULE$.structFieldToSearchFields(sf.dataType(), keyCol, searchActionCol, (Option<String>)new Some((Object)new StringBuilder(1).append((String)prefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(sf.name()).append(".").toString())));
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Option<Seq<IndexField>> structFieldToSearchFields(DataType schema, String keyCol, String searchActionCol, Option<String> prefix) {
        ArrayType arrayType;
        DataType dataType;
        None$ none$;
        DataType dataType2 = schema;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            none$ = new Some(this.convertFields((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])fields), keyCol, searchActionCol, prefix));
        } else if (dataType2 instanceof ArrayType && (dataType = (arrayType = (ArrayType)dataType2).elementType()) instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            none$ = new Some(this.convertFields((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])fields), keyCol, searchActionCol, prefix));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Option<String> structFieldToSearchFields$default$4() {
        return None$.MODULE$;
    }

    private String dfToIndexJson(StructType schema, String indexName, String keyCol, String searchActionCol) {
        IndexInfo is = new IndexInfo((Option<String>)new Some((Object)indexName), (Seq<IndexField>)((Seq)this.structFieldToSearchFields((DataType)schema, keyCol, searchActionCol, this.structFieldToSearchFields$default$4()).get()), (Option<Seq<String>>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$);
        return package$.MODULE$.enrichAny((Object)is).toJson(AzureSearchProtocol$.MODULE$.IiEnc()).compactPrint();
    }

    private Dataset<Row> prepareDF(Dataset<Row> df, Map<String, String> options) {
        Dataset dataset;
        Set applicableOptions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"subscriptionKey", "actionCol", "serviceName", "indexName", "indexJson", "apiVersion", "batchSize", "fatalErrors", "filterNulls", "keyCol"}));
        options.keys().foreach((Function1 & Serializable & scala.Serializable)k -> {
            Predef$.MODULE$.assert(applicableOptions.apply((Object)k), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(k).append(" not an applicable option ").append(applicableOptions$1.toList()).toString());
            return BoxedUnit.UNIT;
        });
        String subscriptionKey = (String)options.apply((Object)"subscriptionKey");
        String actionCol = (String)options.getOrElse((Object)"actionCol", (Function0 & Serializable & scala.Serializable)() -> "@search.action");
        String serviceName = (String)options.apply((Object)"serviceName");
        Option indexJsonOpt = options.get((Object)"indexJson");
        String apiVersion = (String)options.getOrElse((Object)"apiVersion", (Function0 & Serializable & scala.Serializable)() -> AzureSearchAPIConstants$.MODULE$.DefaultAPIVersion());
        int batchSize = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)"batchSize", (Function0 & Serializable & scala.Serializable)() -> "100"))).toInt();
        boolean fatalErrors = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)"fatalErrors", (Function0 & Serializable & scala.Serializable)() -> "true"))).toBoolean();
        boolean filterNulls = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)"filterNulls", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
        Option keyCol = options.get((Object)"keyCol");
        String indexName = (String)options.getOrElse((Object)"indexName", (Function0 & Serializable & scala.Serializable)() -> (String)MODULE$.parseIndexJson((String)indexJsonOpt.get()).name().get());
        if (indexJsonOpt.isDefined()) {
            new .colon.colon((Object)"keyCol", (List)new .colon.colon((Object)"indexName", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)opt -> {
                Predef$.MODULE$.assert(!options.contains((Object)opt), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Cannot set both indexJson options and ").append(opt).toString());
                return BoxedUnit.UNIT;
            });
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).foreach((Function1 & Serializable & scala.Serializable)sf -> {
            AzureSearchWriter$.$anonfun$prepareDF$11(sf);
            return BoxedUnit.UNIT;
        });
        String indexJson = (String)indexJsonOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.dfToIndexJson(df.schema(), indexName, (String)keyCol.get(), actionCol));
        SearchIndex$.MODULE$.createIfNoneExists(subscriptionKey, serviceName, indexJson, apiVersion);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "checking schema parity");
        this.checkSchemaParity(df.schema(), indexJson, actionCol);
        if (filterNulls) {
            Seq collectionColumns = (Seq)((TraversableLike)this.parseIndexJson(indexJson).fields().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$prepareDF$14(x$3)))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom());
            dataset = (Dataset)collectionColumns.foldLeft(df, (Function2 & Serializable & scala.Serializable)(ndf, c) -> MODULE$.filterOutNulls((Dataset<Row>)ndf, (String)c));
        } else {
            dataset = df;
        }
        Dataset df1 = dataset;
        return ((AddDocuments)((HasErrorCol)((HasOutputCol)((HasBatchSize)((HasActionCol)((Object)((HasIndexName)((Object)((HasServiceName)((Object)new AddDocuments().setSubscriptionKey(subscriptionKey))).setServiceName(serviceName))).setIndexName(indexName))).setActionCol(actionCol)).setBatchSize(batchSize)).setOutputCol("out")).setErrorCol("error")).transform(df1).withColumn("error", UDFUtils$.MODULE$.oldUdf((Function2 & Serializable & scala.Serializable)(errorRow, inputRow) -> MODULE$.checkForErrors(fatalErrors, (Row)errorRow, (Row)inputRow), (DataType)ErrorUtils$.MODULE$.ErrorSchema()).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("error"), functions$.MODULE$.col("input")})));
    }

    private Map<String, String> prepareDF$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private boolean isEdmCollection(String t) {
        return t.startsWith("Collection(") && t.endsWith(")");
    }

    private String getEdmCollectionElement(String t) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(t.substring("Collection(".length()))).dropRight(1);
    }

    public DataType edmTypeToSparkType(String dt, Option<Seq<IndexField>> fields) {
        StringType$ stringType$;
        String string = dt;
        if (this.isEdmCollection(string)) {
            stringType$ = new ArrayType(this.edmTypeToSparkType(this.getEdmCollectionElement(string), fields), false);
        } else if ("Edm.String".equals(string)) {
            stringType$ = StringType$.MODULE$;
        } else if ("Edm.Boolean".equals(string)) {
            stringType$ = BooleanType$.MODULE$;
        } else if ("Edm.Int64".equals(string)) {
            stringType$ = LongType$.MODULE$;
        } else if ("Edm.Int32".equals(string)) {
            stringType$ = IntegerType$.MODULE$;
        } else if ("Edm.Double".equals(string)) {
            stringType$ = DoubleType$.MODULE$;
        } else if ("Edm.DateTimeOffset".equals(string)) {
            stringType$ = StringType$.MODULE$;
        } else if ("Edm.GeographyPoint".equals(string)) {
            stringType$ = StringType$.MODULE$;
        } else if ("Edm.ComplexType".equals(string)) {
            stringType$ = StructType$.MODULE$.apply((Seq)((TraversableLike)fields.get()).map((Function1 & Serializable & scala.Serializable)f -> new StructField(f.name(), MODULE$.edmTypeToSparkType(f.type(), f.fields()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom()));
        } else {
            throw new MatchError((Object)string);
        }
        return stringType$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2<String, Option<Seq<IndexField>>> sparkTypeToEdmType(DataType dt, boolean allowCollections) {
        boolean bl = false;
        ArrayType arrayType = null;
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType;
            DataType it = arrayType.elementType();
            if (allowCollections) {
                Tuple2<String, Option<Seq<IndexField>>> tuple2 = this.sparkTypeToEdmType(it, false);
                if (tuple2 == null) throw new MatchError(tuple2);
                String innerType = (String)tuple2._1();
                Option innerFields = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)innerType, (Object)innerFields);
                Tuple2 tuple23 = tuple22;
                String innerType2 = (String)tuple23._1();
                Option innerFields2 = (Option)tuple23._2();
                return new Tuple2((Object)new StringBuilder(12).append("Collection(").append(innerType2).append(")").toString(), (Object)innerFields2);
            }
        }
        if (bl) {
            DataType it = arrayType.elementType();
            if (!allowCollections) {
                Tuple2<String, Option<Seq<IndexField>>> tuple2 = this.sparkTypeToEdmType(it, allowCollections);
                if (tuple2 == null) throw new MatchError(tuple2);
                String innerType = (String)tuple2._1();
                Option innerFields = (Option)tuple2._2();
                Tuple2 tuple24 = new Tuple2((Object)innerType, (Object)innerFields);
                Tuple2 tuple25 = tuple24;
                String innerType3 = (String)tuple25._1();
                Option innerFields3 = (Option)tuple25._2();
                return new Tuple2((Object)"Edm.ComplexType", (Object)innerFields3);
            }
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.String", (Object)None$.MODULE$);
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.Boolean", (Object)None$.MODULE$);
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.Int32", (Object)None$.MODULE$);
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.Int64", (Object)None$.MODULE$);
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.Double", (Object)None$.MODULE$);
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.DateTimeOffset", (Object)None$.MODULE$);
        }
        if (!(dataType instanceof StructType)) throw new MatchError((Object)dataType);
        StructType structType = (StructType)dataType;
        StructField[] fields = structType.fields();
        return new Tuple2((Object)"Edm.ComplexType", (Object)new Some(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> {
            Tuple2<String, Option<Seq<IndexField>>> tuple2 = MODULE$.sparkTypeToEdmType(f.dataType(), MODULE$.sparkTypeToEdmType$default$2());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String innerType = (String)tuple2._1();
            Option innerFields = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)innerType, (Object)innerFields);
            Tuple2 tuple23 = tuple22;
            String innerType2 = (String)tuple23._1();
            Option innerFields2 = (Option)tuple23._2();
            return new IndexField(f.name(), innerType2, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<Seq<IndexField>>)innerFields2);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
    }

    private boolean sparkTypeToEdmType$default$2() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean dtEqualityModuloNullability(DataType dt1, DataType dt2) {
        Tuple2 tuple2;
        while ((tuple2 = new Tuple2((Object)dt1, (Object)dt2)) != null) {
            DataType it2;
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            DataType it1 = arrayType.elementType();
            if (!(dataType2 instanceof ArrayType)) break;
            ArrayType arrayType2 = (ArrayType)dataType2;
            dt2 = it2 = arrayType2.elementType();
            dt1 = it1;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields1 = structType.fields();
                if (dataType3 instanceof StructType) {
                    StructType structType2 = (StructType)dataType3;
                    StructField[] fields2 = structType2.fields();
                    return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields1)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$dtEqualityModuloNullability$1(x0$1)));
                }
            }
        }
        DataType dataType = dt1;
        DataType dataType4 = dt2;
        if (dataType != null) {
            if (!dataType.equals(dataType4)) return false;
            return true;
        }
        if (dataType4 == null) return true;
        return false;
    }

    private void checkSchemaParity(StructType schema, String indexJson, String searchActionCol) {
        IndexInfo indexInfo = this.parseIndexJson(indexJson);
        Map indexFields = ((TraversableOnce)indexInfo.fields().map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.name(), (Object)MODULE$.edmTypeToSparkType(f.type(), f.fields())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        DataType dataType = schema.apply(searchActionCol).dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null));
        ((List)schema.toList().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$checkSchemaParity$2(searchActionCol, x$8)))).foreach((Function1 & Serializable & scala.Serializable)field -> {
            AzureSearchWriter$.$anonfun$checkSchemaParity$3(indexFields, field);
            return BoxedUnit.UNIT;
        });
    }

    public DataStreamWriter<Row> stream(Dataset<Row> df, Map<String, String> options) {
        return this.prepareDF(df, options).writeStream().foreach((ForeachWriter)new StreamMaterializer());
    }

    public void write(Dataset<Row> df, Map<String, String> options) {
        this.prepareDF(df, options).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            AzureSearchWriter$.$anonfun$write$1(x$9);
            return BoxedUnit.UNIT;
        });
    }

    public DataStreamWriter<Row> stream(Dataset<Row> df, HashMap<String, String> options) {
        return this.stream(df, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    public Map<String, String> stream$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public void write(Dataset<Row> df, HashMap<String, String> options) {
        this.write(df, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    public Map<String, String> write$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$convertFields$1(String searchActionCol$1, StructField x$1) {
        String string = x$1.name();
        String string2 = searchActionCol$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$prepareDF$11(StructField sf) {
        ArrayType arrayType;
        DataType dataType;
        DataType dataType2 = sf.dataType();
        if (dataType2 instanceof ArrayType && (dataType = (arrayType = (ArrayType)dataType2).elementType()) instanceof ArrayType) {
            throw new IllegalArgumentException(new StringBuilder(102).append("Cannot make an index with a doubly nested array, ").append("please wrap column ").append(sf.name()).append(" with a struct to avoid this error").toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$prepareDF$14(IndexField x$3) {
        return x$3.type().startsWith("Collection");
    }

    public static final /* synthetic */ boolean $anonfun$dtEqualityModuloNullability$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField sf1 = (StructField)tuple2._1();
        StructField sf2 = (StructField)tuple2._2();
        String string = sf1.name();
        String string2 = sf2.name();
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) && MODULE$.dtEqualityModuloNullability(sf1.dataType(), sf2.dataType());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$checkSchemaParity$2(String searchActionCol$2, StructField x$8) {
        String string = x$8.name();
        String string2 = searchActionCol$2;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$checkSchemaParity$3(Map indexFields$1, StructField field) {
        DataType indexType = (DataType)indexFields$1.getOrElse((Object)field.name(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(35).append(field.name()).append(" not found in search index fields: ").append(indexFields$1.keys().toList()).toString());
        });
        Predef$.MODULE$.assert(MODULE$.dtEqualityModuloNullability(indexType, field.dataType()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("field ").append(field.name()).append(" requires type").append(" ").append(indexType).append(" your dataframe column is of type ").append(field.dataType()).toString());
    }

    public static final /* synthetic */ void $anonfun$write$1(Row x$9) {
    }

    private AzureSearchWriter$() {
        MODULE$ = this;
        IndexParser.$init$(this);
        Logging.$init$((Logging)this);
        this.Logger = LogManager.getRootLogger();
    }
}

