/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.cognitive.speech;

import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStreamCallback;
import java.io.InputStream;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001]3Aa\u0003\u0007\u00017!AQ\u0005\u0001BC\u0002\u0013\u0005a\u0005\u0003\u00050\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015\u0001\u0004\u0001\"\u00012\u0011\u001d)\u0004A1A\u0005\u0002\u0019BaA\u000e\u0001!\u0002\u00139\u0003\"B\u001c\u0001\t\u0003B\u0004\"B$\u0001\t\u0003B\u0005\"\u0002'\u0001\t\u0013i\u0005\"\u0002)\u0001\t\u0013\t\u0006\"B*\u0001\t\u0003!&!C,bmN#(/Z1n\u0015\tia\"\u0001\u0004ta\u0016,7\r\u001b\u0006\u0003\u001fA\t\u0011bY8h]&$\u0018N^3\u000b\u0005E\u0011\u0012AA7m\u0015\t\u0019B#A\u0004ts:\f\u0007o]3\u000b\u0005U1\u0012!B1{kJ,'BA\f\u0019\u0003%i\u0017n\u0019:pg>4GOC\u0001\u001a\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0004\u0005\u0002\u001eG5\taD\u0003\u0002 A\u0005)\u0011-\u001e3j_*\u0011Q\"\t\u0006\u0003EY\t\u0011cY8h]&$\u0018N^3tKJ4\u0018nY3t\u0013\t!cD\u0001\u000fQk2d\u0017)\u001e3j_&s\u0007/\u001e;TiJ,\u0017-\\\"bY2\u0014\u0017mY6\u0002\u0013]\fgo\u0015;sK\u0006lW#A\u0014\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013AA5p\u0015\u0005a\u0013\u0001\u00026bm\u0006L!AL\u0015\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u000bo\u000648\u000b\u001e:fC6\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u00023iA\u00111\u0007A\u0007\u0002\u0019!)Qe\u0001a\u0001O\u000511\u000f\u001e:fC6\fqa\u001d;sK\u0006l\u0007%\u0001\u0003sK\u0006$GCA\u001d@!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\rIe\u000e\u001e\u0005\u0006\u0001\u001a\u0001\r!Q\u0001\u000bI\u0006$\u0018MQ;gM\u0016\u0014\bc\u0001\u001eC\t&\u00111i\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003u\u0015K!AR\u001e\u0003\t\tKH/Z\u0001\u0006G2|7/\u001a\u000b\u0002\u0013B\u0011!HS\u0005\u0003\u0017n\u0012A!\u00168ji\u0006Q!/Z1e+&sGo\r\u001a\u0015\u0005er\u0005\"B(\t\u0001\u00049\u0013aC5oaV$8\u000b\u001e:fC6\f!B]3bIVKe\u000e^\u00197)\tI$\u000bC\u0003P\u0013\u0001\u0007q%\u0001\bqCJ\u001cXmV1w\u0011\u0016\fG-\u001a:\u0015\u0005\u001d*\u0006\"\u0002,\u000b\u0001\u00049\u0013A\u0002:fC\u0012,'\u000f")
public class WavStream
extends PullAudioInputStreamCallback {
    private final InputStream wavStream;
    private final InputStream stream;

    public InputStream wavStream() {
        return this.wavStream;
    }

    public InputStream stream() {
        return this.stream;
    }

    public int read(byte[] dataBuffer) {
        return Math.max(0, this.stream().read(dataBuffer, 0, dataBuffer.length));
    }

    public void close() {
        this.stream().close();
    }

    private int readUInt32(InputStream inputStream) {
        return BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & java.io.Serializable & Serializable)(x0$1, x1$1) -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$1, x1$1);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int n = sp2._1$mcI$sp();
            int i = sp2._2$mcI$sp();
            int n2 = n | inputStream.read() << i * 8;
            return n2;
        }));
    }

    private int readUInt16(InputStream inputStream) {
        return BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & java.io.Serializable & Serializable)(x0$1, x1$1) -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$1, x1$1);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int n = sp2._1$mcI$sp();
            int i = sp2._2$mcI$sp();
            int n2 = n | inputStream.read() << i * 8;
            return n2;
        }));
    }

    public InputStream parseWavHeader(InputStream reader) {
        byte[] data = new byte[4];
        int numRead = reader.read(data, 0, 4);
        Predef$.MODULE$.assert(numRead == 4 && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray("RIFF".getBytes())), (Function0 & java.io.Serializable & Serializable)() -> "RIFF");
        this.readUInt32(reader);
        numRead = reader.read(data, 0, 4);
        Predef$.MODULE$.assert(numRead == 4 && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray("WAVE".getBytes())), (Function0 & java.io.Serializable & Serializable)() -> "WAVE");
        numRead = reader.read(data, 0, 4);
        Predef$.MODULE$.assert(numRead == 4 && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray("fmt ".getBytes())), (Function0 & java.io.Serializable & Serializable)() -> "fmt ");
        int formatSize = this.readUInt32(reader);
        Predef$.MODULE$.assert(formatSize >= 16, (Function0 & java.io.Serializable & Serializable)() -> "formatSize");
        int formatTag = this.readUInt16(reader);
        int channels = this.readUInt16(reader);
        int samplesPerSec = this.readUInt32(reader);
        this.readUInt32(reader);
        this.readUInt16(reader);
        int bitsPerSample = this.readUInt16(reader);
        Predef$.MODULE$.assert(formatTag == 1, (Function0 & java.io.Serializable & Serializable)() -> "PCM");
        Predef$.MODULE$.assert(channels == 1, (Function0 & java.io.Serializable & Serializable)() -> "file needs to be single channel");
        Predef$.MODULE$.assert(samplesPerSec == 16000, (Function0 & java.io.Serializable & Serializable)() -> "file needs to have 16000 samples per second");
        Predef$.MODULE$.assert(bitsPerSample == 16, (Function0 & java.io.Serializable & Serializable)() -> "file needs to have 16 bits per sample");
        if (formatSize > 16) {
            numRead = reader.read(new byte[formatSize - 16]);
            Predef$.MODULE$.assert(numRead == formatSize - 16, (Function0 & java.io.Serializable & Serializable)() -> "could not skip extended format");
        }
        Predef$.MODULE$.assert((numRead = reader.read(data, 0, 4)) == 4 && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(data)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray("data".getBytes())));
        this.readUInt32(reader);
        return reader;
    }

    public WavStream(InputStream wavStream) {
        this.wavStream = wavStream;
        this.stream = this.parseWavHeader(wavStream);
    }
}

