/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.services.anomaly;

import com.microsoft.azure.synapse.ml.core.env.StreamUtilities$;
import com.microsoft.azure.synapse.ml.io.http.RESTHelpers$;
import com.microsoft.azure.synapse.ml.services.URLEncodingUtils$;
import com.microsoft.azure.synapse.ml.services.anomaly.DMASummary;
import com.microsoft.azure.synapse.ml.services.anomaly.MADJsonProtocol$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.parallel.mutable.ParHashSet;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import spray.json.JsString;
import spray.json.JsValue;
import spray.json.JsonWriter;
import spray.json.package$;

public final class MADUtils$
implements Logging {
    public static MADUtils$ MODULE$;
    private final ParHashSet<String> CreatedModels;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new MADUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ParHashSet<String> CreatedModels() {
        return this.CreatedModels;
    }

    public String madSend(HttpRequestBase request, String path, String key, Map<String, String> params) {
        String paramString = params.isEmpty() ? "" : new StringBuilder(1).append("?").append(URLEncodingUtils$.MODULE$.format(params)).toString();
        request.setURI(new URI(new StringBuilder(0).append(path).append(paramString).toString()));
        return (String)RESTHelpers$.MODULE$.retry(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 500, 1000})), (Function0 & Serializable & scala.Serializable)() -> {
            request.addHeader("Ocp-Apim-Subscription-Key", key);
            request.addHeader("Content-Type", "application/json");
            return (String)StreamUtilities$.MODULE$.using((AutoCloseable)RESTHelpers$.MODULE$.Client().execute((HttpUriRequest)request), (Function1 & Serializable & scala.Serializable)response -> {
                if (!Integer.toString(response.getStatusLine().getStatusCode()).startsWith("2")) {
                    String bodyOpt;
                    String string;
                    HttpRequestBase httpRequestBase = request;
                    if (httpRequestBase instanceof HttpEntityEnclosingRequestBase) {
                        HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase = (HttpEntityEnclosingRequestBase)httpRequestBase;
                        string = IOUtils.toString((InputStream)httpEntityEnclosingRequestBase.getEntity().getContent(), (String)"UTF-8");
                    } else {
                        string = bodyOpt = "";
                    }
                    if (Integer.toString(response.getStatusLine().getStatusCode()).equals("429")) {
                        int retryTime = new StringOps(Predef$.MODULE$.augmentString(((NameValuePair)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])response.getHeaders("Retry-After"))).head()).getValue())).toInt() * 1000;
                        Thread.sleep(retryTime);
                    }
                    throw new RuntimeException(new StringBuilder(45).append("Failed: response: ").append(response).append(" ").append("requestUrl: ").append(request.getURI()).append(" ").append("requestBody: ").append(bodyOpt).toString());
                }
                String string = response.getStatusLine().getReasonPhrase();
                String string2 = "No Content";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return "";
                }
                String string3 = response.getStatusLine().getReasonPhrase();
                String string4 = "Created";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    return ((NameValuePair)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])response.getHeaders("Location"))).head()).getValue();
                }
                return IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
            }).get();
        });
    }

    public Map<String, String> madSend$default$4() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public String madGetModel(String url, String modelId, String key, Map<String, String> params) {
        return this.madSend((HttpRequestBase)new HttpGet(), new StringBuilder(0).append(url).append(modelId).toString(), key, params);
    }

    public Map<String, String> madGetModel$default$4() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public String madUrl(String location) {
        return new StringBuilder(71).append("https://").append(location).append(".api.cognitive.microsoft.com/anomalydetector/v1.1/multivariate/").toString();
    }

    public String madDelete(String modelId, String key, String location, Map<String, String> params) {
        return this.madSend((HttpRequestBase)new HttpDelete(), new StringBuilder(7).append(this.madUrl(location)).append("models/").append(modelId).toString(), key, params);
    }

    public Map<String, String> madDelete$default$4() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public String madGetBatchDetectionResults(String url, String resultId, String key, Map<String, String> params, int maxTries, int pollingDelay) {
        Iterator it = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxTries).toIterator().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> MADUtils$.$anonfun$madGetBatchDetectionResults$1(url, resultId, key, params, pollingDelay, BoxesRunTime.unboxToInt((Object)x$1)));
        if (it.hasNext()) {
            return (String)it.next();
        }
        throw new TimeoutException(new StringBuilder(66).append("Querying for results with resultId ").append(resultId).append(" did not complete within ").append(maxTries).append(" tries").toString());
    }

    public Map<String, String> madGetBatchDetectionResults$default$4() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public String madListModels(String key, String location, Map<String, String> params) {
        return this.madSend((HttpRequestBase)new HttpGet(), new StringBuilder(15).append(this.madUrl(location)).append("models?$top=500").toString(), key, params);
    }

    public Map<String, String> madListModels$default$3() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public void cleanUpAllModels(String key, String location) {
        this.CreatedModels().foreach((Function1 & Serializable & scala.Serializable)modelId -> {
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("Deleting mvad model ").append((String)modelId).toString());
            return MODULE$.madDelete((String)modelId, key, location, MODULE$.madDelete$default$4());
        });
        this.CreatedModels().clear();
    }

    public void checkModelStatus(String url, String modelId, String subscriptionKey) {
        try {
            String modelStatus;
            Map response = package$.MODULE$.enrichString(this.madGetModel(url, modelId, subscriptionKey, this.madGetModel$default$4())).parseJson().asJsObject().fields();
            Map modelInfo = ((JsValue)response.apply((Object)"modelInfo")).asJsObject().fields();
            String string = modelStatus = ((JsString)modelInfo.apply((Object)"status")).value().toLowerCase();
            if ("failed".equals(string)) {
                String errors = package$.MODULE$.enrichAny(modelInfo.apply((Object)"errors")).toJson((JsonWriter)MADJsonProtocol$.MODULE$.JsValueFormat()).compactPrint();
                throw new RuntimeException(new StringBuilder(30).append("Caught errors during fitting: ").append(errors).toString());
            }
            if ("created".equals(string) ? true : "running".equals(string)) {
                throw new RuntimeException(new StringBuilder(23).append("model ").append(modelId).append(" is not ready yet").toString());
            }
            if (!"ready".equals(string)) {
                throw new MatchError((Object)string);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "model is ready for inference");
        }
        catch (RuntimeException e) {
            throw new RuntimeException(new StringBuilder(83).append("Encounter error while fetching model ").append(modelId).append(", ").append("please double check the modelId is correct: ").append(e.getMessage()).toString());
        }
    }

    public static final /* synthetic */ Iterable $anonfun$madGetBatchDetectionResults$1(String url$1, String resultId$1, String key$2, Map params$1, int pollingDelay$1, int x$1) {
        String resp = MODULE$.madSend((HttpRequestBase)new HttpGet(), new StringBuilder(0).append(url$1).append(resultId$1).toString(), key$2, (Map<String, String>)params$1);
        Map fields = package$.MODULE$.enrichString(resp).parseJson().asJsObject().fields();
        String string = ((DMASummary)((JsValue)fields.apply((Object)"summary")).convertTo(MADJsonProtocol$.MODULE$.DMASummaryEnc())).status().toLowerCase();
        if ("ready".equals(string) ? true : "failed".equals(string)) {
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)resp));
        }
        if ("created".equals(string) ? true : "running".equals(string)) {
            scala.concurrent.package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(pollingDelay$1));
            return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }
        throw new RuntimeException(new StringBuilder(30).append("Received unknown status code: ").append(string).toString());
    }

    private MADUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.CreatedModels = new ParHashSet();
    }
}

