/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.services.search;

import com.microsoft.azure.synapse.ml.io.http.RESTHelpers$;
import com.microsoft.azure.synapse.ml.services.search.AzureSearchAPIConstants$;
import com.microsoft.azure.synapse.ml.services.search.AzureSearchProtocol$;
import com.microsoft.azure.synapse.ml.services.search.AzureSearchWriter$;
import com.microsoft.azure.synapse.ml.services.search.IndexField;
import com.microsoft.azure.synapse.ml.services.search.IndexInfo;
import com.microsoft.azure.synapse.ml.services.search.IndexLister;
import com.microsoft.azure.synapse.ml.services.search.IndexParser;
import com.microsoft.azure.synapse.ml.services.search.IndexStats;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;
import spray.json.package$;

public final class SearchIndex$
implements IndexParser,
IndexLister {
    public static SearchIndex$ MODULE$;
    private final Logger Logger;

    static {
        new SearchIndex$();
    }

    @Override
    public Seq<String> getExisting(String key, String serviceName, String apiVersion) {
        return IndexLister.getExisting$(this, key, serviceName, apiVersion);
    }

    @Override
    public String getExisting$default$3() {
        return IndexLister.getExisting$default$3$(this);
    }

    @Override
    public IndexInfo parseIndexJson(String str) {
        return IndexParser.parseIndexJson$(this, str);
    }

    public Logger Logger() {
        return this.Logger;
    }

    public void createIfNoneExists(String key, String serviceName, String indexJson, String apiVersion) {
        String indexName = (String)this.parseIndexJson(indexJson).name().get();
        Seq<String> existingIndexNames = this.getExisting(key, serviceName, apiVersion);
        if (!existingIndexNames.contains((Object)indexName)) {
            HttpPost createRequest = new HttpPost(new StringBuilder(48).append("https://").append(serviceName).append(".search.windows.net/indexes?api-version=").append(apiVersion).toString());
            createRequest.setHeader("Content-Type", "application/json");
            createRequest.setHeader("api-key", key);
            createRequest.setEntity((HttpEntity)this.prepareEntity(indexJson));
            CloseableHttpResponse response = RESTHelpers$.MODULE$.safeSend((HttpRequestBase)createRequest, RESTHelpers$.MODULE$.safeSend$default$2(), RESTHelpers$.MODULE$.safeSend$default$3(), RESTHelpers$.MODULE$.safeSend$default$4());
            int status = response.getStatusLine().getStatusCode();
            Predef$.MODULE$.assert(status == 201);
            return;
        }
    }

    public String createIfNoneExists$default$4() {
        return AzureSearchAPIConstants$.MODULE$.DefaultAPIVersion();
    }

    private StringEntity prepareEntity(String indexJson) {
        return new StringEntity((String)this.validIndexJson(indexJson).get());
    }

    private Try<String> validIndexJson(String indexJson) {
        return this.validateIndexInfo(indexJson).map((Function1 & Serializable & scala.Serializable)x$1 -> package$.MODULE$.enrichAny(x$1).toJson(AzureSearchProtocol$.MODULE$.IiEnc()).compactPrint());
    }

    private Try<IndexInfo> validateIndexInfo(String indexJson) {
        IndexInfo schema = this.parseIndexJson(indexJson);
        return this.validName((String)schema.name().get()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validIndexFields(schema.fields()).map((Function1 & Serializable & scala.Serializable)_ -> schema));
    }

    private Try<IndexField> validIndexField(IndexField field) {
        return this.validName(field.name()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validType(field.type(), field.fields()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validSearchable(field.type(), field.searchable()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validSortable(field.type(), field.sortable()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validFacetable(field.type(), field.facetable()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validKey(field.type(), field.key()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validAnalyzer(field.analyzer(), field.searchAnalyzer(), field.indexAnalyzer()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validSearchAnalyzer(field.analyzer(), field.searchAnalyzer(), field.indexAnalyzer()).flatMap((Function1 & Serializable & scala.Serializable)_ -> MODULE$.validIndexAnalyzer(field.analyzer(), field.searchAnalyzer(), field.indexAnalyzer()).flatMap((Function1 & Serializable & scala.Serializable)_2 -> MODULE$.validVectorField(field.dimensions(), field.vectorSearchConfiguration()).map((Function1 & Serializable & scala.Serializable)_ -> field))))))))));
    }

    private Try<Seq<IndexField>> validIndexFields(Seq<IndexField> fields) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Seq)fields.map((Function1 & Serializable & scala.Serializable)f -> (IndexField)MODULE$.validIndexField((IndexField)f).get(), Seq$.MODULE$.canBuildFrom()));
    }

    private Try<String> validName(String n) {
        if (n.isEmpty()) {
            return new Failure((Throwable)new IllegalArgumentException("Empty name"));
        }
        return new Success((Object)n);
    }

    private Try<String> validType(String t, Option<Seq<IndexField>> fields) {
        Try tdt = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> AzureSearchWriter$.MODULE$.edmTypeToSparkType(t, fields));
        return tdt.map((Function1 & Serializable & scala.Serializable)x$2 -> t);
    }

    private Try<Option<Object>> validSearchable(String t, Option<Object> s) {
        if (((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Edm.String", "Collection(Edm.String)"}))).apply((Object)t)) {
            return new Success(s);
        }
        if (s.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            return new Failure((Throwable)new IllegalArgumentException("Only Edm.String and Collection(Edm.String) fields can be searchable"));
        }
        return new Success(s);
    }

    private Try<Option<Object>> validSortable(String t, Option<Object> s) {
        String string = t;
        String string2 = "Collection(Edm.String)";
        if (!(string != null ? !string.equals(string2) : string2 != null) & s.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            return new Failure((Throwable)new IllegalArgumentException("Collection(Edm.String) fields cannot be sortable"));
        }
        return new Success(s);
    }

    private Try<Option<Object>> validFacetable(String t, Option<Object> s) {
        String string = t;
        String string2 = "Edm.GeographyPoint";
        if (!(string != null ? !string.equals(string2) : string2 != null) & s.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            return new Failure((Throwable)new IllegalArgumentException("Edm.GeographyPoint fields cannot be facetable"));
        }
        return new Success(s);
    }

    private Try<Option<Object>> validKey(String t, Option<Object> s) {
        String string = t;
        String string2 = "Edm.String";
        if ((string == null ? string2 != null : !string.equals(string2)) & s.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
            return new Failure((Throwable)new IllegalArgumentException("Only Edm.String fields can be keys"));
        }
        return new Success(s);
    }

    private Try<Option<String>> validAnalyzer(Option<String> a, Option<String> sa, Option<String> ia) {
        if (a.isDefined() && (sa.isDefined() || ia.isDefined())) {
            return new Failure((Throwable)new IllegalArgumentException("Max of 1 analyzer can be defined"));
        }
        return new Success(a);
    }

    private Try<Option<String>> validSearchAnalyzer(Option<String> a, Option<String> sa, Option<String> ia) {
        if (sa.isDefined() && (a.isDefined() || ia.isDefined())) {
            return new Failure((Throwable)new IllegalArgumentException("Max of 1 analyzer can be defined"));
        }
        return new Success(sa);
    }

    private Try<Option<String>> validIndexAnalyzer(Option<String> a, Option<String> sa, Option<String> ia) {
        if (ia.isDefined() && (sa.isDefined() || a.isDefined())) {
            return new Failure((Throwable)new IllegalArgumentException("Max of 1 analyzer can be defined"));
        }
        return new Success(ia);
    }

    private Try<Option<String>> validSynonymMaps(Option<String> sm) {
        Regex regexExtractor = new StringOps(Predef$.MODULE$.augmentString("\"([^, ]+)\"")).r();
        List extractList = regexExtractor.findAllMatchIn((CharSequence)sm.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.group(1)).toList();
        if (extractList.length() > 1) {
            return new Failure((Throwable)new IllegalArgumentException("Only one synonym map per field is supported"));
        }
        return new Success(sm);
    }

    private Try<Option<String>> validVectorField(Option<Object> d, Option<String> v) {
        if (d.isDefined() && v.isEmpty() || v.isDefined() && d.isEmpty()) {
            return new Failure((Throwable)new IllegalArgumentException("Both dimensions and vectorSearchConfig fields need to be defined for vector search"));
        }
        return new Success(v);
    }

    public Tuple2<Object, Object> getStatistics(String indexName, String key, String serviceName, String apiVersion) {
        HttpGet getStatsRequest = new HttpGet(new StringBuilder(55).append("https://").append(serviceName).append(".search.windows.net/indexes/").append(indexName).append("/stats?api-version=").append(apiVersion).toString());
        getStatsRequest.setHeader("api-key", key);
        HttpGet x$1 = getStatsRequest;
        boolean x$2 = false;
        List x$3 = RESTHelpers$.MODULE$.safeSend$default$2();
        Set x$4 = RESTHelpers$.MODULE$.safeSend$default$3();
        CloseableHttpResponse statsResponse = RESTHelpers$.MODULE$.safeSend((HttpRequestBase)x$1, x$3, x$4, x$2);
        IndexStats stats = (IndexStats)package$.MODULE$.enrichString(IOUtils.toString((InputStream)statsResponse.getEntity().getContent(), (String)"utf-8")).parseJson().convertTo(AzureSearchProtocol$.MODULE$.IsEnc());
        statsResponse.close();
        return new Tuple2.mcII.sp(stats.documentCount(), stats.storageSize());
    }

    public String getStatistics$default$4() {
        return AzureSearchAPIConstants$.MODULE$.DefaultAPIVersion();
    }

    private SearchIndex$() {
        MODULE$ = this;
        IndexParser.$init$(this);
        IndexLister.$init$(this);
        this.Logger = LogManager.getRootLogger();
    }
}

