/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.services.speech;

import com.microsoft.azure.synapse.ml.build.BuildInfo$;
import com.microsoft.azure.synapse.ml.core.schema.SparkBindings;
import com.microsoft.azure.synapse.ml.logging.FeatureNames;
import com.microsoft.azure.synapse.ml.services.speech.BlockingQueueIterator;
import com.microsoft.azure.synapse.ml.services.speech.SpeechFormat$;
import com.microsoft.azure.synapse.ml.services.speech.SpeechResponse;
import com.microsoft.azure.synapse.ml.services.speech.SpeechResponse$;
import com.microsoft.azure.synapse.ml.services.speech.SpeechSDKBase;
import com.microsoft.azure.synapse.ml.services.speech.SpeechToTextSDK$;
import com.microsoft.azure.synapse.ml.services.speech.TranscriptionParticipant;
import com.microsoft.cognitiveservices.speech.Connection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechRecognizer;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import spray.json.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001ds!B\u0007\u000f\u0011\u0003ib!B\u0010\u000f\u0011\u0003\u0001\u0003BB&\u0002\t\u0003\t)\u0004C\u0005\u00028\u0005\t\t\u0011\"\u0003\u0002:\u0019!qD\u0004\u00014\u0011!iDA!b\u0001\n\u0003r\u0004\u0002\u0003&\u0005\u0005\u0003\u0005\u000b\u0011B \t\u000b-#A\u0011\u0001'\u0006\t9#\u0001e\u0014\u0005\b%\u0012\u0011\r\u0011\"\u0011T\u0011\u0019aF\u0001)A\u0005)\")1\n\u0002C\u0001;\")a\f\u0002C\u0001?\u0006y1\u000b]3fG\"$v\u000eV3yiN#5J\u0003\u0002\u0010!\u000511\u000f]3fG\"T!!\u0005\n\u0002\u0011M,'O^5dKNT!a\u0005\u000b\u0002\u00055d'BA\u000b\u0017\u0003\u001d\u0019\u0018P\\1qg\u0016T!a\u0006\r\u0002\u000b\u0005TXO]3\u000b\u0005eQ\u0012!C7jGJ|7o\u001c4u\u0015\u0005Y\u0012aA2p[\u000e\u0001\u0001C\u0001\u0010\u0002\u001b\u0005q!aD*qK\u0016\u001c\u0007\u000eV8UKb$8\u000bR&\u0014\u000b\u0005\ts%a\f\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\rA\u0003GM\u0007\u0002S)\u00111C\u000b\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO&\u0011\u0011'\u000b\u0002\u0016\u0007>l\u0007\u000f\\3y!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\tqBaE\u0002\u0005i]\u0002\"AH\u001b\n\u0005Yr!!D*qK\u0016\u001c\u0007n\u0015#L\u0005\u0006\u001cX\r\u0005\u00029w5\t\u0011H\u0003\u0002;%\u00059An\\4hS:<\u0017B\u0001\u001f:\u0005A\u0019\u0016P\\1qg\u0016lE\nT8hO&tw-A\u0002vS\u0012,\u0012a\u0010\t\u0003\u0001\u001es!!Q#\u0011\u0005\t\u001bS\"A\"\u000b\u0005\u0011c\u0012A\u0002\u001fs_>$h(\u0003\u0002GG\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t15%\u0001\u0003vS\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u00023\u001b\")Qh\u0002a\u0001\u007f\ta!+Z:q_:\u001cX\rV=qKB\u0011a\u0004U\u0005\u0003#:\u0011ab\u00159fK\u000eD'+Z:q_:\u001cX-A\nsKN\u0004xN\\:f)f\u0004XMQ5oI&tw-F\u0001U!\r)&lT\u0007\u0002-*\u0011q\u000bW\u0001\u0007g\u000eDW-\\1\u000b\u0005e\u0013\u0012\u0001B2pe\u0016L!a\u0017,\u0003\u001bM\u0003\u0018M]6CS:$\u0017N\\4t\u0003Q\u0011Xm\u001d9p]N,G+\u001f9f\u0005&tG-\u001b8hAQ\t!'A\tj]B,Ho\u0015;sK\u0006lGk\u001c+fqR$\u0002\u0003Y5tkv|\u00181AA\u0007\u0003#\t)\"a\b\u0011\u0007\u00054wJ\u0004\u0002cI:\u0011!iY\u0005\u0002I%\u0011QmI\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007N\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t)7\u0005C\u0003k\u0019\u0001\u00071.\u0001\u0004tiJ,\u0017-\u001c\t\u0003YFl\u0011!\u001c\u0006\u0003]>\f!![8\u000b\u0003A\fAA[1wC&\u0011!/\u001c\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003u\u0019\u0001\u0007q(A\u0006bk\u0012LwNR8s[\u0006$\b\"\u0002<\r\u0001\u00049\u0018aA;sSB\u0011\u0001p_\u0007\u0002s*\u0011!p\\\u0001\u0004]\u0016$\u0018B\u0001?z\u0005\r)&+\u0013\u0005\u0006}2\u0001\raP\u0001\ngB,Wm\u00195LKfDa!!\u0001\r\u0001\u0004y\u0014!\u00039s_\u001a\fg.\u001b;z\u0011\u001d\t)\u0001\u0004a\u0001\u0003\u000f\t1c^8sI2+g/\u001a7US6,7\u000f^1naN\u00042AIA\u0005\u0013\r\tYa\t\u0002\b\u0005>|G.Z1o\u0011\u0019\ty\u0001\u0004a\u0001\u007f\u0005AA.\u00198hk\u0006<W\r\u0003\u0004\u0002\u00141\u0001\raP\u0001\u0007M>\u0014X.\u0019;\t\u000f\u0005]A\u00021\u0001\u0002\u001a\u0005\u0011B-\u001a4bk2$\u0018)\u001e3j_\u001a{'/\\1u!\u0011\u0011\u00131D \n\u0007\u0005u1E\u0001\u0004PaRLwN\u001c\u0005\b\u0003Ca\u0001\u0019AA\u0012\u00031\u0001\u0018M\u001d;jG&\u0004\u0018M\u001c;t!\u0015\t\u0017QEA\u0015\u0013\r\t9\u0003\u001b\u0002\u0004'\u0016\f\bc\u0001\u0010\u0002,%\u0019\u0011Q\u0006\b\u00031Q\u0013\u0018M\\:de&\u0004H/[8o!\u0006\u0014H/[2ja\u0006tG\u000fE\u0002#\u0003cI1!a\r$\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005i\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u000f\u0011\t\u0005u\u00121I\u0007\u0003\u0003\u007fQ1!!\u0011p\u0003\u0011a\u0017M\\4\n\t\u0005\u0015\u0013q\b\u0002\u0007\u001f\nTWm\u0019;")
public class SpeechToTextSDK
extends SpeechSDKBase {
    private final String uid;
    private final SparkBindings<SpeechResponse> responseTypeBinding;

    public static MLReader<SpeechToTextSDK> read() {
        return SpeechToTextSDK$.MODULE$.read();
    }

    public static Object load(String string) {
        return SpeechToTextSDK$.MODULE$.load(string);
    }

    public String uid() {
        return this.uid;
    }

    public SparkBindings<SpeechResponse> responseTypeBinding() {
        return this.responseTypeBinding;
    }

    public Iterator<SpeechResponse> inputStreamToText(InputStream stream, String audioFormat, URI uri, String speechKey, String profanity, boolean wordLevelTimestamps, String language, String format, Option<String> defaultAudioFormat, Seq<TranscriptionParticipant> participants) {
        BoxedUnit boxedUnit;
        SpeechConfig speechConfig = this.getSpeechConfig(uri, speechKey, language, profanity, wordLevelTimestamps, format);
        PullAudioInputStream pullStream = this.getPullStream(stream, audioFormat, defaultAudioFormat);
        AudioConfig audioConfig = AudioConfig.fromStreamInput((AudioInputStream)pullStream);
        SpeechRecognizer recognizer = new SpeechRecognizer(speechConfig, audioConfig);
        Connection connection = Connection.fromRecognizer((Recognizer)recognizer);
        connection.setMessageProperty("speech.config", "application", new StringBuilder(35).append("{\"name\":\"synapseml\", \"version\": \"").append(BuildInfo$.MODULE$.version()).append("\"}").toString());
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        recognizer.recognized.addEventListener(this.makeEventHandler((Function2 & Serializable & scala.Serializable)(s, e) -> {
            SpeechToTextSDK.recognizedHandler$1(s, e, queue);
            return BoxedUnit.UNIT;
        }));
        recognizer.sessionStopped.addEventListener(this.makeEventHandler((Function2 & Serializable & scala.Serializable)(s, e) -> {
            SpeechToTextSDK.sessionStoppedHandler$1(s, e, queue, recognizer, pullStream, speechConfig, audioConfig);
            return BoxedUnit.UNIT;
        }));
        recognizer.startContinuousRecognitionAsync().get();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getExtraFfmpegArgs())).contains((Object)"-t")) {
            int timeLimit = new StringOps(Predef$.MODULE$.augmentString(this.getExtraFfmpegArgs()[new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getExtraFfmpegArgs())).indexOf((Object)"-t") + 1])).toInt();
            boxedUnit = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                scala.concurrent.package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep((timeLimit + 20) * 1000));
                queue.put(None$.MODULE$);
                SpeechToTextSDK.cleanUp$1(recognizer, pullStream, speechConfig, audioConfig);
            }, (ExecutionContext)ExecutionContext$.MODULE$.global());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new BlockingQueueIterator(queue, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SpeechToTextSDK.cleanUp$1(recognizer, pullStream, speechConfig, audioConfig)).map((Function1 & Serializable & scala.Serializable)jsonString -> (SpeechResponse)package$.MODULE$.enrichString(jsonString).parseJson().convertTo(SpeechFormat$.MODULE$.SpeechResponseFormat()));
    }

    private static final void recognizedHandler$1(Object s, SpeechRecognitionEventArgs e, LinkedBlockingQueue queue$1) {
        if (e.getResult().getReason() == ResultReason.RecognizedSpeech) {
            queue$1.put(new Some((Object)e.getResult().getProperties().getProperty(PropertyId.SpeechServiceResponse_JsonResult)));
            return;
        }
    }

    private static final void cleanUp$1(SpeechRecognizer recognizer$1, PullAudioInputStream pullStream$1, SpeechConfig speechConfig$2, AudioConfig audioConfig$1) {
        recognizer$1.stopContinuousRecognitionAsync().get();
        Option$.MODULE$.apply((Object)pullStream$1).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.close();
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)speechConfig$2).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.close();
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)audioConfig$1).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.close();
            return BoxedUnit.UNIT;
        });
    }

    private static final void sessionStoppedHandler$1(Object s, SessionEventArgs e, LinkedBlockingQueue queue$1, SpeechRecognizer recognizer$1, PullAudioInputStream pullStream$1, SpeechConfig speechConfig$2, AudioConfig audioConfig$1) {
        queue$1.put(None$.MODULE$);
        SpeechToTextSDK.cleanUp$1(recognizer$1, pullStream$1, speechConfig$2, audioConfig$1);
    }

    public SpeechToTextSDK(String uid) {
        this.uid = uid;
        this.logClass(FeatureNames.AiServices$.MODULE$.Speech());
        this.responseTypeBinding = SpeechResponse$.MODULE$;
    }

    public SpeechToTextSDK() {
        this(Identifiable$.MODULE$.randomUID("SpeechToTextSDK"));
    }
}

