/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.services.search;

import com.microsoft.azure.synapse.ml.core.contracts.HasOutputCol;
import com.microsoft.azure.synapse.ml.io.http.ErrorUtils$;
import com.microsoft.azure.synapse.ml.io.http.HasErrorCol;
import com.microsoft.azure.synapse.ml.io.powerbi.StreamMaterializer;
import com.microsoft.azure.synapse.ml.services.search.AddDocuments;
import com.microsoft.azure.synapse.ml.services.search.AlgorithmConfigs;
import com.microsoft.azure.synapse.ml.services.search.AzureSearchAPIConstants$;
import com.microsoft.azure.synapse.ml.services.search.AzureSearchProtocol$;
import com.microsoft.azure.synapse.ml.services.search.HasActionCol;
import com.microsoft.azure.synapse.ml.services.search.HasIndexName;
import com.microsoft.azure.synapse.ml.services.search.HasServiceName;
import com.microsoft.azure.synapse.ml.services.search.IndexField;
import com.microsoft.azure.synapse.ml.services.search.IndexInfo;
import com.microsoft.azure.synapse.ml.services.search.IndexJsonGetter;
import com.microsoft.azure.synapse.ml.services.search.IndexLister;
import com.microsoft.azure.synapse.ml.services.search.IndexParser;
import com.microsoft.azure.synapse.ml.services.search.ScoringProfile;
import com.microsoft.azure.synapse.ml.services.search.SearchIndex$;
import com.microsoft.azure.synapse.ml.services.search.VectorColParams;
import com.microsoft.azure.synapse.ml.services.search.VectorSearch;
import com.microsoft.azure.synapse.ml.stages.HasBatchSize;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import org.apache.log4j.LogManager;
import org.apache.spark.injections.UDFUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.SQLDataTypes$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.ForeachWriter;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import spray.json.package$;

public final class AzureSearchWriter$
implements IndexParser,
IndexJsonGetter,
Logging {
    public static AzureSearchWriter$ MODULE$;
    private final org.apache.log4j.Logger Logger;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new AzureSearchWriter$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String getIndexJsonFromExistingIndex(String key, String serviceName, String indexName, String apiVersion) {
        return IndexJsonGetter.getIndexJsonFromExistingIndex$(this, key, serviceName, indexName, apiVersion);
    }

    @Override
    public String getIndexJsonFromExistingIndex$default$4() {
        return IndexJsonGetter.getIndexJsonFromExistingIndex$default$4$(this);
    }

    @Override
    public Seq<String> getExisting(String key, String serviceName, String apiVersion) {
        return IndexLister.getExisting$(this, key, serviceName, apiVersion);
    }

    @Override
    public String getExisting$default$3() {
        return IndexLister.getExisting$default$3$(this);
    }

    @Override
    public IndexInfo parseIndexJson(String str) {
        return IndexParser.parseIndexJson$(this, str);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public org.apache.log4j.Logger Logger() {
        return this.Logger;
    }

    private Option<Row> checkForErrors(boolean fatal, Row errorRow, Row inputRow) {
        return Option$.MODULE$.apply((Object)errorRow).map((Function1 & Serializable & scala.Serializable)r -> {
            String message = new StringBuilder(37).append("Service Exception:\n\t ").append(r.toString()).append(" \n for input:\n\t ").append(inputRow.toString()).toString();
            if (fatal) {
                throw new RuntimeException(message);
            }
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
            return r;
        });
    }

    private Dataset<Row> filterOutNulls(Dataset<Row> df, String collectionColName) {
        return df.withColumn(collectionColName, functions$.MODULE$.expr(new StringBuilder(28).append("filter(").append(collectionColName).append(", x -> x is not null)").toString()));
    }

    private Seq<IndexField> convertFields(Seq<StructField> fields, String keyCol, String searchActionCol, Option<Seq<VectorColParams>> vectorCols, Option<String> prefix) {
        return (Seq)((TraversableLike)fields.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$convertFields$1(searchActionCol, x$1)))).map((Function1 & Serializable & scala.Serializable)sf -> {
            String fullName = (String)prefix.map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(0).append((String)x$2).append(sf.name()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> sf.name());
            boolean isVector = vectorCols.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$convertFields$6(fullName$1, x$4)))));
            Tuple2<String, Option<Seq<IndexField>>> tuple2 = MODULE$.sparkTypeToEdmType(sf.dataType(), MODULE$.sparkTypeToEdmType$default$2());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String innerType = (String)tuple2._1();
            String innerType2 = innerType;
            String string = keyCol;
            String string2 = fullName;
            return new IndexField(sf.name(), innerType2, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)(!(string != null ? !string.equals(string2) : string2 != null) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)) : None$.MODULE$), (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, MODULE$.structFieldToSearchFields(sf.dataType(), keyCol, searchActionCol, (Option<Seq<VectorColParams>>)None$.MODULE$, (Option<String>)new Some((Object)new StringBuilder(1).append((String)prefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append(sf.name()).append(".").toString())), (Option<Object>)(isVector ? ((IterableLike)vectorCols.get()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$convertFields$8(fullName, x$5))).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.dimension())) : None$.MODULE$), (Option<String>)(isVector ? new Some((Object)AzureSearchAPIConstants$.MODULE$.VectorConfigName()) : None$.MODULE$));
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Option<Seq<IndexField>> structFieldToSearchFields(DataType schema, String keyCol, String searchActionCol, Option<Seq<VectorColParams>> vectorCols, Option<String> prefix) {
        ArrayType arrayType;
        DataType dataType;
        DataType dataType2 = schema;
        if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] fields = structType.fields();
            return new Some(this.convertFields((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])fields), keyCol, searchActionCol, vectorCols, prefix));
        }
        if (dataType2 instanceof ArrayType && (dataType = (arrayType = (ArrayType)dataType2).elementType()) instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return new Some(this.convertFields((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])fields), keyCol, searchActionCol, (Option<Seq<VectorColParams>>)None$.MODULE$, prefix));
        }
        return None$.MODULE$;
    }

    private Option<String> structFieldToSearchFields$default$5() {
        return None$.MODULE$;
    }

    private Seq<VectorColParams> parseVectorColsJson(String str) {
        return (Seq)package$.MODULE$.enrichString(str).parseJson().convertTo(AzureSearchProtocol$.MODULE$.seqFormat(AzureSearchProtocol$.MODULE$.VcpEnc()));
    }

    private Dataset<Row> convertDateTimeToISO8601(Dataset<Row> df, String indexJson) {
        Seq<IndexField> indexFields = this.parseIndexJson(indexJson).fields();
        Seq dateFields = (Seq)((TraversableLike)indexFields.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$convertDateTimeToISO8601$1(x$7)))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.name(), Seq$.MODULE$.canBuildFrom());
        return (Dataset)dateFields.foldLeft(df, (Function2 & Serializable & scala.Serializable)(currentDF, fieldName) -> {
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])currentDF.columns())).contains(fieldName)) {
                DataType fieldType = currentDF.schema().apply(fieldName).dataType();
                DataType dataType = fieldType;
                if (TimestampType$.MODULE$.equals(dataType)) {
                    return currentDF.withColumn(fieldName, functions$.MODULE$.when(functions$.MODULE$.col(fieldName).isNotNull(), (Object)functions$.MODULE$.date_format(functions$.MODULE$.to_utc_timestamp(functions$.MODULE$.col(fieldName), "UTC"), "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
                }
                if (DateType$.MODULE$.equals(dataType)) {
                    return currentDF.withColumn(fieldName, functions$.MODULE$.when(functions$.MODULE$.col(fieldName).isNotNull(), (Object)functions$.MODULE$.date_format(functions$.MODULE$.col(fieldName), "yyyy-MM-dd'T'00:00:00.000'Z'")));
                }
                if (StringType$.MODULE$.equals(dataType)) {
                    return currentDF;
                }
                throw new IllegalArgumentException(new StringBuilder(75).append("Field ").append((String)fieldName).append(" is defined as Edm.DateTimeOffset in index but has type ").append(fieldType).append(" in DataFrame").toString());
            }
            return currentDF;
        });
    }

    private String dfToIndexJson(StructType schema, String indexName, String keyCol, String searchActionCol, Option<Seq<VectorColParams>> vectorCols) {
        Some vectorConfig = new Some((Object)new VectorSearch((Seq<AlgorithmConfigs>)((Seq)new .colon.colon((Object)new AlgorithmConfigs(AzureSearchAPIConstants$.MODULE$.VectorConfigName(), AzureSearchAPIConstants$.MODULE$.VectorSearchAlgorithm()), (List)Nil$.MODULE$))));
        IndexInfo is = new IndexInfo((Option<String>)new Some((Object)indexName), (Seq<IndexField>)((Seq)this.structFieldToSearchFields((DataType)schema, keyCol, searchActionCol, vectorCols, this.structFieldToSearchFields$default$5()).get()), (Option<Seq<String>>)None$.MODULE$, (Option<Seq<ScoringProfile>>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<VectorSearch>)(vectorCols.isEmpty() ? None$.MODULE$ : vectorConfig));
        return package$.MODULE$.enrichAny((Object)is).toJson(AzureSearchProtocol$.MODULE$.IiEnc()).compactPrint();
    }

    private Dataset<Row> prepareDF(Dataset<Row> df, Map<String, String> options) {
        Dataset dataset;
        Tuple2 tuple2;
        Tuple2 tuple22;
        Set applicableOptions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"subscriptionKey", "actionCol", "serviceName", "indexName", "indexJson", "apiVersion", "batchSize", "fatalErrors", "filterNulls", "keyCol", "vectorCols"}));
        options.keys().foreach((Function1 & Serializable & scala.Serializable)k -> {
            Predef$.MODULE$.assert(applicableOptions.apply((Object)k), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(k).append(" not an applicable option ").append(applicableOptions$1.toList()).toString());
            return BoxedUnit.UNIT;
        });
        String subscriptionKey = (String)options.apply((Object)"subscriptionKey");
        String actionCol = (String)options.getOrElse((Object)"actionCol", (Function0 & Serializable & scala.Serializable)() -> "@search.action");
        String serviceName = (String)options.apply((Object)"serviceName");
        Option indexJsonOpt = options.get((Object)"indexJson");
        String apiVersion = (String)options.getOrElse((Object)"apiVersion", (Function0 & Serializable & scala.Serializable)() -> AzureSearchAPIConstants$.MODULE$.DefaultAPIVersion());
        int batchSize = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)"batchSize", (Function0 & Serializable & scala.Serializable)() -> "100"))).toInt();
        boolean fatalErrors = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)"fatalErrors", (Function0 & Serializable & scala.Serializable)() -> "true"))).toBoolean();
        boolean filterNulls = new StringOps(Predef$.MODULE$.augmentString((String)options.getOrElse((Object)"filterNulls", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
        Option vectorColsInfo = options.get((Object)"vectorCols");
        Option keyCol = options.get((Object)"keyCol");
        String indexName = (String)options.getOrElse((Object)"indexName", (Function0 & Serializable & scala.Serializable)() -> (String)MODULE$.parseIndexJson((String)indexJsonOpt.get()).name().get());
        if (indexJsonOpt.isDefined()) {
            new .colon.colon((Object)"keyCol", (List)new .colon.colon((Object)"indexName", (List)new .colon.colon((Object)"vectorCols", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)opt -> {
                Predef$.MODULE$.assert(!options.contains((Object)opt), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Cannot set both indexJson options and ").append(opt).toString());
                return BoxedUnit.UNIT;
            });
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).foreach((Function1 & Serializable & scala.Serializable)sf -> {
            AzureSearchWriter$.$anonfun$prepareDF$11(sf);
            return BoxedUnit.UNIT;
        });
        if (this.getExisting(subscriptionKey, serviceName, apiVersion).contains((Object)indexName)) {
            if (indexJsonOpt.isDefined()) {
                String arg$macro$1 = indexName;
                Predef$.MODULE$.println((Object)new StringBuilder(0).append(new StringOps("indexJsonOpt is specified, however an index for %s already exists,").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}))).append("we will use the index definition obtained from the existing index instead").toString());
            }
            String existingIndexJson = this.getIndexJsonFromExistingIndex(subscriptionKey, serviceName, indexName, this.getIndexJsonFromExistingIndex$default$4());
            Seq<Tuple2<String, String>> vectorColNameTypeTuple = this.getVectorColConf(existingIndexJson);
            tuple22 = new Tuple2((Object)existingIndexJson, this.makeColsCompatible(vectorColNameTypeTuple, df));
        } else if (indexJsonOpt.isDefined()) {
            Seq<Tuple2<String, String>> vectorColNameTypeTuple = this.getVectorColConf((String)indexJsonOpt.get());
            tuple22 = new Tuple2(indexJsonOpt.get(), this.makeColsCompatible(vectorColNameTypeTuple, df));
        } else {
            Option vectorCols = vectorColsInfo.map((Function1 & Serializable & scala.Serializable)str -> MODULE$.parseVectorColsJson((String)str));
            Seq vectorColNameTypeTuple = (Seq)vectorCols.map((Function1 & Serializable & scala.Serializable)x$9 -> (Seq)x$9.map((Function1 & Serializable & scala.Serializable)vc -> new Tuple2((Object)vc.name(), (Object)"Collection(Edm.Single)"), Seq$.MODULE$.canBuildFrom())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
            Dataset<Row> newDF = this.makeColsCompatible((Seq<Tuple2<String, String>>)vectorColNameTypeTuple, df);
            String inferredIndexJson = this.dfToIndexJson(newDF.schema(), indexName, (String)keyCol.getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), actionCol, (Option<Seq<VectorColParams>>)vectorCols);
            tuple22 = tuple2 = new Tuple2((Object)inferredIndexJson, newDF);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String indexJson = (String)tuple2._1();
        Dataset preppedDF = (Dataset)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)indexJson, (Object)preppedDF);
        String indexJson2 = (String)tuple23._1();
        Dataset preppedDF2 = (Dataset)tuple23._2();
        this.parseIndexJson(indexJson2).fields().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            AzureSearchWriter$.$anonfun$prepareDF$17(x$11);
            return BoxedUnit.UNIT;
        });
        SearchIndex$.MODULE$.createIfNoneExists(subscriptionKey, serviceName, indexJson2, apiVersion);
        Dataset dateConvertedDF = this.convertDateTimeToISO8601((Dataset<Row>)preppedDF2, indexJson2);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "checking schema parity");
        this.checkSchemaParity(dateConvertedDF.schema(), indexJson2, actionCol);
        if (filterNulls) {
            Seq collectionColumns = (Seq)((TraversableLike)this.parseIndexJson(indexJson2).fields().filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$prepareDF$20(x$12)))).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.name(), Seq$.MODULE$.canBuildFrom());
            dataset = (Dataset)collectionColumns.foldLeft(dateConvertedDF, (Function2 & Serializable & scala.Serializable)(ndf, c) -> MODULE$.filterOutNulls((Dataset<Row>)ndf, (String)c));
        } else {
            dataset = dateConvertedDF;
        }
        Dataset df1 = dataset;
        return ((AddDocuments)((HasErrorCol)((HasOutputCol)((HasBatchSize)((HasActionCol)((Object)((HasIndexName)((Object)((HasServiceName)((Object)new AddDocuments().setSubscriptionKey(subscriptionKey))).setServiceName(serviceName))).setIndexName(indexName))).setActionCol(actionCol)).setBatchSize(batchSize)).setOutputCol("out")).setErrorCol("error")).transform(df1).withColumn("error", UDFUtils$.MODULE$.oldUdf((Function2 & Serializable & scala.Serializable)(errorRow, inputRow) -> MODULE$.checkForErrors(fatalErrors, (Row)errorRow, (Row)inputRow), (DataType)ErrorUtils$.MODULE$.ErrorSchema()).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("error"), functions$.MODULE$.col("input")})));
    }

    private Map<String, String> prepareDF$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    private void assertNoNestedVectors(Seq<IndexField> fields) {
        fields.foreach((Function1 & Serializable & scala.Serializable)field -> {
            AzureSearchWriter$.checkVectorField$1(field);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<Tuple2<String, String>> getVectorColConf(String indexJson) {
        return (Seq)((TraversableLike)this.parseIndexJson(indexJson).fields().filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$getVectorColConf$1(f)))).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.name(), (Object)f.type()), Seq$.MODULE$.canBuildFrom());
    }

    private Dataset<Row> makeColsCompatible(Seq<Tuple2<String, String>> vectorColNameTypeTuple, Dataset<Row> df) {
        return (Dataset)vectorColNameTypeTuple.foldLeft(df, AzureSearchWriter$::$anonfun$makeColsCompatible$1);
    }

    private boolean isEdmCollection(String t) {
        return t.startsWith("Collection(") && t.endsWith(")");
    }

    private String getEdmCollectionElement(String t) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(t.substring("Collection(".length()))).dropRight(1);
    }

    public DataType edmTypeToSparkType(String dt, Option<Seq<IndexField>> fields) {
        String string = dt;
        if (this.isEdmCollection(string)) {
            return new ArrayType(this.edmTypeToSparkType(this.getEdmCollectionElement(string), fields), false);
        }
        if ("Edm.String".equals(string)) {
            return StringType$.MODULE$;
        }
        if ("Edm.Boolean".equals(string)) {
            return BooleanType$.MODULE$;
        }
        if ("Edm.Int64".equals(string)) {
            return LongType$.MODULE$;
        }
        if ("Edm.Int32".equals(string)) {
            return IntegerType$.MODULE$;
        }
        if ("Edm.Double".equals(string)) {
            return DoubleType$.MODULE$;
        }
        if ("Edm.Single".equals(string)) {
            return FloatType$.MODULE$;
        }
        if ("Edm.DateTimeOffset".equals(string)) {
            return StringType$.MODULE$;
        }
        if ("Edm.GeographyPoint".equals(string)) {
            return StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("type", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("coordinates", (DataType)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
        }
        if ("Edm.ComplexType".equals(string)) {
            return StructType$.MODULE$.apply((Seq)((TraversableLike)fields.get()).map((Function1 & Serializable & scala.Serializable)f -> new StructField(f.name(), MODULE$.edmTypeToSparkType(f.type(), f.fields()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom()));
        }
        throw new MatchError((Object)string);
    }

    private Tuple2<String, Option<Seq<IndexField>>> sparkTypeToEdmType(DataType dt, boolean allowCollections) {
        boolean bl = false;
        ArrayType arrayType = null;
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            bl = true;
            arrayType = (ArrayType)dataType;
            DataType it = arrayType.elementType();
            if (allowCollections) {
                Tuple2<String, Option<Seq<IndexField>>> tuple2 = this.sparkTypeToEdmType(it, false);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String innerType = (String)tuple2._1();
                Option innerFields = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)innerType, (Object)innerFields);
                String innerType2 = (String)tuple22._1();
                Option innerFields2 = (Option)tuple22._2();
                return new Tuple2((Object)new StringBuilder(12).append("Collection(").append(innerType2).append(")").toString(), (Object)innerFields2);
            }
        }
        if (bl) {
            DataType it = arrayType.elementType();
            if (!allowCollections) {
                Tuple2<String, Option<Seq<IndexField>>> tuple2 = this.sparkTypeToEdmType(it, allowCollections);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String innerType = (String)tuple2._1();
                Option innerFields = (Option)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)innerType, (Object)innerFields);
                String innerType3 = (String)tuple23._1();
                Option innerFields3 = (Option)tuple23._2();
                return new Tuple2((Object)"Edm.ComplexType", (Object)innerFields3);
            }
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.String", (Object)None$.MODULE$);
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.Boolean", (Object)None$.MODULE$);
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.Int32", (Object)None$.MODULE$);
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.Int64", (Object)None$.MODULE$);
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.Double", (Object)None$.MODULE$);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.Single", (Object)None$.MODULE$);
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.DateTimeOffset", (Object)None$.MODULE$);
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return new Tuple2((Object)"Edm.DateTimeOffset", (Object)None$.MODULE$);
        }
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            return new Tuple2((Object)"Edm.ComplexType", (Object)new Some(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> {
                Tuple2<String, Option<Seq<IndexField>>> tuple2 = MODULE$.sparkTypeToEdmType(f.dataType(), MODULE$.sparkTypeToEdmType$default$2());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String innerType = (String)tuple2._1();
                Option innerFields = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)innerType, (Object)innerFields);
                String innerType2 = (String)tuple22._1();
                Option innerFields2 = (Option)tuple22._2();
                return new IndexField(f.name(), innerType2, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<Seq<String>>)None$.MODULE$, (Option<Seq<IndexField>>)innerFields2, (Option<Object>)None$.MODULE$, (Option<String>)None$.MODULE$);
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        }
        throw new MatchError((Object)dataType);
    }

    private boolean sparkTypeToEdmType$default$2() {
        return true;
    }

    private boolean dtEqualityModuloNullability(DataType dt1, DataType dt2) {
        Tuple2 tuple2;
        while ((tuple2 = new Tuple2((Object)dt1, (Object)dt2)) != null) {
            DataType it2;
            DataType dataType = (DataType)tuple2._1();
            DataType dataType2 = (DataType)tuple2._2();
            if (!(dataType instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)dataType;
            DataType it1 = arrayType.elementType();
            if (!(dataType2 instanceof ArrayType)) break;
            ArrayType arrayType2 = (ArrayType)dataType2;
            dt2 = it2 = arrayType2.elementType();
            dt1 = it1;
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            DataType dataType3 = (DataType)tuple2._2();
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                StructField[] fields1 = structType.fields();
                if (dataType3 instanceof StructType) {
                    StructType structType2 = (StructType)dataType3;
                    StructField[] fields2 = structType2.fields();
                    return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields1)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$dtEqualityModuloNullability$1(x0$1)));
                }
            }
        }
        DataType dataType = dt1;
        DataType dataType4 = dt2;
        return !(dataType != null ? !dataType.equals(dataType4) : dataType4 != null);
    }

    private void checkSchemaParity(StructType schema, String indexJson, String searchActionCol) {
        IndexInfo indexInfo = this.parseIndexJson(indexJson);
        Map indexFields = ((TraversableOnce)indexInfo.fields().map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.name(), (Object)MODULE$.edmTypeToSparkType(f.type(), f.fields())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        DataType dataType = schema.apply(searchActionCol).dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null));
        ((List)schema.toList().filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)AzureSearchWriter$.$anonfun$checkSchemaParity$2(searchActionCol, x$18)))).foreach((Function1 & Serializable & scala.Serializable)field -> {
            AzureSearchWriter$.$anonfun$checkSchemaParity$3(indexFields, field);
            return BoxedUnit.UNIT;
        });
    }

    public DataStreamWriter<Row> stream(Dataset<Row> df, Map<String, String> options) {
        return this.prepareDF(df, options).writeStream().foreach((ForeachWriter)new StreamMaterializer());
    }

    public void write(Dataset<Row> df, Map<String, String> options) {
        this.prepareDF(df, options).foreach((Function1 & Serializable & scala.Serializable)x$19 -> {
            AzureSearchWriter$.$anonfun$write$1(x$19);
            return BoxedUnit.UNIT;
        });
    }

    public DataStreamWriter<Row> stream(Dataset<Row> df, HashMap<String, String> options) {
        return this.stream(df, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    public Map<String, String> stream$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public void write(Dataset<Row> df, HashMap<String, String> options) {
        this.write(df, (Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    public Map<String, String> write$default$2() {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$convertFields$1(String searchActionCol$1, StructField x$1) {
        String string = x$1.name();
        String string2 = searchActionCol$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$convertFields$6(String fullName$1, VectorColParams x$4) {
        String string = x$4.name();
        String string2 = fullName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$convertFields$8(String fullName$1, VectorColParams x$5) {
        String string = x$5.name();
        String string2 = fullName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$convertDateTimeToISO8601$1(IndexField x$7) {
        String string = x$7.type();
        String string2 = "Edm.DateTimeOffset";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$prepareDF$11(StructField sf) {
        ArrayType arrayType;
        DataType dataType;
        DataType dataType2 = sf.dataType();
        if (dataType2 instanceof ArrayType && (dataType = (arrayType = (ArrayType)dataType2).elementType()) instanceof ArrayType) {
            throw new IllegalArgumentException(new StringBuilder(102).append("Cannot make an index with a doubly nested array, ").append("please wrap column ").append(sf.name()).append(" with a struct to avoid this error").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$prepareDF$17(IndexField x$11) {
        x$11.fields().foreach((Function1 & Serializable & scala.Serializable)fields -> {
            AzureSearchWriter$.MODULE$.assertNoNestedVectors((Seq<IndexField>)fields);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$prepareDF$20(IndexField x$12) {
        return x$12.type().startsWith("Collection");
    }

    private static final void checkVectorField$1(IndexField field) {
        if (field.dimensions().nonEmpty() && field.vectorSearchConfiguration().nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(82).append("Nested field ").append(field.name()).append(" is a vector field, vector fields in nested").append(" fields are not supported.").toString());
        }
        field.fields().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
            x$14.foreach((Function1 & Serializable & scala.Serializable)field -> {
                AzureSearchWriter$.checkVectorField$1(field);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getVectorColConf$1(IndexField f) {
        return f.vectorSearchConfiguration().nonEmpty() && f.dimensions().nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$makeColsCompatible$2(String colName$1) {
        return new StringBuilder(91).append("Vector column ").append(colName$1).append(" needs to be one of (ArrayType(FloatType), ArrayType(DoubleType), VectorType)").toString();
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Dataset $anonfun$makeColsCompatible$1(Dataset x0$1, Tuple2 x1$1) {
        block4: {
            block6: {
                block5: {
                    var4_2 = new Tuple2((Object)x0$1, (Object)x1$1);
                    if (var4_2 == null) break block4;
                    accDF = (Dataset)var4_2._1();
                    var6_4 = (Tuple2)var4_2._2();
                    if (var6_4 == null) break block4;
                    colName = (String)var6_4._1();
                    colType = (String)var6_4._2();
                    if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])accDF.columns())).contains((Object)colName)) {
                        Predef$.MODULE$.println((Object)new StringBuilder(90).append("Column ").append(colName).append(" is specified in either indexJson or vectorCols but not found in dataframe ").append("columns ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])accDF.columns())).toList()).toString());
                        return accDF;
                    }
                    colDataType = accDF.schema().apply(colName).dataType();
                    var10_8 = colDataType;
                    if (!(var10_8 instanceof ArrayType)) break block5;
                    var11_9 = (ArrayType)var10_8;
                    v0 = elementType = var11_9.elementType();
                    var13_11 = FloatType$.MODULE$;
                    if (!(v0 == null ? var13_11 != null : v0.equals(var13_11) == false)) ** GOTO lbl-1000
                    v1 = elementType;
                    var14_12 = DoubleType$.MODULE$;
                    if (!(v1 != null ? v1.equals(var14_12) == false : var14_12 != null)) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else {
                        v2 = false;
                    }
                    break block6;
                }
                v3 = SQLDataTypes$.MODULE$.VectorType();
                var15_13 = var10_8;
                v2 = !(v3 != null ? v3.equals(var15_13) == false : var15_13 != null);
            }
            Predef$.MODULE$.assert(v2, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$makeColsCompatible$2(java.lang.String ), ()Ljava/lang/String;)((String)colName));
            if (colDataType instanceof ArrayType) {
                return accDF.withColumn(colName, accDF.apply(colName).cast(AzureSearchWriter$.MODULE$.edmTypeToSparkType(colType, (Option<Seq<IndexField>>)None$.MODULE$)));
            }
            modifiedDF = accDF.withColumn(colName, org.apache.spark.ml.functions$.MODULE$.vector_to_array(accDF.apply(colName), org.apache.spark.ml.functions$.MODULE$.vector_to_array$default$2()));
            return modifiedDF.withColumn(colName, modifiedDF.apply(colName).cast(AzureSearchWriter$.MODULE$.edmTypeToSparkType(colType, (Option<Seq<IndexField>>)None$.MODULE$)));
        }
        throw new MatchError((Object)var4_2);
    }

    public static final /* synthetic */ boolean $anonfun$dtEqualityModuloNullability$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField sf1 = (StructField)tuple2._1();
            StructField sf2 = (StructField)tuple2._2();
            String string = sf1.name();
            String string2 = sf2.name();
            return !(string != null ? !string.equals(string2) : string2 != null) && MODULE$.dtEqualityModuloNullability(sf1.dataType(), sf2.dataType());
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$checkSchemaParity$2(String searchActionCol$2, StructField x$18) {
        String string = x$18.name();
        String string2 = searchActionCol$2;
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$checkSchemaParity$3(Map indexFields$1, StructField field) {
        DataType indexType = (DataType)indexFields$1.getOrElse((Object)field.name(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(35).append(field.name()).append(" not found in search index fields: ").append(indexFields$1.keys().toList()).toString());
        });
        Predef$.MODULE$.assert(MODULE$.dtEqualityModuloNullability(indexType, field.dataType()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("field ").append(field.name()).append(" requires type").append(" ").append(indexType).append(" your dataframe column is of type ").append(field.dataType()).toString());
    }

    public static final /* synthetic */ void $anonfun$write$1(Row x$19) {
    }

    private AzureSearchWriter$() {
        MODULE$ = this;
        IndexParser.$init$(this);
        IndexLister.$init$(this);
        IndexJsonGetter.$init$(this);
        Logging.$init$((Logging)this);
        this.Logger = LogManager.getRootLogger();
    }
}

