/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.services.speech;

import com.microsoft.azure.synapse.ml.build.BuildInfo$;
import com.microsoft.azure.synapse.ml.core.schema.SparkBindings;
import com.microsoft.azure.synapse.ml.logging.FeatureNames;
import com.microsoft.azure.synapse.ml.services.speech.BlockingQueueIterator;
import com.microsoft.azure.synapse.ml.services.speech.ConversationTranscription$;
import com.microsoft.azure.synapse.ml.services.speech.SpeechFormat$;
import com.microsoft.azure.synapse.ml.services.speech.SpeechSDKBase;
import com.microsoft.azure.synapse.ml.services.speech.TranscriptionParticipant;
import com.microsoft.azure.synapse.ml.services.speech.TranscriptionResponse;
import com.microsoft.azure.synapse.ml.services.speech.TranscriptionResponse$;
import com.microsoft.cognitiveservices.speech.Connection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.ServicePropertyChannel;
import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStream;
import com.microsoft.cognitiveservices.speech.transcription.Conversation;
import com.microsoft.cognitiveservices.speech.transcription.ConversationTranscriber;
import com.microsoft.cognitiveservices.speech.transcription.ConversationTranscriptionEventArgs;
import com.microsoft.cognitiveservices.speech.transcription.Participant;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import spray.json.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001ds!B\u0007\u000f\u0011\u0003ib!B\u0010\u000f\u0011\u0003\u0001\u0003BB&\u0002\t\u0003\t)\u0004C\u0005\u00028\u0005\t\t\u0011\"\u0003\u0002:\u0019!qD\u0004\u00014\u0011!iDA!b\u0001\n\u0003r\u0004\u0002\u0003&\u0005\u0005\u0003\u0005\u000b\u0011B \t\u000b-#A\u0011\u0001'\u0006\t9#\u0001e\u0014\u0005\b%\u0012\u0011\r\u0011\"\u0011T\u0011\u0019aF\u0001)A\u0005)\")1\n\u0002C\u0001;\")a\f\u0002C\u0001?\u0006I2i\u001c8wKJ\u001c\u0018\r^5p]R\u0013\u0018M\\:de&\u0004H/[8o\u0015\ty\u0001#\u0001\u0004ta\u0016,7\r\u001b\u0006\u0003#I\t\u0001b]3sm&\u001cWm\u001d\u0006\u0003'Q\t!!\u001c7\u000b\u0005U1\u0012aB:z]\u0006\u00048/\u001a\u0006\u0003/a\tQ!\u0019>ve\u0016T!!\u0007\u000e\u0002\u00135L7M]8t_\u001a$(\"A\u000e\u0002\u0007\r|Wn\u0001\u0001\u0011\u0005y\tQ\"\u0001\b\u00033\r{gN^3sg\u0006$\u0018n\u001c8Ue\u0006t7o\u0019:jaRLwN\\\n\u0006\u0003\u0005:\u0013q\u0006\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0007!\u0002$'D\u0001*\u0015\t\u0019\"F\u0003\u0002,Y\u0005)1\u000f]1sW*\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h\u0013\t\t\u0014FA\u000bD_6\u0004H.\u001a=QCJ\fWn\u001d*fC\u0012\f'\r\\3\u0011\u0005y!1c\u0001\u00035oA\u0011a$N\u0005\u0003m9\u0011Qb\u00159fK\u000eD7\u000bR&CCN,\u0007C\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0013\u0003\u001dawnZ4j]\u001eL!\u0001P\u001d\u0003!MKh.\u00199tK6cEj\\4hS:<\u0017aA;jIV\tq\b\u0005\u0002A\u000f:\u0011\u0011)\u0012\t\u0003\u0005\u000ej\u0011a\u0011\u0006\u0003\tr\ta\u0001\u0010:p_Rt\u0014B\u0001$$\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001*\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\u001b\u0013\u0001B;jI\u0002\na\u0001P5oSRtDC\u0001\u001aN\u0011\u0015it\u00011\u0001@\u00051\u0011Vm\u001d9p]N,G+\u001f9f!\tq\u0002+\u0003\u0002R\u001d\t)BK]1og\u000e\u0014\u0018\u000e\u001d;j_:\u0014Vm\u001d9p]N,\u0017a\u0005:fgB|gn]3UsB,')\u001b8eS:<W#\u0001+\u0011\u0007USv*D\u0001W\u0015\t9\u0006,\u0001\u0004tG\",W.\u0019\u0006\u00033J\tAaY8sK&\u00111L\u0016\u0002\u000e'B\f'o\u001b\"j]\u0012LgnZ:\u0002)I,7\u000f]8og\u0016$\u0016\u0010]3CS:$\u0017N\\4!)\u0005\u0011\u0014!E5oaV$8\u000b\u001e:fC6$v\u000eV3yiR\u0001\u0002-[:v{~\f\u0019!!\u0004\u0002\u0012\u0005U\u0011q\u0004\t\u0004C\u001a|eB\u00012e\u001d\t\u00115-C\u0001%\u0013\t)7%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u001dD'\u0001C%uKJ\fGo\u001c:\u000b\u0005\u0015\u001c\u0003\"\u00026\r\u0001\u0004Y\u0017AB:ue\u0016\fW\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006\u0011\u0011n\u001c\u0006\u0002a\u0006!!.\u0019<b\u0013\t\u0011XNA\u0006J]B,Ho\u0015;sK\u0006l\u0007\"\u0002;\r\u0001\u0004y\u0014aC1vI&|gi\u001c:nCRDQA\u001e\u0007A\u0002]\f1!\u001e:j!\tA80D\u0001z\u0015\tQx.A\u0002oKRL!\u0001`=\u0003\u0007U\u0013\u0016\nC\u0003\u007f\u0019\u0001\u0007q(A\u0005ta\u0016,7\r[&fs\"1\u0011\u0011\u0001\u0007A\u0002}\n\u0011\u0002\u001d:pM\u0006t\u0017\u000e^=\t\u000f\u0005\u0015A\u00021\u0001\u0002\b\u0005\u0019ro\u001c:e\u0019\u00164X\r\u001c+j[\u0016\u001cH/Y7qgB\u0019!%!\u0003\n\u0007\u0005-1EA\u0004C_>dW-\u00198\t\r\u0005=A\u00021\u0001@\u0003!a\u0017M\\4vC\u001e,\u0007BBA\n\u0019\u0001\u0007q(\u0001\u0004g_Jl\u0017\r\u001e\u0005\b\u0003/a\u0001\u0019AA\r\u0003I!WMZ1vYR\fU\u000fZ5p\r>\u0014X.\u0019;\u0011\t\t\nYbP\u0005\u0004\u0003;\u0019#AB(qi&|g\u000eC\u0004\u0002\"1\u0001\r!a\t\u0002\u0019A\f'\u000f^5dSB\fg\u000e^:\u0011\u000b\u0005\f)#!\u000b\n\u0007\u0005\u001d\u0002NA\u0002TKF\u00042AHA\u0016\u0013\r\tiC\u0004\u0002\u0019)J\fgn]2sSB$\u0018n\u001c8QCJ$\u0018nY5qC:$\bc\u0001\u0012\u00022%\u0019\u00111G\u0012\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0003u\t1B]3bIJ+7o\u001c7wKR\u0011\u00111\b\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011I8\u0002\t1\fgnZ\u0005\u0005\u0003\u000b\nyD\u0001\u0004PE*,7\r\u001e")
public class ConversationTranscription
extends SpeechSDKBase {
    private final String uid;
    private final SparkBindings<TranscriptionResponse> responseTypeBinding;

    public static MLReader<ConversationTranscription> read() {
        return ConversationTranscription$.MODULE$.read();
    }

    public static Object load(String string) {
        return ConversationTranscription$.MODULE$.load(string);
    }

    public String uid() {
        return this.uid;
    }

    public SparkBindings<TranscriptionResponse> responseTypeBinding() {
        return this.responseTypeBinding;
    }

    public Iterator<TranscriptionResponse> inputStreamToText(InputStream stream, String audioFormat, URI uri, String speechKey, String profanity, boolean wordLevelTimestamps, String language, String format, Option<String> defaultAudioFormat, Seq<TranscriptionParticipant> participants) {
        BoxedUnit boxedUnit;
        SpeechConfig speechConfig = this.getSpeechConfig(uri, speechKey, language, profanity, wordLevelTimestamps, format);
        speechConfig.setProperty("ConversationTranscriptionInRoomAndOnline", "true");
        speechConfig.setServiceProperty("transcriptionMode", "RealTimeAndAsync", ServicePropertyChannel.UriQueryParameter);
        String guid = UUID.randomUUID().toString();
        Conversation conversation = (Conversation)Conversation.createConversationAsync((SpeechConfig)speechConfig, (String)guid).get();
        participants.foreach((Function1 & Serializable & scala.Serializable)p -> (Participant)conversation.addParticipantAsync(Participant.from((String)p.name(), (String)p.language(), (String)p.signature())).get());
        PullAudioInputStream pullStream = this.getPullStream(stream, audioFormat, defaultAudioFormat);
        AudioConfig audioConfig = AudioConfig.fromStreamInput((AudioInputStream)pullStream);
        audioConfig.setProperty("f0f5debc-f8c9-4892-ac4b-90a7ab359fd2", "true");
        ConversationTranscriber transcriber = new ConversationTranscriber(audioConfig);
        conversation.getProperties().setProperty("DifferentiateGuestSpeakers", "true");
        transcriber.joinConversationAsync(conversation).get();
        Connection connection = Connection.fromRecognizer((Recognizer)transcriber);
        connection.setMessageProperty("speech.config", "application", new StringBuilder(35).append("{\"name\":\"synapseml\", \"version\": \"").append(BuildInfo$.MODULE$.version()).append("\"}").toString());
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        transcriber.transcribed.addEventListener(this.makeEventHandler((Function2 & Serializable & scala.Serializable)(s, e) -> {
            ConversationTranscription.recognizedHandler$2(s, e, queue);
            return BoxedUnit.UNIT;
        }));
        transcriber.sessionStopped.addEventListener(this.makeEventHandler((Function2 & Serializable & scala.Serializable)(s, e) -> {
            ConversationTranscription.sessionStoppedHandler$2(s, e, queue, transcriber, conversation, pullStream, speechConfig, audioConfig);
            return BoxedUnit.UNIT;
        }));
        transcriber.startTranscribingAsync().get();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getExtraFfmpegArgs())).contains((Object)"-t")) {
            int timeLimit = new StringOps(Predef$.MODULE$.augmentString(this.getExtraFfmpegArgs()[new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getExtraFfmpegArgs())).indexOf((Object)"-t") + 1])).toInt();
            boxedUnit = Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                scala.concurrent.package$.MODULE$.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep((timeLimit + 20) * 1000));
                queue.put(None$.MODULE$);
                ConversationTranscription.cleanUp$2(transcriber, conversation, pullStream, speechConfig, audioConfig);
            }, (ExecutionContext)ExecutionContext$.MODULE$.global());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new BlockingQueueIterator(queue, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConversationTranscription.cleanUp$2(transcriber, conversation, pullStream, speechConfig, audioConfig)).map((Function1 & Serializable & scala.Serializable)jsonString -> (TranscriptionResponse)package$.MODULE$.enrichString(jsonString).parseJson().convertTo(SpeechFormat$.MODULE$.TranscriptionResponseFormat()));
    }

    private static final void cleanUp$2(ConversationTranscriber transcriber$1, Conversation conversation$1, PullAudioInputStream pullStream$2, SpeechConfig speechConfig$3, AudioConfig audioConfig$2) {
        transcriber$1.stopTranscribingAsync().get();
        Option$.MODULE$.apply((Object)conversation$1).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.close();
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)pullStream$2).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.close();
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)speechConfig$3).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.close();
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)audioConfig$2).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            x$11.close();
            return BoxedUnit.UNIT;
        });
    }

    private static final void recognizedHandler$2(Object s, ConversationTranscriptionEventArgs e, LinkedBlockingQueue queue$2) {
        if (e.getResult().getReason() == ResultReason.RecognizedSpeech) {
            queue$2.put(new Some((Object)e.getResult().getProperties().getProperty(PropertyId.SpeechServiceResponse_JsonResult)));
            return;
        }
    }

    private static final void sessionStoppedHandler$2(Object s, SessionEventArgs e, LinkedBlockingQueue queue$2, ConversationTranscriber transcriber$1, Conversation conversation$1, PullAudioInputStream pullStream$2, SpeechConfig speechConfig$3, AudioConfig audioConfig$2) {
        queue$2.put(None$.MODULE$);
        ConversationTranscription.cleanUp$2(transcriber$1, conversation$1, pullStream$2, speechConfig$3, audioConfig$2);
    }

    public ConversationTranscription(String uid) {
        this.uid = uid;
        this.logClass(FeatureNames.AiServices$.MODULE$.Speech());
        this.responseTypeBinding = TranscriptionResponse$.MODULE$;
    }

    public ConversationTranscription() {
        this(Identifiable$.MODULE$.randomUID("ConversationTranscription"));
    }
}

