/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.onnx;

import ai.onnx.proto.OnnxMl;
import ai.onnxruntime.MapInfo;
import ai.onnxruntime.OnnxJavaType;
import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.SequenceInfo;
import ai.onnxruntime.TensorInfo;
import ai.onnxruntime.ValueInfo;
import com.microsoft.azure.synapse.ml.onnx.ONNXModel;
import com.microsoft.azure.synapse.ml.onnx.ONNXUtils;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Map;
import org.apache.spark.ml.linalg.SQLDataTypes$;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import shade.com.google.protobuf.ProtocolStringList;

public final class ONNXUtils$ {
    public static ONNXUtils$ MODULE$;

    static {
        new ONNXUtils$();
    }

    public DataType mapOnnxJavaTypeToDataType(OnnxJavaType javaType) {
        ByteType$ byteType$;
        OnnxJavaType onnxJavaType = javaType;
        if (OnnxJavaType.INT8.equals(onnxJavaType)) {
            byteType$ = ByteType$.MODULE$;
        } else if (OnnxJavaType.INT16.equals(onnxJavaType)) {
            byteType$ = ShortType$.MODULE$;
        } else if (OnnxJavaType.INT32.equals(onnxJavaType)) {
            byteType$ = IntegerType$.MODULE$;
        } else if (OnnxJavaType.INT64.equals(onnxJavaType)) {
            byteType$ = LongType$.MODULE$;
        } else if (OnnxJavaType.FLOAT.equals(onnxJavaType)) {
            byteType$ = FloatType$.MODULE$;
        } else if (OnnxJavaType.DOUBLE.equals(onnxJavaType)) {
            byteType$ = DoubleType$.MODULE$;
        } else if (OnnxJavaType.BOOL.equals(onnxJavaType)) {
            byteType$ = BooleanType$.MODULE$;
        } else if (OnnxJavaType.STRING.equals(onnxJavaType)) {
            byteType$ = StringType$.MODULE$;
        } else if (OnnxJavaType.UNKNOWN.equals(onnxJavaType)) {
            byteType$ = BinaryType$.MODULE$;
        } else {
            throw new MatchError((Object)onnxJavaType);
        }
        return byteType$;
    }

    public DataType mapTensorInfoToDataType(TensorInfo tensorInfo) {
        DataType dataType = this.mapOnnxJavaTypeToDataType(tensorInfo.type);
        return tensorInfo.isScalar() ? dataType : (tensorInfo.getShape().length == 1 ? dataType : ONNXUtils$.nestedArrayType$1(tensorInfo.getShape().length - 1, dataType));
    }

    public DataType mapValueInfoToDataType(ValueInfo valueInfo) {
        DataType dataType;
        block4: {
            ValueInfo valueInfo2;
            block5: {
                SequenceInfo sequenceInfo;
                while (true) {
                    if ((valueInfo2 = valueInfo) instanceof MapInfo) {
                        MapInfo mapInfo = (MapInfo)valueInfo2;
                        DataType keyDataType = this.mapOnnxJavaTypeToDataType(mapInfo.keyType);
                        DataType valueDataType = this.mapOnnxJavaTypeToDataType(mapInfo.valueType);
                        dataType = MapType$.MODULE$.apply(keyDataType, valueDataType);
                        break block4;
                    }
                    if (!(valueInfo2 instanceof SequenceInfo)) break block5;
                    sequenceInfo = (SequenceInfo)valueInfo2;
                    if (!sequenceInfo.sequenceOfMaps) break;
                    valueInfo = sequenceInfo.mapInfo;
                }
                dataType = this.mapOnnxJavaTypeToDataType(sequenceInfo.sequenceType);
                break block4;
            }
            if (valueInfo2 instanceof TensorInfo) {
                TensorInfo tensorInfo = (TensorInfo)valueInfo2;
                dataType = this.mapTensorInfoToDataType(tensorInfo);
            } else {
                throw new MatchError((Object)valueInfo2);
            }
        }
        return dataType;
    }

    public Seq<Object> mapOnnxValueToArray(OnnxValue value) {
        Seq seq;
        ValueInfo valueInfo = value.getInfo();
        if (valueInfo instanceof TensorInfo) {
            TensorInfo tensorInfo = (TensorInfo)valueInfo;
            seq = tensorInfo.isScalar() ? (Seq)new .colon.colon(value.getValue(), (List)Nil$.MODULE$) : Predef$.MODULE$.genericArrayOps(value.getValue()).toSeq();
        } else if (valueInfo instanceof SequenceInfo) {
            SequenceInfo sequenceInfo = (SequenceInfo)valueInfo;
            seq = sequenceInfo.sequenceOfMaps ? (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)value.getValue()).asScala()).toArray(ClassTag$.MODULE$.apply(Map.class)))).map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(x$1).asScala()).toMap(Predef$.MODULE$.$conforms()), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())) : (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)value.getValue()).asScala();
        } else if (valueInfo instanceof MapInfo) {
            seq = Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter((Map)value.getValue()).asScala()).toMap(Predef$.MODULE$.$conforms())});
        } else {
            throw new MatchError((Object)valueInfo);
        }
        return seq;
    }

    public OnnxTensor createTensor(OrtEnvironment env, TensorInfo tensorInfo, Seq<?> batchedValues) {
        long[] shape = tensorInfo.getShape();
        if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(shape)).tail())).contains((Object)BoxesRunTime.boxToInteger((int)-1))) {
            throw new Exception(new StringBuilder(90).append("The input tensor has shape [").append(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(shape)).mkString()).append("], ").append("but -1 is only allowed at the first dimension (batch size).").toString());
        }
        shape[0] = batchedValues.length();
        this.validateBatchShapes(batchedValues, shape);
        return this.loadTensorBuffer(env, tensorInfo, batchedValues, shape);
    }

    private void validateBatchShapes(Seq<?> batchedValues, long[] expectedShape) {
        batchedValues.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ONNXUtils$.$anonfun$validateBatchShapes$1(this, expectedShape, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public OnnxTensor loadTensorBuffer(OrtEnvironment env, TensorInfo tensorInfo, Seq<?> batchedValues, long[] shape) {
        OnnxTensor onnxTensor;
        int size = (int)BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(shape)).product((Numeric)Numeric.LongIsIntegral$.MODULE$));
        OnnxJavaType onnxJavaType = tensorInfo.type;
        if (OnnxJavaType.FLOAT.equals(onnxJavaType)) {
            FloatBuffer buffer = FloatBuffer.allocate(size);
            long actualCount = this.writeNestedSeqToBuffer(batchedValues, (Function1)(JFunction1.mcVF.sp & Serializable & scala.Serializable)x$2 -> buffer.put(x$2), (ClassTag)ClassTag$.MODULE$.Float());
            this.assertBufferElementsWritten(size, actualCount, shape);
            buffer.rewind();
            onnxTensor = OnnxTensor.createTensor((OrtEnvironment)env, (FloatBuffer)buffer, (long[])shape);
        } else if (OnnxJavaType.DOUBLE.equals(onnxJavaType)) {
            DoubleBuffer buffer = DoubleBuffer.allocate(size);
            long actualCount = this.writeNestedSeqToBuffer(batchedValues, (Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)x$3 -> buffer.put(x$3), (ClassTag)ClassTag$.MODULE$.Double());
            this.assertBufferElementsWritten(size, actualCount, shape);
            buffer.rewind();
            onnxTensor = OnnxTensor.createTensor((OrtEnvironment)env, (DoubleBuffer)buffer, (long[])shape);
        } else if (OnnxJavaType.INT8.equals(onnxJavaType)) {
            ByteBuffer buffer = ByteBuffer.allocate(size);
            long actualCount = this.writeNestedSeqToBuffer(batchedValues, (Function1 & Serializable & scala.Serializable)x$4 -> {
                buffer.put(BoxesRunTime.unboxToByte((Object)x$4));
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.Byte());
            this.assertBufferElementsWritten(size, actualCount, shape);
            buffer.rewind();
            onnxTensor = OnnxTensor.createTensor((OrtEnvironment)env, (ByteBuffer)buffer, (long[])shape);
        } else if (OnnxJavaType.INT16.equals(onnxJavaType)) {
            ShortBuffer buffer = ShortBuffer.allocate(size);
            long actualCount = this.writeNestedSeqToBuffer(batchedValues, (Function1 & Serializable & scala.Serializable)x$5 -> {
                buffer.put(BoxesRunTime.unboxToShort((Object)x$5));
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.Short());
            this.assertBufferElementsWritten(size, actualCount, shape);
            buffer.rewind();
            onnxTensor = OnnxTensor.createTensor((OrtEnvironment)env, (ShortBuffer)buffer, (long[])shape);
        } else if (OnnxJavaType.INT32.equals(onnxJavaType)) {
            IntBuffer buffer = IntBuffer.allocate(size);
            long actualCount = this.writeNestedSeqToBuffer(batchedValues, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> buffer.put(x$6), (ClassTag)ClassTag$.MODULE$.Int());
            this.assertBufferElementsWritten(size, actualCount, shape);
            buffer.rewind();
            onnxTensor = OnnxTensor.createTensor((OrtEnvironment)env, (IntBuffer)buffer, (long[])shape);
        } else if (OnnxJavaType.INT64.equals(onnxJavaType)) {
            LongBuffer buffer = LongBuffer.allocate(size);
            long actualCount = this.writeNestedSeqToBuffer(batchedValues, (Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$7 -> buffer.put(x$7), (ClassTag)ClassTag$.MODULE$.Long());
            this.assertBufferElementsWritten(size, actualCount, shape);
            buffer.rewind();
            onnxTensor = OnnxTensor.createTensor((OrtEnvironment)env, (LongBuffer)buffer, (long[])shape);
        } else if (OnnxJavaType.STRING.equals(onnxJavaType)) {
            String[] flattened = (String[])this.writeNestedSeqToStringBuffer(batchedValues, size).toArray(ClassTag$.MODULE$.apply(String.class));
            onnxTensor = OnnxTensor.createTensor((OrtEnvironment)env, (String[])flattened, (long[])shape);
        } else {
            throw new NotImplementedError(new StringBuilder(108).append("Tensor input type ").append(onnxJavaType).append(" not supported. ").append("Only FLOAT, DOUBLE, INT8, INT16, INT32, INT64, STRING types are supported.").toString());
        }
        return onnxTensor;
    }

    private void assertBufferElementsWritten(long expected, long actual, long[] shape) {
        if (expected != actual) {
            throw new IllegalArgumentException(new StringBuilder(58).append("Expected ").append(expected).append(" batch elements but found ").append(actual).append(".").append(" Expected shape is [").append(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(shape)).mkString()).append("].").toString());
        }
    }

    private <T> long writeNestedSeqToBuffer(Seq<?> nestedSeq, Function1<T, BoxedUnit> bufferWrite, ClassTag<T> evidence$1) {
        return BoxesRunTime.unboxToLong((Object)nestedSeq.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(cur, element) -> BoxesRunTime.boxToLong((long)ONNXUtils$.$anonfun$writeNestedSeqToBuffer$1(evidence$1, bufferWrite, BoxesRunTime.unboxToLong((Object)cur), element))));
    }

    private ArrayBuffer<String> writeNestedSeqToStringBuffer(Seq<?> nestedSeq, int size) {
        IntRef i = IntRef.create((int)0);
        ArrayBuffer buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.fill(size, (Function0 & Serializable & scala.Serializable)() -> "");
        ONNXUtils$.innerWrite$1(nestedSeq, buffer, i);
        return buffer;
    }

    public boolean compatible(DataType from, DataType to) {
        boolean bl;
        Tuple2 tuple2;
        while (true) {
            if ((tuple2 = new Tuple2((Object)from, (Object)to)) != null) {
                DataType dataType = (DataType)tuple2._1();
                DataType right = (DataType)tuple2._2();
                DataType dataType2 = SQLDataTypes$.MODULE$.VectorType();
                DataType dataType3 = dataType;
                if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null) && right instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)right;
                    to = arrayType.elementType();
                    from = DoubleType$.MODULE$;
                    continue;
                }
            }
            if (tuple2 == null) break;
            DataType left = (DataType)tuple2._1();
            DataType right = (DataType)tuple2._2();
            if (!(left instanceof ArrayType)) break;
            ArrayType arrayType = (ArrayType)left;
            if (!(right instanceof ArrayType)) break;
            ArrayType arrayType2 = (ArrayType)right;
            to = arrayType2.elementType();
            from = arrayType.elementType();
        }
        if (tuple2 != null && tuple2._1() instanceof NumericType && tuple2._2() instanceof NumericType) {
            bl = true;
        } else if (tuple2 != null) {
            DataType fromDataType = (DataType)tuple2._1();
            DataType toDataType = (DataType)tuple2._2();
            DataType dataType = fromDataType;
            DataType dataType4 = toDataType;
            bl = !(dataType != null ? !dataType.equals(dataType4) : dataType4 != null);
        } else {
            throw new MatchError((Object)tuple2);
        }
        return bl;
    }

    public ONNXModel sliceModelAtOutputs(ONNXModel fullModel, String[] outputs) {
        OnnxMl.ModelProto fullProtobufModel = OnnxMl.ModelProto.parseFrom((byte[])fullModel.getModelPayload());
        Tuple2<OnnxMl.NodeProto[], OnnxMl.ValueInfoProto[]> tuple2 = this.findUsedNodesForOutputs(fullProtobufModel, outputs);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        OnnxMl.NodeProto[] newNodes = (OnnxMl.NodeProto[])tuple2._1();
        OnnxMl.ValueInfoProto[] newOutputs = (OnnxMl.ValueInfoProto[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)newNodes, (Object)newOutputs);
        Tuple2 tuple23 = tuple22;
        OnnxMl.NodeProto[] newNodes2 = (OnnxMl.NodeProto[])tuple23._1();
        OnnxMl.ValueInfoProto[] newOutputs2 = (OnnxMl.ValueInfoProto[])tuple23._2();
        OnnxMl.GraphProto slicedGraph = this.makeGraph(newNodes2, newOutputs2, fullProtobufModel.getGraph());
        OnnxMl.ModelProto slicedProtobufModel = this.makeModel(slicedGraph, fullProtobufModel);
        return fullModel.copy(ParamMap$.MODULE$.empty()).setModelPayload(slicedProtobufModel.toByteArray());
    }

    private Tuple2<OnnxMl.NodeProto[], OnnxMl.ValueInfoProto[]> findUsedNodesForOutputs(OnnxMl.ModelProto model, String[] newOutputNames) {
        OnnxMl.GraphProto graph = model.getGraph();
        OnnxMl.NodeProto[] nodes = (OnnxMl.NodeProto[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(graph.getNodeList().toArray())).map((Function1 & Serializable & scala.Serializable)x$9 -> (OnnxMl.NodeProto)x$9, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OnnxMl.NodeProto.class)));
        String[] allInternalOutputs = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodes)).flatMap((Function1 & Serializable & scala.Serializable)node -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ONNXUtils$.MODULE$.AugmentedNodeProto(node).getNodeOutputNames())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newOutputNames)).foreach((Function1 & Serializable & scala.Serializable)out -> {
            ONNXUtils$.$anonfun$findUsedNodesForOutputs$3(allInternalOutputs, out);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map nodeUsageStatus = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodes)).foreach((Function1 & Serializable & scala.Serializable)node -> {
            nodeUsageStatus.update((Object)node.getName(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map outputNameToNodeMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodes)).flatMap((Function1 & Serializable & scala.Serializable)node -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ONNXUtils$.MODULE$.AugmentedNodeProto(node).getNodeOutputNames())).map((Function1 & Serializable & scala.Serializable)name -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(name), (Object)node), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        Set usedNodes = (Set)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newOutputNames)).map((Function1 & Serializable & scala.Serializable)out -> this.markAsUsedFrom$1((OnnxMl.NodeProto)outputNameToNodeMap.apply(out), outputNameToNodeMap), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Set.class))))).reduce((Function2 & Serializable & scala.Serializable)(x$10, x$11) -> x$10.$plus$plus((GenTraversableOnce)x$11));
        OnnxMl.NodeProto[] newNodes = (OnnxMl.NodeProto[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodes)).filter((Function1 & Serializable & scala.Serializable)node -> BoxesRunTime.boxToBoolean((boolean)usedNodes.apply((Object)node.getName())));
        OnnxMl.ValueInfoProto[] newOutputs = (OnnxMl.ValueInfoProto[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newOutputNames)).map((Function1 & Serializable & scala.Serializable)out -> OnnxMl.ValueInfoProto.newBuilder().setName(out).build(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OnnxMl.ValueInfoProto.class)));
        return new Tuple2((Object)newNodes, (Object)newOutputs);
    }

    private OnnxMl.GraphProto makeGraph(OnnxMl.NodeProto[] nodes, OnnxMl.ValueInfoProto[] outputs, OnnxMl.GraphProto source) {
        OnnxMl.GraphProto.Builder graph = OnnxMl.GraphProto.newBuilder((OnnxMl.GraphProto)source);
        graph.clearNode();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodes)).foreach((Function1 & Serializable & scala.Serializable)node -> graph.addNode(node));
        graph.clearOutput();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])outputs)).foreach((Function1 & Serializable & scala.Serializable)output -> graph.addOutput(output));
        return graph.build();
    }

    private OnnxMl.ModelProto makeModel(OnnxMl.GraphProto graph, OnnxMl.ModelProto source) {
        OnnxMl.ModelProto.Builder model = OnnxMl.ModelProto.newBuilder((OnnxMl.ModelProto)source);
        return model.setGraph(graph).build();
    }

    public ONNXUtils.AugmentedProtocolStringList com$microsoft$azure$synapse$ml$onnx$ONNXUtils$$AugmentedProtocolStringList(ProtocolStringList list) {
        return new ONNXUtils.AugmentedProtocolStringList(list);
    }

    private ONNXUtils.AugmentedNodeProto AugmentedNodeProto(OnnxMl.NodeProto node) {
        return new ONNXUtils.AugmentedNodeProto(node);
    }

    private static final ArrayType nestedArrayType$1(int depth, DataType dataType) {
        return depth == 1 ? ArrayType$.MODULE$.apply(dataType) : ArrayType$.MODULE$.apply((DataType)ONNXUtils$.nestedArrayType$1(depth - 1, dataType));
    }

    private final void validateOneShape$1(Seq nestedSeq, long[] currentSize, long[] expectedShape) {
        long[] newSize;
        while (true) {
            if (nestedSeq.isEmpty()) {
                throw new IllegalArgumentException("Input element dimension is empty");
            }
            newSize = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(currentSize)).$colon$plus((Object)BoxesRunTime.boxToLong((long)nestedSeq.length()), ClassTag$.MODULE$.Long());
            Object object = nestedSeq.head();
            if (!(object instanceof Seq)) break;
            Object object2 = object;
            currentSize = newSize;
            nestedSeq = (Seq)object2;
        }
        if (!Arrays.equals(newSize, expectedShape)) {
            throw new IllegalArgumentException(new StringBuilder(66).append("Input element does not match input tensor shape [").append(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(expectedShape)).mkString()).append("].").append(" Found shape [").append(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(newSize)).mkString()).append("]").toString());
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$validateBatchShapes$1(ONNXUtils$ $this, long[] expectedShape$1, Object x0$1) {
        Object object = x0$1;
        if (!(object instanceof Seq)) {
            throw new IllegalArgumentException("Image batch is not a sequence");
        }
        Object object2 = object;
        $this.validateOneShape$1((Seq)object2, (long[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Long()), (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(expectedShape$1)).tail());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ long $anonfun$writeNestedSeqToBuffer$1(ClassTag evidence$1$1, Function1 bufferWrite$1, long cur, Object element) {
        long l;
        Object object = element;
        Option option = evidence$1$1.unapply(object);
        if (!option.isEmpty() && option.get() instanceof Object) {
            bufferWrite$1.apply(object);
            l = cur + 1L;
        } else if (object instanceof Seq) {
            Seq seq = (Seq)object;
            l = cur + MODULE$.writeNestedSeqToBuffer(seq, bufferWrite$1, evidence$1$1);
        } else {
            l = cur + 0L;
        }
        return l;
    }

    public static final /* synthetic */ void $anonfun$writeNestedSeqToStringBuffer$2(ArrayBuffer buffer$7, IntRef i$1, Object x0$1) {
        Object object = x0$1;
        if (object instanceof String) {
            String string = (String)object;
            buffer$7.update(i$1.elem, (Object)string);
            ++i$1.elem;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof Seq) {
            Object object2 = object;
            ONNXUtils$.innerWrite$1((Seq)object2, buffer$7, i$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(object);
        }
    }

    private static final void innerWrite$1(Seq nestedSeq, ArrayBuffer buffer$7, IntRef i$1) {
        nestedSeq.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ONNXUtils$.$anonfun$writeNestedSeqToStringBuffer$2(buffer$7, i$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$findUsedNodesForOutputs$3(String[] allInternalOutputs$1, String out) {
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allInternalOutputs$1)).contains((Object)out)) {
            throw new IllegalArgumentException(new StringBuilder(16).append("Unknown output: ").append(out).toString());
        }
    }

    private final void markAsUsed$1(Seq nodes, HashSet visitedNodes, scala.collection.immutable.Map outputNameToNodeMap$1) {
        while (nodes.nonEmpty()) {
            Seq nodesToCheck;
            Seq seq;
            OnnxMl.NodeProto head = (OnnxMl.NodeProto)nodes.head();
            if (!visitedNodes.apply((Object)head.getName())) {
                visitedNodes.add((Object)head.getName());
                Seq upstreamNodes = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.AugmentedNodeProto(head).getNodeInputNames())).flatMap((Function1 & Serializable & scala.Serializable)key -> Option$.MODULE$.option2Iterable(outputNameToNodeMap$1.get(key)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(OnnxMl.NodeProto.class))))).toSeq();
                seq = (Seq)((SeqLike)((TraversableLike)nodes.tail()).$plus$plus((GenTraversableOnce)upstreamNodes, Seq$.MODULE$.canBuildFrom())).distinct();
            } else {
                seq = (Seq)nodes.tail();
            }
            nodes = nodesToCheck = seq;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set markAsUsedFrom$1(OnnxMl.NodeProto node, scala.collection.immutable.Map outputNameToNodeMap$1) {
        void var3_3;
        HashSet visited = new HashSet();
        this.markAsUsed$1((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$), visited, outputNameToNodeMap$1);
        return var3_3;
    }

    private ONNXUtils$() {
        MODULE$ = this;
    }
}

