/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.lightgbm.dataset;

import com.microsoft.azure.synapse.ml.lightgbm.swig.BaseSwigArray;
import com.microsoft.azure.synapse.ml.lightgbm.swig.ChunkedArray;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;

public final class ChunkedArrayUtils$ {
    public static ChunkedArrayUtils$ MODULE$;

    static {
        new ChunkedArrayUtils$();
    }

    public <T> void copyChunkedArray(ChunkedArray<T> chunkedArray, BaseSwigArray<T> mainArray, long threadRowStartIndex, Numeric<T> evidence$1) {
        Numeric num = (Numeric)Predef$.MODULE$.implicitly(evidence$1);
        Object defaultVal = num.fromInt(-1);
        long chunkSize = chunkedArray.getChunkSize();
        long chunkCount = chunkedArray.getChunksCount() - 1L;
        new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)chunkCount)).foreach((Function1)(JFunction1.mcVJ.sp & java.io.Serializable & Serializable)chunk -> new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)chunkSize)).foreach((Function1)(JFunction1.mcVJ.sp & java.io.Serializable & Serializable)inChunkIdx -> mainArray.setItem(threadRowStartIndex + chunk * chunkSize + inChunkIdx, chunkedArray.getItem(chunk, inChunkIdx, defaultVal))));
        long lastChunkCount = chunkedArray.getLastChunkAddCount();
        new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)lastChunkCount)).foreach((Function1)(JFunction1.mcVJ.sp & java.io.Serializable & Serializable)lastChunkIdx -> mainArray.setItem(threadRowStartIndex + chunkCount * chunkSize + lastChunkIdx, chunkedArray.getItem(chunkCount, lastChunkIdx, defaultVal)));
    }

    public <T> void insertTransposedChunkedArray(ChunkedArray<T> chunkedArray, int numCols, BaseSwigArray<T> mainArray, long numTargetRows, long startIndex, Numeric<T> evidence$2) {
        long intermediateSourceIndex;
        Numeric num = (Numeric)Predef$.MODULE$.implicitly(evidence$2);
        Object defaultVal = num.fromInt(-1);
        long fullChunkSize = chunkedArray.getChunkSize();
        int allChunkCount = (int)chunkedArray.getChunksCount();
        int fullChunkCount = allChunkCount - 1;
        long lastChunkSize = chunkedArray.getLastChunkAddCount();
        long finalSourceIndex = this.copyChunkSet$1(allChunkCount, lastChunkSize, fullChunkCount, intermediateSourceIndex = allChunkCount == 1 ? 0L : this.copyChunkSet$1(fullChunkCount, fullChunkSize, 0, 0L, numCols, startIndex, numTargetRows, chunkedArray, defaultVal, mainArray), numCols, startIndex, numTargetRows, chunkedArray, defaultVal, mainArray);
        if (finalSourceIndex % (long)numCols != 0L) {
            throw new Exception(new StringBuilder(57).append("transpose did not have whole number of columns. numCols: ").append(numCols).toString());
        }
    }

    private final long copyChunk$1(int chunk, long chunkSize, long inChunkIdx, long sourceIndex, int numCols$1, long startIndex$1, long numTargetRows$1, ChunkedArray chunkedArray$2, Object defaultVal$2, BaseSwigArray mainArray$2) {
        long newSourceIndex;
        while (true) {
            long sourceRow = sourceIndex / (long)numCols$1;
            long col = sourceIndex % (long)numCols$1;
            long targetIndex = startIndex$1 + sourceRow + col * numTargetRows$1;
            Object value = chunkedArray$2.getItem(chunk, inChunkIdx, defaultVal$2);
            mainArray$2.setItem(targetIndex, value);
            newSourceIndex = sourceIndex + 1L;
            long newInChunkIndex = inChunkIdx + 1L;
            if (newInChunkIndex >= chunkSize) break;
            sourceIndex = newSourceIndex;
            inChunkIdx = newInChunkIndex;
        }
        return newSourceIndex;
    }

    private final long copyChunkSet$1(int maxChunk, long chunkSize, int chunk, long sourceIndex, int numCols$1, long startIndex$1, long numTargetRows$1, ChunkedArray chunkedArray$2, Object defaultVal$2, BaseSwigArray mainArray$2) {
        long currentSourceIndex;
        while (true) {
            currentSourceIndex = this.copyChunk$1(chunk, chunkSize, 0L, sourceIndex, numCols$1, startIndex$1, numTargetRows$1, chunkedArray$2, defaultVal$2, mainArray$2);
            int newChunk = chunk + 1;
            if (newChunk >= maxChunk) break;
            sourceIndex = currentSourceIndex;
            chunk = newChunk;
        }
        return currentSourceIndex;
    }

    private ChunkedArrayUtils$() {
        MODULE$ = this;
    }
}

