/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.lightgbm;

import com.microsoft.azure.synapse.ml.lightgbm.LightGBMUtils$;
import com.microsoft.azure.synapse.ml.lightgbm.NetworkManager$;
import com.microsoft.azure.synapse.ml.lightgbm.NetworkTopologyInfo;
import com.microsoft.azure.synapse.ml.lightgbm.PartitionDataState;
import com.microsoft.azure.synapse.ml.lightgbm.PartitionResult;
import com.microsoft.azure.synapse.ml.lightgbm.PartitionTaskContext;
import com.microsoft.azure.synapse.ml.lightgbm.PartitionTaskTrainingState;
import com.microsoft.azure.synapse.ml.lightgbm.TaskInstrumentationMeasures;
import com.microsoft.azure.synapse.ml.lightgbm.TrainUtils$;
import com.microsoft.azure.synapse.ml.lightgbm.TrainingContext;
import com.microsoft.azure.synapse.ml.lightgbm.booster.LightGBMBooster;
import com.microsoft.azure.synapse.ml.lightgbm.dataset.DatasetUtils$;
import com.microsoft.azure.synapse.ml.lightgbm.dataset.LightGBMDataset;
import com.microsoft.azure.synapse.ml.lightgbm.dataset.PeekingIterator;
import com.microsoft.ml.lightgbm.lightgbmlib;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]e!B\t\u0013\u0003\u0003y\u0002\"B\u001b\u0001\t\u00031\u0004\"B\u001d\u0001\t\u0003Q\u0004\"B-\u0001\t\u0013Q\u0006\"\u00021\u0001\t\u0013\t\u0007\"B4\u0001\t\u0013A\u0007\"\u00027\u0001\t\u0013i\u0007\"\u0002:\u0001\t#\u0019\b\"\u0002?\u0001\t#i\bbBA\u0019\u0001\u0019E\u00111\u0007\u0005\b\u0003s\u0001a\u0011CA\u001e\u0011\u001d\ti\u0005\u0001D\t\u0003\u001fBq!!\u0017\u0001\t#\tY\u0006C\u0004\u0002`\u0001!I!!\u0019\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011\u0011\u000f\u0001\u0005\u0012\u0005M\u0004bBA@\u0001\u0011%\u0011\u0011\u0011\u0002\u0012\u0005\u0006\u001cX\rU1si&$\u0018n\u001c8UCN\\'BA\n\u0015\u0003!a\u0017n\u001a5uO\nl'BA\u000b\u0017\u0003\tiGN\u0003\u0002\u00181\u000591/\u001f8baN,'BA\r\u001b\u0003\u0015\t'0\u001e:f\u0015\tYB$A\u0005nS\u000e\u0014xn]8gi*\tQ$A\u0002d_6\u001c\u0001a\u0005\u0003\u0001A\u0019J\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002\"O%\u0011\u0001F\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003UMj\u0011a\u000b\u0006\u0003Y5\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003]=\nQa\u001d9be.T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO&\u0011Ag\u000b\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tq\u0007\u0005\u00029\u00015\t!#\u0001\tnCB\u0004\u0016M\u001d;ji&|g\u000eV1tWR\u00111\b\u0016\u000b\u0003y-\u00032!P#I\u001d\tq4I\u0004\u0002@\u00056\t\u0001I\u0003\u0002B=\u00051AH]8pizJ\u0011aI\u0005\u0003\t\n\nq\u0001]1dW\u0006<W-\u0003\u0002G\u000f\nA\u0011\n^3sCR|'O\u0003\u0002EEA\u0011\u0001(S\u0005\u0003\u0015J\u0011q\u0002U1si&$\u0018n\u001c8SKN,H\u000e\u001e\u0005\u0006\u0019\n\u0001\r!T\u0001\nS:\u0004X\u000f\u001e*poN\u00042!P#O!\ty%+D\u0001Q\u0015\t\tV&A\u0002tc2L!a\u0015)\u0003\u0007I{w\u000fC\u0003V\u0005\u0001\u0007a+A\u0002dib\u0004\"\u0001O,\n\u0005a\u0013\"a\u0004+sC&t\u0017N\\4D_:$X\r\u001f;\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0002\\=~\u0003\"\u0001\u000f/\n\u0005u\u0013\"\u0001\u0006)beRLG/[8o)\u0006\u001c8nQ8oi\u0016DH\u000fC\u0003V\u0007\u0001\u0007a\u000bC\u0003M\u0007\u0001\u0007Q*\u0001\u000bqe\u0016\u0004\u0018M]3QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\u0004E\u00164\u0007C\u0001\u001dd\u0013\t!'C\u0001\nQCJ$\u0018\u000e^5p]\u0012\u000bG/Y*uCR,\u0007\"B+\u0005\u0001\u0004Y\u0006\"\u0002'\u0005\u0001\u0004i\u0015a\u00064j]\u0006d\u0017N_3ECR\f7/\u001a;B]\u0012$&/Y5o)\ra\u0014N\u001b\u0005\u0006+\u0016\u0001\ra\u0017\u0005\u0006W\u0016\u0001\rAY\u0001\nI\u0006$\u0018m\u0015;bi\u0016\fqa\u00197fC:,\b\u000f\u0006\u0002ocB\u0011\u0011e\\\u0005\u0003a\n\u0012A!\u00168ji\")QK\u0002a\u00017\u0006\u0011\u0012N\\5uS\u0006d\u0017N_3J]R,'O\\1m)\u0011qG/\u001e>\t\u000bU;\u0001\u0019\u0001,\t\u000bY<\u0001\u0019A<\u0002+MDw.\u001e7e\u000bb,7-\u001e;f)J\f\u0017N\\5oOB\u0011\u0011\u0005_\u0005\u0003s\n\u0012qAQ8pY\u0016\fg\u000eC\u0003|\u000f\u0001\u0007q/\u0001\tjg\u0016k\u0007\u000f^=QCJ$\u0018\u000e^5p]\u0006qq-\u001a;UCN\\7i\u001c8uKb$H\u0003E.\u007f\u0003\u0003\tY!!\u0006\u0002 \u0005%\u00121FA\u0017\u0011\u0015y\b\u00021\u0001W\u0003-!(/Y5oS:<7\t\u001e=\t\u000f\u0005\r\u0001\u00021\u0001\u0002\u0006\u0005Y\u0001/\u0019:uSRLwN\\%e!\r\t\u0013qA\u0005\u0004\u0003\u0013\u0011#aA%oi\"9\u0011Q\u0002\u0005A\u0002\u0005=\u0011A\u0002;bg.LE\rE\u0002\"\u0003#I1!a\u0005#\u0005\u0011auN\\4\t\u000f\u0005]\u0001\u00021\u0001\u0002\u001a\u0005AQ.Z1tkJ,7\u000fE\u00029\u00037I1!!\b\u0013\u0005m!\u0016m]6J]N$(/^7f]R\fG/[8o\u001b\u0016\f7/\u001e:fg\"9\u0011\u0011\u0005\u0005A\u0002\u0005\r\u0012a\u00058fi^|'o\u001b+pa>dwnZ=J]\u001a|\u0007c\u0001\u001d\u0002&%\u0019\u0011q\u0005\n\u0003'9+Go^8sWR{\u0007o\u001c7pOfLeNZ8\t\u000bYD\u0001\u0019A<\t\u000bmD\u0001\u0019A<\t\r\u0005=\u0002\u00021\u0001x\u0003M\u0019\bn\\;mIJ+G/\u001e:o\u0005>|7\u000f^3s\u0003q\u0001(/\u001a9be\u0016\u0004\u0016M\u001d;ji&|g\u000eR1uC&sG/\u001a:oC2$RAYA\u001b\u0003oAQ!V\u0005A\u0002mCQ\u0001T\u0005A\u00025\u000b!dZ3u)J\f\u0017N\\5oO\u0012\u000bG/Y:fi&sG/\u001a:oC2$b!!\u0010\u0002J\u0005-\u0003\u0003BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\r##A\u0004eCR\f7/\u001a;\n\t\u0005\u001d\u0013\u0011\t\u0002\u0010\u0019&<\u0007\u000e^$C\u001b\u0012\u000bG/Y:fi\")QK\u0003a\u00017\")1N\u0003a\u0001E\u0006ar-\u001a;WC2LG-\u0019;j_:$\u0015\r^1tKRLe\u000e^3s]\u0006dG\u0003CA\u001f\u0003#\n\u0019&!\u0016\t\u000bU[\u0001\u0019A.\t\u000b-\\\u0001\u0019\u00012\t\u000f\u0005]3\u00021\u0001\u0002>\u0005\u0001\"/\u001a4fe\u0016t7-\u001a#bi\u0006\u001cX\r^\u0001\u0010G2,\u0017M\\;q\u0013:$XM\u001d8bYR\u0019a.!\u0018\t\u000bUc\u0001\u0019A.\u0002/\u001d,GOR5oC2$&/Y5oS:<G)\u0019;bg\u0016$HCBA\u001f\u0003G\n)\u0007C\u0003V\u001b\u0001\u00071\fC\u0003l\u001b\u0001\u0007!-A\rhKR4\u0015N\\1m-\u0006d\u0017\u000eZ1uS>tG)\u0019;bg\u0016$H\u0003CA\u001f\u0003W\ni'a\u001c\t\u000bUs\u0001\u0019A.\t\u000b-t\u0001\u0019\u00012\t\u000f\u0005]c\u00021\u0001\u0002>\u0005\u0019B-\u001a;fe6Lg.Z'biJL\u0007\u0010V=qKR1\u0011QOA>\u0003{\u0002R!a\u0010\u0002x9KA!!\u001f\u0002B\ty\u0001+Z3lS:<\u0017\n^3sCR|'\u000fC\u0003V\u001f\u0001\u00071\fC\u0003M\u001f\u0001\u0007Q*\u0001\fhKR\u0004\u0016M\u001d;ji&|g\u000eV1tWJ+7/\u001e7u)\u0015a\u00141QAG\u0011\u001d\t)\t\u0005a\u0001\u0003\u000f\u000bQa\u001d;bi\u0016\u00042\u0001OAE\u0013\r\tYI\u0005\u0002\u001b!\u0006\u0014H/\u001b;j_:$\u0016m]6Ue\u0006Lg.\u001b8h'R\fG/\u001a\u0005\b\u0003\u001f\u0003\u0002\u0019AAI\u0003M\u0011Wm\u001d;Ji\u0016\u0014\u0018\r^5p]J+7/\u001e7u!\u0015\t\u00131SA\u0003\u0013\r\t)J\t\u0002\u0007\u001fB$\u0018n\u001c8")
public abstract class BasePartitionTask
implements scala.Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Iterator<PartitionResult> mapPartitionTask(TrainingContext ctx, Iterator<Row> inputRows) {
        Iterator iterator;
        PartitionTaskContext taskCtx = this.initialize(ctx, inputRows);
        if (taskCtx.isEmptyPartition()) {
            this.log().warn("LightGBM task encountered empty partition, for best performance ensure no partitions are empty");
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new PartitionResult[]{new PartitionResult((Option<LightGBMBooster>)None$.MODULE$, taskCtx.measures())})).toIterator();
        }
        PartitionDataState dataIntermediateState = this.preparePartitionData(taskCtx, inputRows);
        try {
            if (taskCtx.shouldExecuteTraining()) {
                NetworkManager$.MODULE$.initLightGBMNetwork(taskCtx, this.log(), NetworkManager$.MODULE$.initLightGBMNetwork$default$3(), NetworkManager$.MODULE$.initLightGBMNetwork$default$4());
                if (ctx.useSingleDatasetMode()) {
                    this.log().info(new StringBuilder(55).append("Waiting for all data prep to be done, task ").append(taskCtx.taskId()).append(", partition ").append(taskCtx.partitionId()).toString());
                    ctx.sharedState().dataPreparationDoneSignal().await();
                }
                iterator = this.finalizeDatasetAndTrain(taskCtx, dataIntermediateState);
            } else {
                this.log().info(new StringBuilder(49).append("Helper task ").append(taskCtx.taskId()).append(", partition ").append(taskCtx.partitionId()).append(" finished processing rows").toString());
                ctx.sharedState().dataPreparationDoneSignal().countDown();
                iterator = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new PartitionResult[]{new PartitionResult((Option<LightGBMBooster>)None$.MODULE$, taskCtx.measures())})).toIterator();
            }
        }
        finally {
            this.cleanup(taskCtx);
        }
        return iterator;
    }

    private PartitionTaskContext initialize(TrainingContext ctx, Iterator<Row> inputRows) {
        boolean isEmptyPartition;
        int partitionId = LightGBMUtils$.MODULE$.getPartitionId();
        TaskInstrumentationMeasures taskMeasures = new TaskInstrumentationMeasures(partitionId);
        taskMeasures.markInitializationStart();
        long taskId = LightGBMUtils$.MODULE$.getTaskId();
        if (ctx.trainingParams().generalParams().verbosity() > 1) {
            this.log().info(new StringBuilder(56).append("Initializing partition ").append(partitionId).append(" and taskId ").append(taskId).append(" running on executor ").append(LightGBMUtils$.MODULE$.getExecutorId()).toString());
        }
        boolean bl = isEmptyPartition = !inputRows.hasNext();
        if (!isEmptyPartition) {
            ctx.sharedState().linkMainExecutorWorker();
        }
        Object mainExecutorWorkerId = ctx.sharedState().mainExecutorWorker().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1);
        boolean shouldExecuteTraining = isEmptyPartition ? false : (!ctx.useSingleDatasetMode() ? true : BoxesRunTime.equals((Object)mainExecutorWorkerId, (Object)BoxesRunTime.boxToLong((long)taskId)));
        taskMeasures.markLibraryInitializationStart();
        LightGBMUtils$.MODULE$.initializeNativeLibrary();
        taskMeasures.markLibraryInitializationStop();
        this.initializeInternal(ctx, shouldExecuteTraining, isEmptyPartition);
        NetworkTopologyInfo networkInfo = NetworkManager$.MODULE$.getGlobalNetworkInfo(ctx, this.log(), taskId, partitionId, shouldExecuteTraining, taskMeasures);
        boolean shouldReturnBooster = isEmptyPartition ? false : (!shouldExecuteTraining ? false : networkInfo.localListenPort() == NetworkManager$.MODULE$.getMainWorkerPort(networkInfo.lightgbmNetworkString(), this.log()));
        PartitionTaskContext taskCtx = this.getTaskContext(ctx, partitionId, taskId, taskMeasures, networkInfo, shouldExecuteTraining, isEmptyPartition, shouldReturnBooster);
        if (ctx.trainingParams().generalParams().verbosity() > 1) {
            this.log().info(new StringBuilder(51).append("Done initializing partition: ").append(partitionId).append(", taskId: ").append(taskId).append(", executor: ").append(LightGBMUtils$.MODULE$.getExecutorId()).toString());
        }
        taskMeasures.markInitializationStop();
        return taskCtx;
    }

    private PartitionDataState preparePartitionData(PartitionTaskContext ctx, Iterator<Row> inputRows) {
        this.log().info(new StringBuilder(46).append("starting data preparation on partition ").append(ctx.partitionId()).append(", task ").append(ctx.taskId()).toString());
        ctx.measures().markDataPreparationStart();
        PartitionDataState state = this.preparePartitionDataInternal(ctx, inputRows);
        ctx.measures().markDataPreparationStop();
        this.log().info(new StringBuilder(47).append("done with data preparation on partition ").append(ctx.partitionId()).append(", task ").append(ctx.taskId()).toString());
        return state;
    }

    private Iterator<PartitionResult> finalizeDatasetAndTrain(PartitionTaskContext ctx, PartitionDataState dataState) {
        Iterator<PartitionResult> iterator;
        ctx.measures().isActiveTrainingTask_$eq(true);
        LightGBMDataset trainDataset = this.getFinalTrainingDataset(ctx, dataState);
        try {
            None$ validDatasetOpt = !ctx.trainingCtx().hasValidationData() ? None$.MODULE$ : Option$.MODULE$.apply((Object)this.getFinalValidationDataset(ctx, dataState, trainDataset));
            try {
                this.log().info(new StringBuilder(47).append("Creating LightGBM Booster for partition ").append(ctx.partitionId()).append(", task ").append(ctx.taskId()).toString());
                LightGBMBooster booster = TrainUtils$.MODULE$.createBooster(ctx.trainingCtx().trainingParams(), trainDataset, (Option<LightGBMDataset>)validDatasetOpt);
                PartitionTaskTrainingState state = new PartitionTaskTrainingState(ctx, booster);
                try {
                    Option<Object> bestIterResult = TrainUtils$.MODULE$.executeTrainingIterations(state, this.log());
                    this.log().info(new StringBuilder(70).append("*** Completed training in partition ").append(ctx.partitionId()).append(", task ").append(ctx.taskId()).append(", ").append("iteration count: ").append(state.iteration()).append(", best: ").append(bestIterResult).toString());
                    iterator = this.getPartitionTaskResult(state, bestIterResult);
                }
                finally {
                    state.booster().freeNativeMemory();
                }
            }
            finally {
                validDatasetOpt.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.close();
                    return BoxedUnit.UNIT;
                });
            }
        }
        finally {
            this.log().info(new StringBuilder(38).append("Freeing Dataset from partition ").append(ctx.partitionId()).append(", task ").append(ctx.taskId()).toString());
            trainDataset.close();
        }
        return iterator;
    }

    private void cleanup(PartitionTaskContext ctx) {
        this.log().info(new StringBuilder(39).append("Beginning cleanup for partition ").append(ctx.partitionId()).append(", task ").append(ctx.taskId()).toString());
        if (ctx.shouldExecuteTraining()) {
            LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_NetworkFree(), "Finalize network");
        }
        this.cleanupInternal(ctx);
        ctx.measures().markTaskEnd();
        this.log().info(new StringBuilder(39).append("Done with cleanup for partition ").append(ctx.partitionId()).append(", task ").append(ctx.taskId()).toString());
    }

    public void initializeInternal(TrainingContext ctx, boolean shouldExecuteTraining, boolean isEmptyPartition) {
    }

    public PartitionTaskContext getTaskContext(TrainingContext trainingCtx, int partitionId, long taskId, TaskInstrumentationMeasures measures, NetworkTopologyInfo networkTopologyInfo, boolean shouldExecuteTraining, boolean isEmptyPartition, boolean shouldReturnBooster) {
        boolean shouldCalcValidationDataset;
        Object mainExecutorWorkerId = trainingCtx.sharedState().mainExecutorWorker().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1);
        if (trainingCtx.useSingleDatasetMode()) {
            this.log().info(new StringBuilder(98).append("Using singleDatasetMode. Task: ").append(taskId).append(", PartId: ").append(partitionId).append(". Main task: ").append(mainExecutorWorkerId).append(" shouldExecuteTraining: ").append(shouldExecuteTraining).append(", isEmptyPartition: ").append(isEmptyPartition).toString());
        }
        boolean bl = shouldCalcValidationDataset = BoxesRunTime.equals((Object)trainingCtx.sharedState().validationDatasetWorker().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1), (Object)BoxesRunTime.boxToLong((long)taskId));
        if (trainingCtx.hasValidationData()) {
            this.log().info(new StringBuilder(102).append("Validation data found. Task: ").append(taskId).append(", PartId: ").append(partitionId).append(". Main task: ").append(mainExecutorWorkerId).append(" shouldCalcValidationDataset: ").append(shouldCalcValidationDataset).append(", isEmptyPartition: ").append(isEmptyPartition).toString());
        }
        return new PartitionTaskContext(trainingCtx, partitionId, taskId, measures, networkTopologyInfo, shouldExecuteTraining, isEmptyPartition, shouldReturnBooster, shouldCalcValidationDataset);
    }

    public abstract PartitionDataState preparePartitionDataInternal(PartitionTaskContext var1, Iterator<Row> var2);

    public abstract LightGBMDataset getTrainingDatasetInternal(PartitionTaskContext var1, PartitionDataState var2);

    public abstract LightGBMDataset getValidationDatasetInternal(PartitionTaskContext var1, PartitionDataState var2, LightGBMDataset var3);

    public void cleanupInternal(PartitionTaskContext ctx) {
    }

    private LightGBMDataset getFinalTrainingDataset(PartitionTaskContext ctx, PartitionDataState dataState) {
        this.log().info(new StringBuilder(46).append("Getting final training Dataset for partition ").append(ctx.partitionId()).append(".").toString());
        TrainUtils$.MODULE$.beforeGenerateTrainDataset(ctx, this.log());
        ctx.measures().markDatasetCreationStart();
        LightGBMDataset dataset = this.getTrainingDatasetInternal(ctx, dataState);
        dataset.validateDataset();
        ctx.measures().markDatasetCreationStop();
        TrainUtils$.MODULE$.afterGenerateTrainDataset(ctx, this.log());
        return dataset;
    }

    private LightGBMDataset getFinalValidationDataset(PartitionTaskContext ctx, PartitionDataState dataState, LightGBMDataset referenceDataset) {
        this.log().info(new StringBuilder(48).append("Getting final validation Dataset for partition ").append(ctx.partitionId()).append(".").toString());
        TrainUtils$.MODULE$.beforeGenerateValidDataset(ctx, this.log());
        ctx.measures().markValidationDatasetStart();
        LightGBMDataset dataset = this.getValidationDatasetInternal(ctx, dataState, referenceDataset);
        dataset.validateDataset();
        TrainUtils$.MODULE$.afterGenerateValidDataset(ctx, this.log());
        ctx.measures().markValidationDatasetStop();
        return dataset;
    }

    public PeekingIterator<Row> determineMatrixType(PartitionTaskContext ctx, Iterator<Row> inputRows) {
        boolean isSparseHere;
        Iterator concatRowsIterator;
        String matrixType;
        block5: {
            Tuple2<Iterator<Row>, Object> tuple2;
            block4: {
                if (ctx.sharedState().isSparse().isDefined()) {
                    return new PeekingIterator<Row>(inputRows);
                }
                matrixType = ctx.trainingCtx().trainingParams().executionParams().matrixType();
                tuple2 = DatasetUtils$.MODULE$.getArrayType(inputRows, matrixType, ctx.trainingCtx().columnParams().featuresColumn());
                if (tuple2 == null) break block4;
                concatRowsIterator = (Iterator)tuple2._1();
                isSparseHere = tuple2._2$mcZ$sp();
                if (concatRowsIterator != null) break block5;
            }
            throw new MatchError(tuple2);
        }
        Iterator iterator = concatRowsIterator;
        boolean bl = isSparseHere;
        Tuple2 tuple2 = new Tuple2((Object)iterator, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
        Iterator concatRowsIterator2 = (Iterator)tuple2._1();
        boolean isSparseHere2 = tuple2._2$mcZ$sp();
        this.log().info(new StringBuilder(45).append("Setting isSparse to ").append(isSparseHere2).append(" based on matrix type of ").append(matrixType).toString());
        PeekingIterator<Row> peekingIterator = new PeekingIterator<Row>(concatRowsIterator2);
        ctx.sharedState().linkIsSparse(isSparseHere2);
        return peekingIterator;
    }

    private Iterator<PartitionResult> getPartitionTaskResult(PartitionTaskTrainingState state, Option<Object> bestIterationResult) {
        if (state.ctx().shouldReturnBooster()) {
            String model = state.booster().saveToString(bestIterationResult);
            LightGBMBooster modelBooster = new LightGBMBooster(model);
            bestIterationResult.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bestIteration -> modelBooster.setBestIteration(bestIteration));
            return package$.MODULE$.Iterator().single((Object)new PartitionResult((Option<LightGBMBooster>)Option$.MODULE$.apply((Object)modelBooster), state.ctx().measures()));
        }
        return package$.MODULE$.Iterator().single((Object)new PartitionResult((Option<LightGBMBooster>)None$.MODULE$, state.ctx().measures()));
    }

    public BasePartitionTask() {
        Logging.$init$((Logging)this);
    }
}

