/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.lightgbm.dataset;

import com.microsoft.azure.synapse.ml.lightgbm.ColumnParams;
import com.microsoft.azure.synapse.ml.lightgbm.dataset.DatasetUtils;
import java.io.Serializable;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DatasetUtils$ {
    public static DatasetUtils$ MODULE$;

    static {
        new DatasetUtils$();
    }

    public <T> int[] countCardinality(Seq<T> input) {
        Object t = null;
        DatasetUtils.CardinalityTriplet cardinalityTriplet = (DatasetUtils.CardinalityTriplet)input.foldLeft(new DatasetUtils.CardinalityTriplet<Object>((List<Object>)List$.MODULE$.empty(), t, 0), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                DatasetUtils.CardinalityTriplet listValue = (DatasetUtils.CardinalityTriplet)tuple2._1();
                Object currentValue = tuple2._2();
                if (listValue != null) {
                    DatasetUtils.CardinalityTriplet cardinalityTriplet = listValue;
                    if (cardinalityTriplet.groupCounts().isEmpty() && cardinalityTriplet.currentCount() == 0) {
                        return new DatasetUtils.CardinalityTriplet<Object>(cardinalityTriplet.groupCounts(), currentValue, 1);
                    }
                    if (BoxesRunTime.equals(cardinalityTriplet.currentValue(), (Object)currentValue)) {
                        return new DatasetUtils.CardinalityTriplet<Object>(cardinalityTriplet.groupCounts(), currentValue, cardinalityTriplet.currentCount() + 1);
                    }
                    int n = cardinalityTriplet.currentCount();
                    return new DatasetUtils.CardinalityTriplet<Object>((List<Object>)cardinalityTriplet.groupCounts().$colon$colon((Object)BoxesRunTime.boxToInteger((int)n)), currentValue, 1);
                }
            }
            throw new MatchError((Object)tuple2);
        });
        int n = cardinalityTriplet.currentCount();
        int[] groupCardinality = (int[])cardinalityTriplet.groupCounts().$colon$colon((Object)BoxesRunTime.boxToInteger((int)n)).reverse().toArray(ClassTag$.MODULE$.Int());
        return groupCardinality;
    }

    public Tuple2<Iterator<Row>, Object> getArrayType(Iterator<Row> rowsIter, String matrixType, String featuresColumn) {
        String string = matrixType;
        String string2 = "auto";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.sampleRowsForArrayType(rowsIter, featuresColumn);
        }
        String string3 = matrixType;
        String string4 = "sparse";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            return new Tuple2(rowsIter, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        String string5 = matrixType;
        String string6 = "dense";
        if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
            return new Tuple2(rowsIter, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        throw new Exception(new StringBuilder(41).append("Invalid parameter matrix type specified: ").append(matrixType).toString());
    }

    public Tuple2<Iterator<Row>, Object> sampleRowsForArrayType(Iterator<Row> rowsIter, String featuresColumn) {
        int numSampledRows = 10;
        Row[] sampleRows = (Row[])rowsIter.take(numSampledRows).toArray(ClassTag$.MODULE$.apply(Row.class));
        int numDense = new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps((boolean[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampleRows)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)DatasetUtils$.$anonfun$sampleRowsForArrayType$1(featuresColumn, row)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean())))).count((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)value)));
        int numSparse = sampleRows.length - numDense;
        return new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampleRows)).toIterator().$plus$plus((Function0 & Serializable & scala.Serializable)() -> rowsIter), (Object)BoxesRunTime.boxToBoolean((numSparse > numDense ? 1 : 0) != 0));
    }

    public double[] getRowAsDoubleArray(Row row, ColumnParams columnParams) {
        Object object = row.getAs(columnParams.featuresColumn());
        if (object instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)object;
            return denseVector.toArray();
        }
        if (object instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)object;
            return sparseVector.toArray();
        }
        throw new MatchError(object);
    }

    public void validateGroupColumn(String col, StructType schema) {
        DataType datatype;
        DataType dataType = datatype = schema.apply(col).dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
            DataType dataType2 = datatype;
            LongType$ longType$ = LongType$.MODULE$;
            if (dataType2 == null ? longType$ != null : !dataType2.equals(longType$)) {
                DataType dataType3 = datatype;
                StringType$ stringType$ = StringType$.MODULE$;
                if (dataType3 == null ? stringType$ != null : !dataType3.equals(stringType$)) {
                    throw new IllegalArgumentException(new StringBuilder(57).append("group column ").append(col).append(" must be of type Long, Int or String but is ").append(datatype.typeName()).toString());
                }
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$sampleRowsForArrayType$1(String featuresColumn$1, Row row) {
        return row.getAs(featuresColumn$1) instanceof DenseVector;
    }

    private DatasetUtils$() {
        MODULE$ = this;
    }
}

