/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.lightgbm.dataset;

import com.microsoft.azure.synapse.ml.lightgbm.LightGBMUtils$;
import com.microsoft.azure.synapse.ml.lightgbm.dataset.DatasetUtils$;
import com.microsoft.lightgbm.SwigPtrWrapper;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_double;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_float;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_int;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_p_void;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_void;
import com.microsoft.ml.lightgbm.doubleChunkedArray;
import com.microsoft.ml.lightgbm.floatChunkedArray;
import com.microsoft.ml.lightgbm.lightgbmlib;
import com.microsoft.ml.lightgbm.lightgbmlibConstants;
import com.microsoft.ml.lightgbm.lightgbmlibJNI;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\n\u0015\u0001\rB\u0001b\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\to\u0001\u0011\t\u0011)A\u0005c!)\u0001\b\u0001C\u0001s!)Q\b\u0001C\u0001}!)\u0001\n\u0001C\u0001\u0013\")Q\u000e\u0001C\u0001]\")!\u000f\u0001C\u0001]\")1\u000f\u0001C\u0001i\")\u0001\u0010\u0001C\u0001s\"1\u0001\u0010\u0001C\u0001\u0003\u000fAa\u0001\u001f\u0001\u0005\u0002\u0005U\u0001bBA\u0012\u0001\u0011\u0005\u0011Q\u0005\u0005\b\u0003G\u0001A\u0011AA\u0017\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003wAq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h!1\u0011\u0011\u0010\u0001\u0005BQ\u0014q\u0002T5hQR<%)\u0014#bi\u0006\u001cX\r\u001e\u0006\u0003+Y\tq\u0001Z1uCN,GO\u0003\u0002\u00181\u0005AA.[4ii\u001e\u0014WN\u0003\u0002\u001a5\u0005\u0011Q\u000e\u001c\u0006\u00037q\tqa]=oCB\u001cXM\u0003\u0002\u001e=\u0005)\u0011M_;sK*\u0011q\u0004I\u0001\n[&\u001c'o\\:pMRT\u0011!I\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0011b\u0003CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0011a\u0017M\\4\u000b\u0003%\nAA[1wC&\u00111F\n\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0015j\u0013B\u0001\u0018'\u00055\tU\u000f^8DY>\u001cX-\u00192mK\u0006QA-\u0019;bg\u0016$\b\u000b\u001e:\u0016\u0003E\u0002\"AM\u001b\u000e\u0003MR!a\u0006\u001b\u000b\u0005eq\u0012B\u0001\u001c4\u0005=\u0019v+S$U3B+u\f]0w_&$\u0017a\u00033bi\u0006\u001cX\r\u001e)ue\u0002\na\u0001P5oSRtDC\u0001\u001e=!\tY\u0004!D\u0001\u0015\u0011\u0015y3\u00011\u00012\u0003!9W\r\u001e'bE\u0016dG#A \u0011\u0007\u0001\u001bU)D\u0001B\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#B\u0005\u0015\t%O]1z!\t\u0001e)\u0003\u0002H\u0003\n)a\t\\8bi\u0006Aq-\u001a;GS\u0016dG-\u0006\u0002K\u001fR\u00111\n\u0019\u000b\u0003\u0019b\u00032\u0001Q\"N!\tqu\n\u0004\u0001\u0005\u000bA+!\u0019A)\u0003\u0003Q\u000b\"AU+\u0011\u0005\u0001\u001b\u0016B\u0001+B\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u0011,\n\u0005]\u000b%aA!os\"9\u0011,BA\u0001\u0002\bQ\u0016AC3wS\u0012,gnY3%cA\u00191LX'\u000e\u0003qS!!X!\u0002\u000fI,g\r\\3di&\u0011q\f\u0018\u0002\t\u00072\f7o\u001d+bO\")\u0011-\u0002a\u0001E\u0006Ia-[3mI:\u000bW.\u001a\t\u0003G*t!\u0001\u001a5\u0011\u0005\u0015\fU\"\u00014\u000b\u0005\u001d\u0014\u0013A\u0002\u001fs_>$h(\u0003\u0002j\u0003\u00061\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tI\u0017)A\u0004ok6$\u0015\r^1\u0015\u0003=\u0004\"\u0001\u00119\n\u0005E\f%aA%oi\u0006Qa.^7GK\u0006$XO]3\u0002\u001fY\fG.\u001b3bi\u0016$\u0015\r^1tKR$\u0012!\u001e\t\u0003\u0001ZL!a^!\u0003\tUs\u0017\u000e^\u0001\u000eC\u0012$g\t\\8bi\u001aKW\r\u001c3\u0015\rUT\u0018\u0011AA\u0002\u0011\u0015Y\u0018\u00021\u0001}\u0003\u00151\u0017.\u001a7e!\r\u00015) \t\u0003\u0001zL!a`!\u0003\r\u0011{WO\u00197f\u0011\u0015\t\u0017\u00021\u0001c\u0011\u0019\t)!\u0003a\u0001_\u00069a.^7S_^\u001cHcB;\u0002\n\u0005E\u00111\u0003\u0005\u0007w*\u0001\r!a\u0003\u0011\u0007I\ni!C\u0002\u0002\u0010M\u0012\u0011C\u001a7pCR\u001c\u0005.\u001e8lK\u0012\f%O]1z\u0011\u0015\t'\u00021\u0001c\u0011\u0019\t)A\u0003a\u0001_R9Q/a\u0006\u0002 \u0005\u0005\u0002BB>\f\u0001\u0004\tI\u0002E\u00023\u00037I1!!\b4\u0005A\u0019v+S$U3B+u\f]0gY>\fG\u000fC\u0003b\u0017\u0001\u0007!\r\u0003\u0004\u0002\u0006-\u0001\ra\\\u0001\u000fC\u0012$Gi\\;cY\u00164\u0015.\u001a7e)\u001d)\u0018qEA\u0015\u0003WAQa\u001f\u0007A\u0002qDQ!\u0019\u0007A\u0002\tDa!!\u0002\r\u0001\u0004yGcB;\u00020\u0005]\u0012\u0011\b\u0005\u0007w6\u0001\r!!\r\u0011\u0007I\n\u0019$C\u0002\u00026M\u0012!\u0003Z8vE2,7\t[;oW\u0016$\u0017I\u001d:bs\")\u0011-\u0004a\u0001E\"1\u0011QA\u0007A\u0002=$r!^A\u001f\u0003\u000b\n9\u0005\u0003\u0004|\u001d\u0001\u0007\u0011q\b\t\u0004e\u0005\u0005\u0013bAA\"g\t\t2kV%H)f\u0003Vi\u00189`I>,(\r\\3\t\u000b\u0005t\u0001\u0019\u00012\t\r\u0005\u0015a\u00021\u0001p\u0003-\tG\rZ%oi\u001aKW\r\u001c3\u0015\u000fU\fi%!\u0015\u0002T!11p\u0004a\u0001\u0003\u001f\u00022\u0001Q\"p\u0011\u0015\tw\u00021\u0001c\u0011\u0019\t)a\u0004a\u0001_\u0006q\u0011\r\u001a3He>,\boQ8mk6tW\u0003BA-\u0003G\"2!^A.\u0011\u001d\ti\u0006\u0005a\u0001\u0003?\nAA]8xgB!\u0001iQA1!\rq\u00151\r\u0003\u0006!B\u0011\r!U\u0001\u0010g\u0016$h)Z1ukJ,g*Y7fgR)!(!\u001b\u0002v!9\u00111N\tA\u0002\u00055\u0014a\u00044fCR,(/\u001a(b[\u0016\u001cx\n\u001d;\u0011\u000b\u0001\u000by'a\u001d\n\u0007\u0005E\u0014I\u0001\u0004PaRLwN\u001c\t\u0004\u0001\u000e\u0013\u0007BBA<#\u0001\u0007q.A\u0004ok6\u001cu\u000e\\:\u0002\u000b\rdwn]3")
public class LightGBMDataset
implements AutoCloseable {
    private final SWIGTYPE_p_void datasetPtr;

    public SWIGTYPE_p_void datasetPtr() {
        return this.datasetPtr;
    }

    public float[] getLabel() {
        return (float[])this.getField("label", ClassTag$.MODULE$.Float());
    }

    public <T> Object getField(String fieldName, ClassTag<T> evidence$1) {
        SWIGTYPE_p_int tmpOutLenPtr = lightgbmlib.new_int32_tp();
        SWIGTYPE_p_int outTypePtr = lightgbmlib.new_int32_tp();
        SWIGTYPE_p_p_void outArray = lightgbmlib.new_voidpp();
        lightgbmlib.LGBM_DatasetGetField((SWIGTYPE_p_void)this.datasetPtr(), (String)fieldName, (SWIGTYPE_p_int)tmpOutLenPtr, (SWIGTYPE_p_p_void)outArray, (SWIGTYPE_p_int)outTypePtr);
        int outType = lightgbmlib.int32_tp_value((SWIGTYPE_p_int)outTypePtr);
        int outLength = lightgbmlib.int32_tp_value((SWIGTYPE_p_int)tmpOutLenPtr);
        SWIGTYPE_p_void voidptr = lightgbmlib.voidpp_value((SWIGTYPE_p_p_void)outArray);
        long address = new SwigPtrWrapper(voidptr).getCPtrValue();
        if (outType == lightgbmlibConstants.C_API_DTYPE_INT32) {
            return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), outLength).map((Function1 & Serializable & scala.Serializable)index -> LightGBMDataset.$anonfun$getField$1(address, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(evidence$1);
        }
        if (outType == lightgbmlibConstants.C_API_DTYPE_FLOAT32) {
            return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), outLength).map((Function1 & Serializable & scala.Serializable)index -> LightGBMDataset.$anonfun$getField$2(address, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(evidence$1);
        }
        if (outType == lightgbmlibConstants.C_API_DTYPE_FLOAT64) {
            return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), outLength).map((Function1 & Serializable & scala.Serializable)index -> LightGBMDataset.$anonfun$getField$3(address, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(evidence$1);
        }
        throw new Exception("Unknown type returned from native lightgbm in LightGBMDataset getField");
    }

    public int numData() {
        SWIGTYPE_p_int numDataPtr = lightgbmlib.new_intp();
        LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetGetNumData((SWIGTYPE_p_void)this.datasetPtr(), (SWIGTYPE_p_int)numDataPtr), "DatasetGetNumData");
        int numData = lightgbmlib.intp_value((SWIGTYPE_p_int)numDataPtr);
        lightgbmlib.delete_intp((SWIGTYPE_p_int)numDataPtr);
        return numData;
    }

    public int numFeature() {
        SWIGTYPE_p_int numFeaturePtr = lightgbmlib.new_intp();
        LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetGetNumFeature((SWIGTYPE_p_void)this.datasetPtr(), (SWIGTYPE_p_int)numFeaturePtr), "DatasetGetNumFeature");
        int numFeature = lightgbmlib.intp_value((SWIGTYPE_p_int)numFeaturePtr);
        lightgbmlib.delete_intp((SWIGTYPE_p_int)numFeaturePtr);
        return numFeature;
    }

    public void validateDataset() {
        int numData = this.numData();
        if (numData <= 0) {
            throw new Exception(new StringBuilder(21).append("Unexpected num data: ").append(numData).toString());
        }
        int numFeature = this.numFeature();
        if (numFeature <= 0) {
            throw new Exception(new StringBuilder(24).append("Unexpected num feature: ").append(numFeature).toString());
        }
    }

    public void addFloatField(double[] field, String fieldName, int numRows) {
        ObjectRef colArray = ObjectRef.create((Object)None$.MODULE$);
        try {
            colArray.elem = new Some((Object)lightgbmlib.new_floatArray((long)numRows));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(field)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)ri -> {
                LightGBMDataset.$anonfun$addFloatField$1(colArray, ri);
                return BoxedUnit.UNIT;
            });
            this.addFloatField((SWIGTYPE_p_float)((Option)colArray.elem).get(), fieldName, numRows);
        }
        finally {
            ((Option)colArray.elem).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                LightGBMDataset.$anonfun$addFloatField$2(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void addFloatField(floatChunkedArray field, String fieldName, int numRows) {
        SWIGTYPE_p_float coalescedLabelArray = lightgbmlib.new_floatArray((long)field.get_add_count());
        try {
            field.coalesce_to(coalescedLabelArray);
            this.addFloatField(coalescedLabelArray, fieldName, numRows);
        }
        finally {
            lightgbmlib.delete_floatArray((SWIGTYPE_p_float)coalescedLabelArray);
        }
    }

    public void addFloatField(SWIGTYPE_p_float field, String fieldName, int numRows) {
        SWIGTYPE_p_void colAsVoidPtr = lightgbmlib.float_to_voidp_ptr((SWIGTYPE_p_float)field);
        int data32bitType = lightgbmlibConstants.C_API_DTYPE_FLOAT32;
        LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetSetField((SWIGTYPE_p_void)this.datasetPtr(), (String)fieldName, (SWIGTYPE_p_void)colAsVoidPtr, (int)numRows, (int)data32bitType), "DatasetSetField");
    }

    public void addDoubleField(double[] field, String fieldName, int numRows) {
        ObjectRef colArray = ObjectRef.create((Object)None$.MODULE$);
        try {
            colArray.elem = new Some((Object)lightgbmlib.new_doubleArray((long)field.length));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(field)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)ri -> {
                LightGBMDataset.$anonfun$addDoubleField$1(colArray, ri);
                return BoxedUnit.UNIT;
            });
            this.addDoubleField((SWIGTYPE_p_double)((Option)colArray.elem).get(), fieldName, numRows);
        }
        finally {
            ((Option)colArray.elem).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                LightGBMDataset.$anonfun$addDoubleField$2(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void addDoubleField(doubleChunkedArray field, String fieldName, int numRows) {
        SWIGTYPE_p_double coalescedLabelArray = lightgbmlib.new_doubleArray((long)field.get_add_count());
        try {
            field.coalesce_to(coalescedLabelArray);
            this.addDoubleField(coalescedLabelArray, fieldName, numRows);
        }
        finally {
            lightgbmlib.delete_doubleArray((SWIGTYPE_p_double)coalescedLabelArray);
        }
    }

    public void addDoubleField(SWIGTYPE_p_double field, String fieldName, int numRows) {
        SWIGTYPE_p_void colAsVoidPtr = lightgbmlib.double_to_voidp_ptr((SWIGTYPE_p_double)field);
        int data64bitType = lightgbmlibConstants.C_API_DTYPE_FLOAT64;
        LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetSetField((SWIGTYPE_p_void)this.datasetPtr(), (String)fieldName, (SWIGTYPE_p_void)colAsVoidPtr, (int)numRows, (int)data64bitType), "DatasetSetField");
    }

    public void addIntField(int[] field, String fieldName, int numRows) {
        ObjectRef colArray = ObjectRef.create((Object)None$.MODULE$);
        try {
            colArray.elem = new Some((Object)lightgbmlib.new_intArray((long)numRows));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(field)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)ri -> {
                LightGBMDataset.$anonfun$addIntField$1(colArray, ri);
                return BoxedUnit.UNIT;
            });
            SWIGTYPE_p_void colAsVoidPtr = lightgbmlib.int_to_voidp_ptr((SWIGTYPE_p_int)((SWIGTYPE_p_int)((Option)colArray.elem).get()));
            int data32bitType = lightgbmlibConstants.C_API_DTYPE_INT32;
            LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetSetField((SWIGTYPE_p_void)this.datasetPtr(), (String)fieldName, (SWIGTYPE_p_void)colAsVoidPtr, (int)numRows, (int)data32bitType), "DatasetSetField");
        }
        finally {
            ((Option)colArray.elem).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                LightGBMDataset.$anonfun$addIntField$2(x$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public <T> void addGroupColumn(Object rows) {
        int[] groupCardinality = DatasetUtils$.MODULE$.countCardinality(Predef$.MODULE$.genericWrapArray(rows));
        this.addIntField(groupCardinality, "group", groupCardinality.length);
    }

    public LightGBMDataset setFeatureNames(Option<String[]> featureNamesOpt, int numCols) {
        featureNamesOpt.foreach((Function1 & Serializable & scala.Serializable)featureNamesArray -> {
            LightGBMDataset.$anonfun$setFeatureNames$1(this, numCols, featureNamesArray);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    @Override
    public void close() {
        LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetFree((SWIGTYPE_p_void)this.datasetPtr()), "Free Dataset");
    }

    public static final /* synthetic */ Object $anonfun$getField$1(long address$1, int index) {
        return BoxesRunTime.boxToInteger((int)lightgbmlibJNI.intArray_getitem((long)address$1, (long)index));
    }

    public static final /* synthetic */ Object $anonfun$getField$2(long address$1, int index) {
        return BoxesRunTime.boxToFloat((float)lightgbmlibJNI.floatArray_getitem((long)address$1, (long)index));
    }

    public static final /* synthetic */ Object $anonfun$getField$3(long address$1, int index) {
        return BoxesRunTime.boxToDouble((double)lightgbmlibJNI.doubleArray_getitem((long)address$1, (long)index));
    }

    public static final /* synthetic */ void $anonfun$addFloatField$1(ObjectRef colArray$1, Tuple2 ri) {
        lightgbmlib.floatArray_setitem((SWIGTYPE_p_float)((SWIGTYPE_p_float)((Option)colArray$1.elem).get()), (long)ri._2$mcI$sp(), (float)((float)ri._1$mcD$sp()));
    }

    public static final /* synthetic */ void $anonfun$addFloatField$2(SWIGTYPE_p_float x$1) {
        lightgbmlib.delete_floatArray((SWIGTYPE_p_float)x$1);
    }

    public static final /* synthetic */ void $anonfun$addDoubleField$1(ObjectRef colArray$2, Tuple2 ri) {
        lightgbmlib.doubleArray_setitem((SWIGTYPE_p_double)((SWIGTYPE_p_double)((Option)colArray$2.elem).get()), (long)ri._2$mcI$sp(), (double)ri._1$mcD$sp());
    }

    public static final /* synthetic */ void $anonfun$addDoubleField$2(SWIGTYPE_p_double x$1) {
        lightgbmlib.delete_doubleArray((SWIGTYPE_p_double)x$1);
    }

    public static final /* synthetic */ void $anonfun$addIntField$1(ObjectRef colArray$3, Tuple2 ri) {
        lightgbmlib.intArray_setitem((SWIGTYPE_p_int)((SWIGTYPE_p_int)((Option)colArray$3.elem).get()), (long)ri._2$mcI$sp(), (int)ri._1$mcI$sp());
    }

    public static final /* synthetic */ void $anonfun$addIntField$2(SWIGTYPE_p_int x$1) {
        lightgbmlib.delete_intArray((SWIGTYPE_p_int)x$1);
    }

    public static final /* synthetic */ void $anonfun$setFeatureNames$1(LightGBMDataset $this, int numCols$1, String[] featureNamesArray) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureNamesArray)).nonEmpty()) {
            LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetSetFeatureNames((SWIGTYPE_p_void)$this.datasetPtr(), (String[])featureNamesArray, (int)numCols$1), "Dataset set feature names");
            return;
        }
    }

    public LightGBMDataset(SWIGTYPE_p_void datasetPtr) {
        this.datasetPtr = datasetPtr;
    }
}

