/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.lightgbm;

import com.microsoft.azure.synapse.ml.lightgbm.BasePartitionTask;
import com.microsoft.azure.synapse.ml.lightgbm.GroupIdManager;
import com.microsoft.azure.synapse.ml.lightgbm.LightGBMUtils$;
import com.microsoft.azure.synapse.ml.lightgbm.PartitionDataState;
import com.microsoft.azure.synapse.ml.lightgbm.PartitionTaskContext;
import com.microsoft.azure.synapse.ml.lightgbm.StreamingState;
import com.microsoft.azure.synapse.ml.lightgbm.TrainingContext;
import com.microsoft.azure.synapse.ml.lightgbm.dataset.BaseAggregatedColumns;
import com.microsoft.azure.synapse.ml.lightgbm.dataset.LightGBMDataset;
import com.microsoft.azure.synapse.ml.lightgbm.dataset.PeekingIterator;
import com.microsoft.azure.synapse.ml.lightgbm.dataset.ReferenceDatasetUtils$;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_double;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_float;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_int;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_p_void;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_void;
import com.microsoft.ml.lightgbm.lightgbmlib;
import com.microsoft.ml.lightgbm.lightgbmlibConstants;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SQLDataTypes$;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\b\u0011\u0001uAQA\t\u0001\u0005\u0002\rBQ!\n\u0001\u0005R\u0019BQ!\u000f\u0001\u0005\u0012iBQ\u0001\u0018\u0001\u0005\u0012uCQa\u001a\u0001\u0005\u0012!DQ!\u001c\u0001\u0005\n9DQ\u0001\u001d\u0001\u0005\nEDQ\u0001\u001e\u0001\u0005\nUDq!!\u0002\u0001\t\u0013\t9\u0001C\u0004\u0002(\u0001!I!!\u000b\t\u000f\u0005U\u0002\u0001\"\u0003\u00028!9\u0011q\t\u0001\u0005\n\u0005%\u0003bBA1\u0001\u0011%\u00111\r\u0005\b\u0003_\u0002A\u0011BA9\u0005Y\u0019FO]3b[&tw\rU1si&$\u0018n\u001c8UCN\\'BA\t\u0013\u0003!a\u0017n\u001a5uO\nl'BA\n\u0015\u0003\tiGN\u0003\u0002\u0016-\u000591/\u001f8baN,'BA\f\u0019\u0003\u0015\t'0\u001e:f\u0015\tI\"$A\u0005nS\u000e\u0014xn]8gi*\t1$A\u0002d_6\u001c\u0001a\u0005\u0002\u0001=A\u0011q\u0004I\u0007\u0002!%\u0011\u0011\u0005\u0005\u0002\u0012\u0005\u0006\u001cX\rU1si&$\u0018n\u001c8UCN\\\u0017A\u0002\u001fj]&$h\bF\u0001%!\ty\u0002!\u0001\nj]&$\u0018.\u00197ju\u0016Le\u000e^3s]\u0006dG\u0003B\u0014.e]\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012A!\u00168ji\")aF\u0001a\u0001_\u0005\u00191\r\u001e=\u0011\u0005}\u0001\u0014BA\u0019\u0011\u0005=!&/Y5oS:<7i\u001c8uKb$\b\"B\u001a\u0003\u0001\u0004!\u0014!F:i_VdG-\u0012=fGV$X\r\u0016:bS:Lgn\u001a\t\u0003QUJ!AN\u0015\u0003\u000f\t{w\u000e\\3b]\")\u0001H\u0001a\u0001i\u0005\u0001\u0012n]#naRL\b+\u0019:uSRLwN\\\u0001\u001daJ,\u0007/\u0019:f!\u0006\u0014H/\u001b;j_:$\u0015\r^1J]R,'O\\1m)\rYdH\u0011\t\u0003?qJ!!\u0010\t\u0003%A\u000b'\u000f^5uS>tG)\u0019;b'R\fG/\u001a\u0005\u0006]\r\u0001\ra\u0010\t\u0003?\u0001K!!\u0011\t\u0003)A\u000b'\u000f^5uS>tG+Y:l\u0007>tG/\u001a=u\u0011\u0015\u00195\u00011\u0001E\u0003%Ig\u000e];u%><8\u000fE\u0002F\u001bBs!AR&\u000f\u0005\u001dSU\"\u0001%\u000b\u0005%c\u0012A\u0002\u001fs_>$h(C\u0001+\u0013\ta\u0015&A\u0004qC\u000e\\\u0017mZ3\n\u00059{%\u0001C%uKJ\fGo\u001c:\u000b\u00051K\u0003CA)[\u001b\u0005\u0011&BA*U\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003+Z\u000bQa\u001d9be.T!a\u0016-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0016aA8sO&\u00111L\u0015\u0002\u0004%><\u0018AG4fiR\u0013\u0018-\u001b8j]\u001e$\u0015\r^1tKRLe\u000e^3s]\u0006dGc\u00010eKB\u0011qLY\u0007\u0002A*\u0011\u0011\rE\u0001\bI\u0006$\u0018m]3u\u0013\t\u0019\u0007MA\bMS\u001eDGo\u0012\"N\t\u0006$\u0018m]3u\u0011\u0015qC\u00011\u0001@\u0011\u00151G\u00011\u0001<\u0003%!\u0017\r^1Ti\u0006$X-\u0001\u000fhKR4\u0016\r\\5eCRLwN\u001c#bi\u0006\u001cX\r^%oi\u0016\u0014h.\u00197\u0015\tyK'n\u001b\u0005\u0006]\u0015\u0001\ra\u0010\u0005\u0006M\u0016\u0001\ra\u000f\u0005\u0006Y\u0016\u0001\rAX\u0001\u0011e\u00164WM]3oG\u0016$\u0015\r^1tKR\fAdZ3oKJ\fG/Z(qiZ\u000bG.\u001b3bi&|g\u000eR1uCN,G\u000f\u0006\u0002__\")aF\u0002a\u0001\u007f\u0005i\u0012N\\:feR\u0014vn^:J]R|GK]1j]&tw\rR1uCN,G\u000fF\u0002(eNDQAL\u0004A\u0002}BQaQ\u0004A\u0002\u0011\u000bQ#\u001b8tKJ$(k\\<t\u0013:$x\u000eR1uCN,G\u000f\u0006\u0005(m^D\u0018P`A\u0001\u0011\u0015q\u0003\u00021\u0001@\u0011\u0015\t\u0007\u00021\u0001_\u0011\u0015\u0019\u0005\u00021\u0001E\u0011\u0015Q\b\u00021\u0001|\u0003)\u0019H/\u0019:u\u0013:$W\r\u001f\t\u0003QqL!!`\u0015\u0003\u0007%sG\u000fC\u0003\u0000\u0011\u0001\u000710A\u0005ti>\u0004\u0018J\u001c3fq\"1\u00111\u0001\u0005A\u0002m\f1\u0002\u001e5sK\u0006$\u0017J\u001c3fq\u0006)\u0002/^:i\t\u0016t7/Z'jGJ|')\u0019;dQ\u0016\u001cH#C\u0014\u0002\n\u0005M\u0011QCA\f\u0011\u001d\tY!\u0003a\u0001\u0003\u001b\tQa\u001d;bi\u0016\u00042aHA\b\u0013\r\t\t\u0002\u0005\u0002\u000f'R\u0014X-Y7j]\u001e\u001cF/\u0019;f\u0011\u0015\u0019\u0015\u00021\u0001E\u0011\u0015Q\u0018\u00021\u0001|\u0011\u0015y\u0018\u00021\u0001|Q\rI\u00111\u0004\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002&\u0005}!a\u0002;bS2\u0014XmY\u0001\u0017aV\u001c\bn\u00159beN,W*[2s_\n\u000bGo\u00195fgRIq%a\u000b\u0002.\u0005=\u0012\u0011\u0007\u0005\b\u0003\u0017Q\u0001\u0019AA\u0007\u0011\u0015\u0019%\u00021\u0001E\u0011\u0015Q(\u00021\u0001|\u0011\u0015y(\u00021\u0001|Q\rQ\u00111D\u0001\u001dY>\fGm\u00148f\t\u0016t7/Z'jGJ|')\u0019;dQ\n+hMZ3s)%Y\u0018\u0011HA\u001e\u0003{\t\t\u0005C\u0004\u0002\f-\u0001\r!!\u0004\t\u000b\r[\u0001\u0019\u0001#\t\r\u0005}2\u00021\u0001|\u00031\u0019WO\u001d:f]R\u001cu.\u001e8u\u0011\u0019\t\u0019e\u0003a\u0001w\u0006iQ.\u0019=CCR\u001c\u0007nQ8v]RD3aCA\u000e\u0003uaw.\u00193P]\u0016\u001c\u0006/\u0019:tK6K7M]8CCR\u001c\u0007NQ;gM\u0016\u0014H\u0003DA&\u0003#\n\u0019&!\u0016\u0002Z\u0005u\u0003#\u0002\u0015\u0002Nm\\\u0018bAA(S\t1A+\u001e9mKJBq!a\u0003\r\u0001\u0004\ti\u0001C\u0003D\u0019\u0001\u0007A\t\u0003\u0004\u0002X1\u0001\ra_\u0001\u000eE\u0006$8\r\u001b*po\u000e{WO\u001c;\t\r\u0005mC\u00021\u0001|\u00031)G.Z7f]R\u001cu.\u001e8u\u0011\u0019\t\u0019\u0005\u0004a\u0001w\"\u001aA\"a\u0007\u0002%1|\u0017\rZ(oK6+G/\u00193bi\u0006\u0014vn\u001e\u000b\bO\u0005\u0015\u0014qMA6\u0011\u001d\tY!\u0004a\u0001\u0003\u001bAa!!\u001b\u000e\u0001\u0004\u0001\u0016a\u0001:po\"1\u0011QN\u0007A\u0002m\fQ!\u001b8eKb\fQd\u0019:fCR,7\u000b[1sK\u00124\u0016\r\\5eCRLwN\u001c#bi\u0006\u001cX\r\u001e\u000b\u0006=\u0006M\u0014Q\u000f\u0005\u0006]9\u0001\ra\u0010\u0005\u0007\u0003or\u0001\u0019A>\u0002\u0011I|woQ8v]R\u0004")
public class StreamingPartitionTask
extends BasePartitionTask {
    @Override
    public void initializeInternal(TrainingContext ctx, boolean shouldExecuteTraining, boolean isEmptyPartition) {
        if (!shouldExecuteTraining && !isEmptyPartition) {
            ctx.sharedState().incrementDataPrepDoneSignal(this.log());
        }
        if (ctx.hasValidationData() && !isEmptyPartition) {
            ctx.sharedState().linkValidationDatasetWorker();
            return;
        }
    }

    @Override
    public PartitionDataState preparePartitionDataInternal(PartitionTaskContext ctx, Iterator<Row> inputRows) {
        if (ctx.shouldExecuteTraining()) {
            ctx.sharedState().datasetState().streamingDataset_$eq((Option<LightGBMDataset>)Option$.MODULE$.apply((Object)ReferenceDatasetUtils$.MODULE$.getInitializedReferenceDataset(ctx)));
            ctx.sharedState().helperStartSignal().countDown();
        } else {
            ctx.sharedState().helperStartSignal().await();
        }
        PeekingIterator<Row> rowIterator = this.determineMatrixType(ctx, inputRows);
        this.insertRowsIntoTrainingDataset(ctx, rowIterator);
        if (ctx.shouldCalcValidationDataset()) {
            ctx.sharedState().validationDatasetState().streamingDataset_$eq((Option<LightGBMDataset>)Option$.MODULE$.apply((Object)this.generateOptValidationDataset(ctx)));
        }
        return new PartitionDataState((Option<BaseAggregatedColumns>)None$.MODULE$, (Option<BaseAggregatedColumns>)None$.MODULE$);
    }

    @Override
    public LightGBMDataset getTrainingDatasetInternal(PartitionTaskContext ctx, PartitionDataState dataState) {
        LightGBMDataset dataset = (LightGBMDataset)ctx.sharedState().datasetState().streamingDataset().get();
        LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetMarkFinished((SWIGTYPE_p_void)dataset.datasetPtr()), "Dataset mark finished");
        return dataset;
    }

    @Override
    public LightGBMDataset getValidationDatasetInternal(PartitionTaskContext ctx, PartitionDataState dataState, LightGBMDataset referenceDataset) {
        return (LightGBMDataset)ctx.sharedState().validationDatasetState().streamingDataset().get();
    }

    private LightGBMDataset generateOptValidationDataset(PartitionTaskContext ctx) {
        Row[] validationData = (Row[])((Broadcast)ctx.trainingCtx().validationData().get()).value();
        LightGBMDataset validationDataset = this.createSharedValidationDataset(ctx, validationData.length);
        this.insertRowsIntoDataset(ctx, validationDataset, (Iterator<Row>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])validationData)).toIterator(), 0, validationData.length, 0);
        LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetMarkFinished((SWIGTYPE_p_void)validationDataset.datasetPtr()), "Dataset mark finished");
        return validationDataset;
    }

    private void insertRowsIntoTrainingDataset(PartitionTaskContext ctx, Iterator<Row> inputRows) {
        int partitionRowCount = (int)((long[])ctx.trainingCtx().partitionCounts().get())[ctx.partitionId()];
        int partitionRowOffset = ctx.streamingPartitionOffset();
        boolean isSparse = BoxesRunTime.unboxToBoolean((Object)ctx.sharedState().isSparse().get());
        this.log().debug(new StringBuilder(91).append("Inserting rows into training Dataset from partition ").append(ctx.partitionId()).append(", ").append("size ").append(partitionRowCount).append(", offset: ").append(partitionRowOffset).append(", sparse: ").append(isSparse).append(", threadId: ").append(ctx.threadIndex()).toString());
        LightGBMDataset dataset = (LightGBMDataset)ctx.sharedState().datasetState().streamingDataset().get();
        int stopIndex = partitionRowOffset + partitionRowCount;
        this.insertRowsIntoDataset(ctx, dataset, inputRows, partitionRowOffset, stopIndex, ctx.threadIndex());
    }

    private void insertRowsIntoDataset(PartitionTaskContext ctx, LightGBMDataset dataset, Iterator<Row> inputRows, int startIndex, int stopIndex, int threadIndex) {
        StreamingState state = new StreamingState(ctx, dataset, threadIndex);
        try {
            if (BoxesRunTime.unboxToBoolean((Object)ctx.sharedState().isSparse().get())) {
                this.pushSparseMicroBatches(state, inputRows, startIndex, stopIndex);
            } else {
                this.pushDenseMicroBatches(state, inputRows, startIndex, stopIndex);
            }
        }
        finally {
            state.delete();
        }
    }

    private void pushDenseMicroBatches(StreamingState state, Iterator<Row> inputRows, int startIndex, int stopIndex) {
        while (true) {
            int maxBatchSize;
            int count;
            int n = count = (maxBatchSize = Math.min(state.microBatchSize(), stopIndex - startIndex)) == 0 ? 0 : this.loadOneDenseMicroBatchBuffer(state, inputRows, 0, maxBatchSize);
            if (count <= false) break;
            if (state.hasInitialScores() && state.microBatchSize() != count && state.numInitScoreClasses() > 1) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), state.numInitScoreClasses()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                    double score = state.initScoreBuffer().getItem(i * state.microBatchSize() + j);
                    state.initScoreBuffer().setItem((long)(i * count + j), score);
                }));
            }
            LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetPushRowsWithMetadata((SWIGTYPE_p_void)state.datasetPointer(), (SWIGTYPE_p_void)state.featureDataPtr(), (int)lightgbmlibConstants.C_API_DTYPE_FLOAT64, (int)count, (int)state.numCols(), (int)startIndex, (SWIGTYPE_p_float)state.labelPtr(), (SWIGTYPE_p_float)state.weightPtr(), (SWIGTYPE_p_double)state.initScorePtr(), (SWIGTYPE_p_int)state.groupPtr(), (int)state.threadIndex()), "Dataset push dense micro-batch");
            startIndex += count;
        }
    }

    private void pushSparseMicroBatches(StreamingState state, Iterator<Row> inputRows, int startIndex, int stopIndex) {
        while (true) {
            int maxBatchSize;
            Tuple2<Object, Object> tuple2;
            Tuple2<Object, Object> tuple22 = tuple2 = (maxBatchSize = Math.min(state.microBatchSize(), stopIndex - startIndex)) == 0 ? new Tuple2<Object, Object>(0, 0) : this.loadOneSparseMicroBatchBuffer(state, inputRows, 0, 0, maxBatchSize);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int microBatchRowCount = tuple2._1$mcI$sp();
            int microBatchElementCount = tuple2._2$mcI$sp();
            int n = microBatchRowCount;
            int n2 = microBatchElementCount;
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(n, n2);
            int microBatchRowCount2 = sp2._1$mcI$sp();
            int microBatchElementCount2 = sp2._2$mcI$sp();
            if (microBatchRowCount2 <= 0) break;
            if (state.hasInitialScores() && state.microBatchSize() != microBatchRowCount2 && state.numInitScoreClasses() > 1) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), state.numInitScoreClasses()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), microBatchRowCount2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
                    double score = state.initScoreBuffer().getItem(i * state.microBatchSize() + j);
                    state.initScoreBuffer().setItem((long)(i * microBatchRowCount2 + j), score);
                }));
            }
            LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetPushRowsByCSRWithMetadata((SWIGTYPE_p_void)state.datasetPointer(), (SWIGTYPE_p_void)state.indptrPtr(), (int)lightgbmlibConstants.C_API_DTYPE_INT64, (SWIGTYPE_p_int)state.indicesPtr(), (SWIGTYPE_p_void)state.valPtr(), (int)lightgbmlibConstants.C_API_DTYPE_FLOAT64, (long)(microBatchRowCount2 + 1), (long)microBatchElementCount2, (long)startIndex, (SWIGTYPE_p_float)state.labelPtr(), (SWIGTYPE_p_float)state.weightPtr(), (SWIGTYPE_p_double)state.initScorePtr(), (SWIGTYPE_p_int)state.groupPtr(), (int)state.threadIndex()), "Dataset push CSR micro-batch");
            startIndex += microBatchRowCount2;
        }
    }

    private int loadOneDenseMicroBatchBuffer(StreamingState state, Iterator<Row> inputRows, int currentCount, int maxBatchCount) {
        while (inputRows.hasNext() && currentCount < maxBatchCount) {
            Row row = (Row)inputRows.next();
            Object object = row.getAs(state.featureIndex());
            if (object instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)object;
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(denseVector.values())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    StreamingPartitionTask.$anonfun$loadOneDenseMicroBatchBuffer$1(state, currentCount, x0$1);
                    return BoxedUnit.UNIT;
                });
            } else if (object instanceof SparseVector) {
                SparseVector sparseVector = (SparseVector)object;
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sparseVector.toArray())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    StreamingPartitionTask.$anonfun$loadOneDenseMicroBatchBuffer$2(state, currentCount, x0$2);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError(object);
            }
            this.loadOneMetadataRow(state, row, currentCount);
            ++currentCount;
        }
        return currentCount;
    }

    private Tuple2<Object, Object> loadOneSparseMicroBatchBuffer(StreamingState state, Iterator<Row> inputRows, int batchRowCount, int elementCount, int maxBatchCount) {
        while (inputRows.hasNext() && batchRowCount < maxBatchCount) {
            SparseVector sparseVector;
            Row row = (Row)inputRows.next();
            Object object = row.getAs(state.featureIndex());
            if (object instanceof DenseVector) {
                DenseVector denseVector = (DenseVector)object;
                sparseVector = denseVector.toSparse();
            } else if (object instanceof SparseVector) {
                SparseVector sparseVector2;
                sparseVector = sparseVector2 = (SparseVector)object;
            } else {
                throw new Exception(row.getAs(state.featureIndex()).toString());
            }
            SparseVector sparseVector3 = sparseVector;
            int rowElementCount = sparseVector3.values().length;
            int endIndex = rowElementCount + elementCount;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sparseVector3.values())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                StreamingPartitionTask.$anonfun$loadOneSparseMicroBatchBuffer$1(state, elementCount, x0$1);
                return BoxedUnit.UNIT;
            });
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(sparseVector3.indices())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                StreamingPartitionTask.$anonfun$loadOneSparseMicroBatchBuffer$2(state, elementCount, x0$2);
                return BoxedUnit.UNIT;
            });
            state.indptrBuffer().setItem((long)(batchRowCount + 1), endIndex);
            this.loadOneMetadataRow(state, row, batchRowCount);
            elementCount = endIndex;
            ++batchRowCount;
        }
        return new Tuple2.mcII.sp(batchRowCount, elementCount);
    }

    private void loadOneMetadataRow(StreamingState state, Row row, int index) {
        state.labelBuffer().setItem((long)index, (float)row.getDouble(state.labelIndex()));
        if (state.hasWeights()) {
            state.weightBuffer().setItem((long)index, (float)row.getDouble(state.weightIndex()));
        }
        if (state.hasGroups()) {
            GroupIdManager groupIdManager = state.ctx().sharedState().groupIdManager();
            state.groupBuffer().setItem((long)index, groupIdManager.getUniqueIdForGroup(row.getAs(state.groupIndex())));
        }
        if (state.hasInitialScores()) {
            DataType dataType = row.schema().apply(state.initScoreIndex()).dataType();
            DataType dataType2 = SQLDataTypes$.MODULE$.VectorType();
            if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(((DenseVector)row.getAs(state.initScoreIndex())).values())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    StreamingPartitionTask.$anonfun$loadOneMetadataRow$1(state, index, x0$1);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            state.initScoreBuffer().setItem((long)index, row.getDouble(state.initScoreIndex()));
            return;
        }
    }

    private LightGBMDataset createSharedValidationDataset(PartitionTaskContext ctx, int rowCount) {
        SWIGTYPE_p_p_void pointer = lightgbmlib.voidpp_handle();
        SWIGTYPE_p_void reference = ((LightGBMDataset)ctx.sharedState().datasetState().streamingDataset().get()).datasetPtr();
        LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetCreateByReference((SWIGTYPE_p_void)reference, (long)rowCount, (SWIGTYPE_p_p_void)pointer), "Dataset create from reference");
        SWIGTYPE_p_void datasetPtr = lightgbmlib.voidpp_value((SWIGTYPE_p_p_void)pointer);
        LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetSetWaitForManualFinish((SWIGTYPE_p_void)datasetPtr, (int)1), "Dataset LGBM_DatasetSetWaitForManualFinish");
        lightgbmlib.delete_voidpp((SWIGTYPE_p_p_void)pointer);
        LightGBMDataset dataset = new LightGBMDataset(datasetPtr);
        return dataset.setFeatureNames(ctx.trainingCtx().featureNames(), ctx.trainingCtx().numCols());
    }

    public static final /* synthetic */ void $anonfun$loadOneDenseMicroBatchBuffer$1(StreamingState state$3, int currentCount$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double x = tuple2._1$mcD$sp();
            int i = tuple2._2$mcI$sp();
            state$3.featureDataBuffer().setItem((long)(currentCount$1 * state$3.numCols() + i), x);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$loadOneDenseMicroBatchBuffer$2(StreamingState state$3, int currentCount$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            double x = tuple2._1$mcD$sp();
            int i = tuple2._2$mcI$sp();
            state$3.featureDataBuffer().setItem((long)(currentCount$1 * state$3.numCols() + i), x);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$loadOneSparseMicroBatchBuffer$1(StreamingState state$4, int elementCount$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double value = tuple2._1$mcD$sp();
            int i = tuple2._2$mcI$sp();
            state$4.valBuffer().setItem((long)(elementCount$1 + i), value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$loadOneSparseMicroBatchBuffer$2(StreamingState state$4, int elementCount$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int index = tuple2._1$mcI$sp();
            int i = tuple2._2$mcI$sp();
            state$4.indicesBuffer().setItem((long)(elementCount$1 + i), index);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$loadOneMetadataRow$1(StreamingState state$5, int index$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double value = tuple2._1$mcD$sp();
            int i = tuple2._2$mcI$sp();
            state$5.initScoreBuffer().setItem((long)(index$1 + state$5.microBatchSize() * i), value);
            return;
        }
        throw new MatchError((Object)tuple2);
    }
}

