/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.lightgbm.dataset;

import com.microsoft.azure.synapse.ml.lightgbm.InstrumentationMeasures;
import com.microsoft.azure.synapse.ml.lightgbm.LightGBMUtils$;
import com.microsoft.azure.synapse.ml.lightgbm.PartitionTaskContext;
import com.microsoft.azure.synapse.ml.lightgbm.dataset.LightGBMDataset;
import com.microsoft.azure.synapse.ml.lightgbm.dataset.SampledData;
import com.microsoft.azure.synapse.ml.lightgbm.swig.SwigUtils$;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_int;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_p_double;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_p_int;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_p_void;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_unsigned_char;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_void;
import com.microsoft.ml.lightgbm.lightgbmlib;
import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ReferenceDatasetUtils$ {
    public static ReferenceDatasetUtils$ MODULE$;

    static {
        new ReferenceDatasetUtils$();
    }

    public byte[] createReferenceDatasetFromSample(String datasetParams, String featuresCol, long numRows, int numCols, Row[] sampledRowData, InstrumentationMeasures measures, Logger log) {
        byte[] byArray;
        log.info(new StringBuilder(62).append("Creating reference training dataset with ").append(sampledRowData.length).append(" samples and config: ").append(datasetParams).toString());
        SWIGTYPE_p_p_void datasetVoidPtr = lightgbmlib.voidpp_handle();
        SWIGTYPE_p_int lenPtr = lightgbmlib.new_intp();
        SWIGTYPE_p_p_void bufferHandlePtr = lightgbmlib.voidpp_handle();
        SampledData sampledData = new SampledData(sampledRowData.length, numCols);
        try {
            measures.markSamplingStart();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampledRowData)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ReferenceDatasetUtils$.$anonfun$createReferenceDatasetFromSample$1(sampledData, featuresCol, x0$1);
                return BoxedUnit.UNIT;
            });
            measures.markSamplingStop();
            SWIGTYPE_p_p_void datasetVoidPtr2 = lightgbmlib.voidpp_handle();
            LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetCreateFromSampledColumn((SWIGTYPE_p_p_double)sampledData.getSampleData(), (SWIGTYPE_p_p_int)sampledData.getSampleIndices(), (int)numCols, (SWIGTYPE_p_int)sampledData.getRowCounts(), (int)sampledData.numRows(), (int)1, (long)numRows, (String)datasetParams, (SWIGTYPE_p_p_void)datasetVoidPtr2), "Dataset create from samples");
            SWIGTYPE_p_void datasetHandle = lightgbmlib.voidpp_value((SWIGTYPE_p_p_void)datasetVoidPtr2);
            LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetSerializeReferenceToBinary((SWIGTYPE_p_void)datasetHandle, (SWIGTYPE_p_p_void)bufferHandlePtr, (SWIGTYPE_p_int)lenPtr), "Serialize ref");
            int bufferLen = lightgbmlib.intp_value((SWIGTYPE_p_int)lenPtr);
            log.info(new StringBuilder(47).append("Created serialized reference dataset of length ").append(bufferLen).toString());
            LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetFree((SWIGTYPE_p_void)datasetHandle), "Free Dataset");
            byArray = this.toByteArray(bufferHandlePtr, bufferLen);
        }
        finally {
            sampledData.delete();
            lightgbmlib.delete_voidpp((SWIGTYPE_p_p_void)datasetVoidPtr);
            lightgbmlib.delete_voidpp((SWIGTYPE_p_p_void)bufferHandlePtr);
            lightgbmlib.delete_intp((SWIGTYPE_p_int)lenPtr);
        }
        return byArray;
    }

    public LightGBMDataset getInitializedReferenceDataset(PartitionTaskContext ctx) {
        byte[] serializedDataset = (byte[])ctx.trainingCtx().serializedReferenceDataset().get();
        int count = ctx.executorRowCount();
        String datasetParams = ctx.trainingCtx().datasetParams();
        LightGBMDataset lightGBMDataset = this.deserializeReferenceDataset(serializedDataset, count, datasetParams);
        int maxOmpThreads = ctx.trainingParams().executionParams().maxStreamingOMPThreads();
        LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetInitStreaming((SWIGTYPE_p_void)lightGBMDataset.datasetPtr(), (int)ctx.trainingCtx().hasWeightsAsInt(), (int)ctx.trainingCtx().hasInitialScoresAsInt(), (int)ctx.trainingCtx().hasGroupsAsInt(), (int)ctx.trainingParams().getNumClass(), (int)ctx.executorPartitionCount(), (int)maxOmpThreads), "LGBM_DatasetInitStreaming");
        return lightGBMDataset.setFeatureNames(ctx.trainingCtx().featureNames(), ctx.trainingCtx().numCols());
    }

    private byte[] toByteArray(SWIGTYPE_p_p_void buffer, int bufferLen) {
        byte[] byteArray = new byte[bufferLen];
        SWIGTYPE_p_unsigned_char valPtr = lightgbmlib.new_bytep();
        SWIGTYPE_p_void bufferHandle = lightgbmlib.voidpp_value((SWIGTYPE_p_p_void)buffer);
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), bufferLen).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_ByteBufferGetAt((SWIGTYPE_p_void)bufferHandle, (int)i, (SWIGTYPE_p_unsigned_char)valPtr), "Buffer get-at");
                byteArray$1[i] = (byte)lightgbmlib.bytep_value((SWIGTYPE_p_unsigned_char)valPtr);
            });
        }
        finally {
            lightgbmlib.delete_bytep((SWIGTYPE_p_unsigned_char)valPtr);
            LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_ByteBufferFree((SWIGTYPE_p_void)bufferHandle), "Buffer free");
        }
        return byteArray;
    }

    private LightGBMDataset deserializeReferenceDataset(byte[] serializedDataset, int rowCount, String datasetParams) {
        SWIGTYPE_p_p_void datasetVoidPtr = lightgbmlib.voidpp_handle();
        SWIGTYPE_p_unsigned_char nativeByteArray = SwigUtils$.MODULE$.byteArrayToNative(serializedDataset);
        LightGBMUtils$.MODULE$.validate(lightgbmlib.LGBM_DatasetCreateFromSerializedReference((SWIGTYPE_p_void)lightgbmlib.byte_to_voidp_ptr((SWIGTYPE_p_unsigned_char)nativeByteArray), (int)serializedDataset.length, (long)rowCount, (int)0, (String)datasetParams, (SWIGTYPE_p_p_void)datasetVoidPtr), "Dataset create from reference");
        SWIGTYPE_p_void datasetPtr = lightgbmlib.voidpp_value((SWIGTYPE_p_p_void)datasetVoidPtr);
        lightgbmlib.delete_voidpp((SWIGTYPE_p_p_void)datasetVoidPtr);
        return new LightGBMDataset(datasetPtr);
    }

    public static final /* synthetic */ void $anonfun$createReferenceDatasetFromSample$1(SampledData sampledData$1, String featuresCol$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Row row = (Row)tuple2._1();
            int index = tuple2._2$mcI$sp();
            sampledData$1.pushRow(row, index, featuresCol$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private ReferenceDatasetUtils$() {
        MODULE$ = this;
    }
}

