/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.lightgbm;

import com.microsoft.azure.synapse.ml.core.contracts.HasInputCols;
import com.microsoft.azure.synapse.ml.core.env.NativeLoader;
import com.microsoft.azure.synapse.ml.featurize.Featurize;
import com.microsoft.azure.synapse.ml.featurize.FeaturizeUtilities$;
import com.microsoft.ml.lightgbm.SWIGTYPE_p_void;
import com.microsoft.ml.lightgbm.lightgbmlib;
import java.io.Serializable;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.sql.Dataset;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LightGBMUtils$ {
    public static LightGBMUtils$ MODULE$;

    static {
        new LightGBMUtils$();
    }

    public void validate(int result, String component) {
        if (result == -1) {
            throw new Exception(new StringBuilder(37).append(component).append(" call failed in LightGBM with error: ").append(lightgbmlib.LGBM_GetLastError()).toString());
        }
    }

    public void validateArray(SWIGTYPE_p_void result, String component) {
        if (result == null) {
            throw new Exception(new StringBuilder(37).append(component).append(" call failed in LightGBM with error: ").append(lightgbmlib.LGBM_GetLastError()).toString());
        }
    }

    public void initializeNativeLibrary() {
        String osPrefix = NativeLoader.getOSPrefix();
        new NativeLoader("/com/microsoft/ml/lightgbm").loadLibraryByName(new StringBuilder(9).append(osPrefix).append("_lightgbm").toString());
        new NativeLoader("/com/microsoft/ml/lightgbm").loadLibraryByName(new StringBuilder(14).append(osPrefix).append("_lightgbm_swig").toString());
    }

    public PipelineModel getFeaturizer(Dataset<?> dataset, String labelColumn, String featuresColumn, Option<String> weightColumn, Option<String> groupColumn, boolean oneHotEncodeCategoricals) {
        Seq featureColumns = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.columns())).filter((Function1 & Serializable & scala.Serializable)col -> BoxesRunTime.boxToBoolean((boolean)LightGBMUtils$.$anonfun$getFeaturizer$1(labelColumn, weightColumn, groupColumn, col))))).toSeq();
        return ((Featurize)((HasInputCols)new Featurize().setOutputCol(featuresColumn)).setInputCols((String[])featureColumns.toArray(ClassTag$.MODULE$.apply(String.class)))).setOneHotEncodeCategoricals(oneHotEncodeCategoricals).setNumFeatures(FeaturizeUtilities$.MODULE$.NumFeaturesTreeOrNNBased()).fit(dataset);
    }

    public Option<String> getFeaturizer$default$4() {
        return None$.MODULE$;
    }

    public Option<String> getFeaturizer$default$5() {
        return None$.MODULE$;
    }

    public boolean getFeaturizer$default$6() {
        return true;
    }

    public int getWorkerId() {
        String executorId = SparkEnv$.MODULE$.get().executorId();
        TaskContext ctx = TaskContext$.MODULE$.get();
        int partId = ctx.partitionId();
        String string = executorId;
        String string2 = "driver";
        Object id = !(string != null ? !string.equals(string2) : string2 != null) ? BoxesRunTime.boxToInteger((int)partId) : executorId;
        int idAsInt = new StringOps(Predef$.MODULE$.augmentString(id.toString())).toInt();
        return idAsInt;
    }

    public int getPartitionId() {
        TaskContext ctx = TaskContext$.MODULE$.get();
        return ctx.partitionId();
    }

    public String getExecutorId() {
        return SparkEnv$.MODULE$.get().executorId();
    }

    public boolean isLocalExecution() {
        String executorId;
        String string = executorId = SparkEnv$.MODULE$.get().executorId();
        String string2 = "driver";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public long getTaskId() {
        TaskContext ctx = TaskContext$.MODULE$.get();
        long taskId = ctx.taskAttemptId();
        return taskId;
    }

    public static final /* synthetic */ boolean $anonfun$getFeaturizer$1(String labelColumn$1, Option weightColumn$1, Option groupColumn$1, String col) {
        String string = col;
        String string2 = labelColumn$1;
        return (string == null ? string2 != null : !string.equals(string2)) && !weightColumn$1.contains((Object)col) && !groupColumn$1.contains((Object)col);
    }

    private LightGBMUtils$() {
        MODULE$ = this;
    }
}

