/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.opencv;

import com.microsoft.azure.synapse.ml.core.schema.BinaryFileSchema$;
import com.microsoft.azure.synapse.ml.opencv.ImageTransformer;
import com.microsoft.azure.synapse.ml.opencv.ImageTransformerStage;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.ml.ImageInjections$;
import org.apache.spark.ml.image.ImageSchema$;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ImageTransformer$
implements DefaultParamsReadable<ImageTransformer>,
scala.Serializable {
    public static ImageTransformer$ MODULE$;

    static {
        new ImageTransformer$();
    }

    public MLReader<ImageTransformer> read() {
        return DefaultParamsReadable.read$((DefaultParamsReadable)this);
    }

    public ImageTransformer load(String path) {
        return (ImageTransformer)((Object)MLReadable.load$((MLReadable)this, (String)path));
    }

    private Tuple2<String, Mat> row2mat(Row row) {
        String path = ImageSchema$.MODULE$.getOrigin(row);
        int height = ImageSchema$.MODULE$.getHeight(row);
        int width = ImageSchema$.MODULE$.getWidth(row);
        int ocvType = ImageSchema$.MODULE$.getMode(row);
        byte[] bytes = ImageSchema$.MODULE$.getData(row);
        Mat img = new Mat(height, width, ocvType);
        img.put(0, 0, bytes);
        return new Tuple2((Object)path, (Object)img);
    }

    private Row mat2row(Mat img, String path) {
        byte[] ocvBytes = new byte[(int)img.total() * (int)img.elemSize()];
        img.get(0, 0, ocvBytes);
        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path, BoxesRunTime.boxToInteger((int)img.height()), BoxesRunTime.boxToInteger((int)img.width()), BoxesRunTime.boxToInteger((int)img.channels()), BoxesRunTime.boxToInteger((int)img.type()), ocvBytes}));
    }

    private String mat2row$default$2() {
        return "";
    }

    public Option<Tuple2<String, Mat>> decodeImage(String decodeMode, Object r) {
        return Option$.MODULE$.apply(r).flatMap((Function1 & Serializable & scala.Serializable)row -> {
            Tuple2 tuple2 = new Tuple2(row, (Object)decodeMode);
            if (tuple2 != null) {
                Object row2 = tuple2._1();
                String string = (String)tuple2._2();
                if (row2 instanceof Row) {
                    Row row3 = (Row)row2;
                    if ("binaryfile".equals(string)) {
                        String path = BinaryFileSchema$.MODULE$.getPath(row3);
                        byte[] bytes = BinaryFileSchema$.MODULE$.getBytes(row3);
                        return ImageInjections$.MODULE$.decode(path, bytes).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getStruct(0));
                    }
                }
            }
            if (tuple2 != null) {
                Object bytes = tuple2._1();
                String string = (String)tuple2._2();
                if (bytes instanceof byte[]) {
                    byte[] byArray = (byte[])bytes;
                    if ("binary".equals(string)) {
                        return ImageInjections$.MODULE$.decode(null, byArray).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getStruct(0));
                    }
                }
            }
            if (tuple2 != null) {
                Object row4 = tuple2._1();
                String string = (String)tuple2._2();
                if (row4 instanceof Row) {
                    Row row5 = (Row)row4;
                    if ("image".equals(string)) {
                        return new Some((Object)row5);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String mode = (String)tuple2._2();
            throw new MatchError((Object)new StringBuilder(21).append("Unknown decoder mode ").append(mode).toString());
        }).map((Function1 & Serializable & scala.Serializable)row -> MODULE$.row2mat((Row)row));
    }

    public Mat processImage(Seq<ImageTransformerStage> stages, Mat image) {
        return (Mat)stages.foldLeft((Object)image, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Mat imgInternal = (Mat)tuple2._1();
            ImageTransformerStage stage = (ImageTransformerStage)tuple2._2();
            Mat mat = stage.apply(imgInternal);
            return mat;
        });
    }

    public Mat[] extractChannels(String channelOrder, boolean autoConvertToColor, Mat image) {
        Mat mat;
        boolean channelOrderIsRgb;
        String string = channelOrder.toLowerCase();
        String string2 = "rgb";
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : (channelOrderIsRgb = false);
        if (image.channels() == 4) {
            Mat dest = new Mat(image.rows(), image.cols(), CvType.CV_8UC3);
            int colorConversion = channelOrderIsRgb ? 3 : 1;
            Imgproc.cvtColor((Mat)image, (Mat)dest, (int)colorConversion);
            mat = dest;
        } else if (image.channels() == 3 && channelOrderIsRgb) {
            Mat dest = new Mat(image.rows(), image.cols(), CvType.CV_8UC3);
            Imgproc.cvtColor((Mat)image, (Mat)dest, (int)4);
            mat = dest;
        } else if (image.channels() == 1 && autoConvertToColor) {
            Mat dest = new Mat(image.rows(), image.cols(), CvType.CV_8UC3);
            int colorConversion = channelOrderIsRgb ? 8 : 8;
            Imgproc.cvtColor((Mat)image, (Mat)dest, (int)colorConversion);
            mat = dest;
        } else {
            mat = image;
        }
        Mat converted = mat;
        int channelLength = converted.channels();
        ListBuffer channelMats = (ListBuffer)ListBuffer$.MODULE$.fill(channelLength, (Function0 & Serializable & scala.Serializable)() -> Mat.zeros((int)converted.rows(), (int)converted.cols(), (int)0));
        Core.split((Mat)converted, (List)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)channelMats).asJava()));
        return (Mat[])channelMats.toArray(ClassTag$.MODULE$.apply(Mat.class));
    }

    public Mat[] normalizeChannels(Option<double[]> means, Option<double[]> stds, Option<Object> scaleFactor, Mat[] channels) {
        int channelLength = channels.length;
        int meansLength = means.isDefined() ? ((double[])means.get()).length : -1;
        int stdLength = stds.isDefined() ? ((double[])stds.get()).length : -1;
        Predef$.MODULE$.require(means.forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ImageTransformer$.$anonfun$normalizeChannels$1(channelLength, x$7))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("channelLength: ").append(channelLength).append(", means length: ").append(meansLength).toString());
        Predef$.MODULE$.require(stds.forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ImageTransformer$.$anonfun$normalizeChannels$3(channelLength, x$8))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("channelLength: ").append(channelLength).append(", stds length: ").append(stdLength).toString());
        return (Mat[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])channels)).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray((double[])means.getOrElse((Function0 & Serializable & scala.Serializable)() -> (double[])Array$.MODULE$.fill(channelLength, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray((double[])stds.getOrElse((Function0 & Serializable & scala.Serializable)() -> (double[])Array$.MODULE$.fill(channelLength, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double m;
            Mat matrix;
            double sd;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    sd = tuple2._2$mcD$sp();
                    if (tuple22 == null) break block2;
                    matrix = (Mat)tuple22._1();
                    m = tuple22._2$mcD$sp();
                    if (matrix != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Mat mat = matrix;
            double d = m;
            double d2 = sd;
            Mat t = new Mat(mat.rows(), mat.cols(), 6);
            mat.convertTo(t, 6);
            Core.multiply((Mat)t, (Scalar)new Scalar(BoxesRunTime.unboxToDouble((Object)scaleFactor.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0))), (Mat)t);
            Core.subtract((Mat)t, (Scalar)new Scalar(d), (Mat)t);
            Core.divide((Mat)t, (Scalar)new Scalar(d2), (Mat)t);
            Mat mat2 = t;
            return mat2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Mat.class)));
    }

    /*
     * WARNING - void declaration
     */
    private double[][] to2DArray(Mat m) {
        void var2_2;
        double[][] array = (double[][])Array$.MODULE$.ofDim(m.rows(), m.cols(), ClassTag$.MODULE$.Double());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])array)).indices().foreach((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> m.get(i, 0, array[i]));
        return var2_2;
    }

    public double[][][] convertToTensor(Mat[] matrices) {
        return (double[][][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matrices)).map((Function1 & Serializable & scala.Serializable)m -> MODULE$.to2DArray((Mat)m), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
    }

    public Row encodeImage(String path, Mat image) {
        return this.mat2row(image, path);
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$normalizeChannels$1(int channelLength$1, double[] x$7) {
        return channelLength$1 == x$7.length;
    }

    public static final /* synthetic */ boolean $anonfun$normalizeChannels$3(int channelLength$1, double[] x$8) {
        return channelLength$1 == x$8.length;
    }

    private ImageTransformer$() {
        MODULE$ = this;
        MLReadable.$init$((MLReadable)this);
        DefaultParamsReadable.$init$((DefaultParamsReadable)this);
    }
}

