/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.opencv;

import com.microsoft.azure.synapse.ml.opencv.ImageTransformerStage;
import com.microsoft.azure.synapse.ml.opencv.ResizeImage$;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4A\u0001F\u000b\u0001E!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u0003=\u0001\u0011\u0005Q\bC\u0004A\u0001\t\u0007I\u0011I!\t\r\t\u0003\u0001\u0015!\u00036\u0011\u0015\u0019\u0005\u0001\"\u0011E\u000f\u0015\u0001V\u0003#\u0001R\r\u0015!R\u0003#\u0001S\u0011\u0015at\u0001\"\u0001Z\u0011\u001d\u0001uA1A\u0005\u0002iCaAQ\u0004!\u0002\u0013Y\u0006b\u00022\b\u0005\u0004%\tA\u0017\u0005\u0007G\u001e\u0001\u000b\u0011B.\t\u000f\u0011<!\u0019!C\u00015\"1Qm\u0002Q\u0001\nmCqAZ\u0004C\u0002\u0013\u0005!\f\u0003\u0004h\u000f\u0001\u0006Ia\u0017\u0005\bQ\u001e\u0011\r\u0011\"\u0001[\u0011\u0019Iw\u0001)A\u00057\"9!nBA\u0001\n\u0013Y'a\u0003*fg&TX-S7bO\u0016T!AF\f\u0002\r=\u0004XM\\2w\u0015\tA\u0012$\u0001\u0002nY*\u0011!dG\u0001\bgft\u0017\r]:f\u0015\taR$A\u0003buV\u0014XM\u0003\u0002\u001f?\u0005IQ.[2s_N|g\r\u001e\u0006\u0002A\u0005\u00191m\\7\u0004\u0001M\u0011\u0001a\t\t\u0003I\u0015j\u0011!F\u0005\u0003MU\u0011Q#S7bO\u0016$&/\u00198tM>\u0014X.\u001a:Ti\u0006<W-\u0001\u0004qCJ\fWn\u001d\t\u0005SI*\u0004H\u0004\u0002+aA\u00111FL\u0007\u0002Y)\u0011Q&I\u0001\u0007yI|w\u000e\u001e \u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0002\rA\u0013X\rZ3g\u0013\t\u0019DGA\u0002NCBT!!\r\u0018\u0011\u0005%2\u0014BA\u001c5\u0005\u0019\u0019FO]5oOB\u0011\u0011HO\u0007\u0002]%\u00111H\f\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\b\u0006\u0002?\u007fA\u0011A\u0005\u0001\u0005\u0006O\t\u0001\r\u0001K\u0001\ngR\fw-\u001a(b[\u0016,\u0012!N\u0001\u000bgR\fw-\u001a(b[\u0016\u0004\u0013!B1qa2LHCA#O!\t1E*D\u0001H\u0015\tA\u0015*\u0001\u0003d_J,'B\u0001\fK\u0015\u0005Y\u0015aA8sO&\u0011Qj\u0012\u0002\u0004\u001b\u0006$\b\"B(\u0006\u0001\u0004)\u0015!B5nC\u001e,\u0017a\u0003*fg&TX-S7bO\u0016\u0004\"\u0001J\u0004\u0014\u0007\u001d\u0019f\u000b\u0005\u0002:)&\u0011QK\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005e:\u0016B\u0001-/\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005\tV#A.\u0011\u0005q\u000bW\"A/\u000b\u0005y{\u0016\u0001\u00027b]\u001eT\u0011\u0001Y\u0001\u0005U\u00064\u0018-\u0003\u00028;\u00061\u0001.Z5hQR\fq\u0001[3jO\"$\b%A\u0003xS\u0012$\b.\u0001\u0004xS\u0012$\b\u000eI\u0001\u0005g&TX-A\u0003tSj,\u0007%A\blK\u0016\u0004\u0018i\u001d9fGR\u0014\u0016\r^5p\u0003AYW-\u001a9BgB,7\r\u001e*bi&|\u0007%A\u0006sK\u0006$'+Z:pYZ,G#\u00017\u0011\u0005qk\u0017B\u00018^\u0005\u0019y%M[3di\u0002")
public class ResizeImage
extends ImageTransformerStage {
    private final Map<String, Object> params;
    private final String stageName;

    public static String keepAspectRatio() {
        return ResizeImage$.MODULE$.keepAspectRatio();
    }

    public static String size() {
        return ResizeImage$.MODULE$.size();
    }

    public static String width() {
        return ResizeImage$.MODULE$.width();
    }

    public static String height() {
        return ResizeImage$.MODULE$.height();
    }

    @Override
    public String stageName() {
        return this.stageName;
    }

    @Override
    public Mat apply(Mat image) {
        Size size;
        Mat resized = new Mat();
        if (this.params.isDefinedAt((Object)ResizeImage$.MODULE$.size())) {
            int specifiedSize = BoxesRunTime.unboxToInt((Object)this.params.apply((Object)ResizeImage$.MODULE$.size()));
            if (BoxesRunTime.unboxToBoolean((Object)this.params.apply((Object)ResizeImage$.MODULE$.keepAspectRatio()))) {
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(image.width(), image.height());
                if (sp2 == null) {
                    throw new MatchError((Object)sp2);
                }
                int originalWidth = sp2._1$mcI$sp();
                int originalHeight = sp2._2$mcI$sp();
                Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(originalWidth, originalHeight);
                int originalWidth2 = sp3._1$mcI$sp();
                int originalHeight2 = sp3._2$mcI$sp();
                int shorterSize = package$.MODULE$.min(originalWidth2, originalHeight2);
                double ratio = 1.0 * (double)specifiedSize / (double)shorterSize;
                Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(package$.MODULE$.round(ratio * (double)originalWidth2), package$.MODULE$.round(ratio * (double)originalHeight2));
                if (sp4 == null) {
                    throw new MatchError((Object)sp4);
                }
                long targetWidth = sp4._1$mcJ$sp();
                long targetHeight = sp4._2$mcJ$sp();
                Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(targetWidth, targetHeight);
                long targetWidth2 = sp5._1$mcJ$sp();
                long targetHeight2 = sp5._2$mcJ$sp();
                size = new Size((double)targetWidth2, (double)targetHeight2);
            } else {
                size = new Size((double)specifiedSize, (double)specifiedSize);
            }
        } else {
            double height = BoxesRunTime.unboxToInt((Object)this.params.apply((Object)ResizeImage$.MODULE$.height()));
            double width = BoxesRunTime.unboxToInt((Object)this.params.apply((Object)ResizeImage$.MODULE$.width()));
            size = new Size(width, height);
        }
        Size sz = size;
        Imgproc.resize((Mat)image, (Mat)resized, (Size)sz);
        return resized;
    }

    public ResizeImage(Map<String, Object> params) {
        this.params = params;
        super(params);
        this.stageName = ResizeImage$.MODULE$.stageName();
    }
}

