/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.policyeval;

import breeze.stats.distributions.FDistribution;
import com.microsoft.azure.synapse.ml.logging.SynapseMLLogInfo;
import com.microsoft.azure.synapse.ml.logging.SynapseMLLogging;
import com.microsoft.azure.synapse.ml.policyeval.BanditEstimator;
import com.microsoft.azure.synapse.ml.policyeval.CressieReadInterval$;
import com.microsoft.azure.synapse.ml.policyeval.CressieReadIntervalBuffer;
import com.microsoft.azure.synapse.ml.policyeval.CressieReadIntervalBuffer$;
import com.microsoft.azure.synapse.ml.policyeval.CressieReadIntervalInput;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.expressions.Aggregator;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001B\t\u0013\u0001}A\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u0011\u0002!\t!\u0013\u0005\b\u0019\u0002\u0011\r\u0011\"\u0011N\u0011\u0019I\u0006\u0001)A\u0005\u001d\"9!\f\u0001b\u0001\n\u0003Y\u0006BB0\u0001A\u0003%A\fC\u0004a\u0001\t\u0007I\u0011A.\t\r\u0005\u0004\u0001\u0015!\u0003]\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u0015!\u0007\u0001\"\u0001f\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u0015\u0001\b\u0001\"\u0003r\u0011\u001d\ty\u0001\u0001C\u0005\u0003#Aq!!\u000b\u0001\t\u0003\tY\u0003C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\t\u00192I]3tg&,'+Z1e\u0013:$XM\u001d<bY*\u00111\u0003F\u0001\u000ba>d\u0017nY=fm\u0006d'BA\u000b\u0017\u0003\tiGN\u0003\u0002\u00181\u000591/\u001f8baN,'BA\r\u001b\u0003\u0015\t'0\u001e:f\u0015\tYB$A\u0005nS\u000e\u0014xn]8gi*\tQ$A\u0002d_6\u001c\u0001a\u0005\u0003\u0001Aar\u0004#B\u0011-]I*T\"\u0001\u0012\u000b\u0005\r\"\u0013aC3yaJ,7o]5p]NT!!\n\u0014\u0002\u0007M\fHN\u0003\u0002(Q\u0005)1\u000f]1sW*\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0013\ti#E\u0001\u0006BO\u001e\u0014XmZ1u_J\u0004\"a\f\u0019\u000e\u0003II!!\r\n\u00031\r\u0013Xm]:jKJ+\u0017\rZ%oi\u0016\u0014h/\u00197J]B,H\u000f\u0005\u00020g%\u0011AG\u0005\u0002\u001a\u0007J,7o]5f%\u0016\fG-\u00138uKJ4\u0018\r\u001c\"vM\u001a,'\u000f\u0005\u00020m%\u0011qG\u0005\u0002\u0010\u0005\u0006tG-\u001b;FgRLW.\u0019;peB\u0011\u0011\bP\u0007\u0002u)\t1(A\u0003tG\u0006d\u0017-\u0003\u0002>u\ta1+\u001a:jC2L'0\u00192mKB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tF\u0001\bY><w-\u001b8h\u0013\t\u0019\u0005I\u0001\tTs:\f\u0007o]3N\u00192{wmZ5oO\u0006yQ-\u001c9je&\u001c\u0017\r\u001c\"pk:$7\u000f\u0005\u0002:\r&\u0011qI\u000f\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u0011!j\u0013\t\u0003_\u0001AQ\u0001\u0012\u0002A\u0002\u0015\u000b1!^5e+\u0005q\u0005CA(W\u001d\t\u0001F\u000b\u0005\u0002Ru5\t!K\u0003\u0002T=\u00051AH]8pizJ!!\u0016\u001e\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+j\nA!^5eA\u0005)\u0011\r\u001c9iCV\tA\f\u0005\u0002:;&\u0011aL\u000f\u0002\u0007\t>,(\r\\3\u0002\r\u0005d\u0007\u000f[1!\u0003\u0011\tGo\u001c7\u0002\u000b\u0005$x\u000e\u001c\u0011\u0002\ti,'o\\\u000b\u0002e\u00051!/\u001a3vG\u0016$2A\r4i\u0011\u00159'\u00021\u00013\u0003\r\t7m\u0019\u0005\u0006S*\u0001\rAL\u0001\u0002q\u0006)Q.\u001a:hKR\u0019!\u0007\u001c8\t\u000b5\\\u0001\u0019\u0001\u001a\u0002\t\u0005\u001c7-\r\u0005\u0006_.\u0001\rAM\u0001\u0005C\u000e\u001c''\u0001\u000bd_6\u0004X\u000f^3C_VtG-\u00138gS:LG/\u001f\u000b\u000eeV<\u0018p_?\u0000\u0003\u0007\t9!a\u0003\u0011\u0007e\u001aH,\u0003\u0002uu\t1q\n\u001d;j_:DQA\u001e\u0007A\u0002q\u000b\u0011A\u001c\u0005\u0006q2\u0001\r\u0001X\u0001\u0005g&<g\u000eC\u0003{\u0019\u0001\u0007A,A\u0001s\u0011\u0015aH\u00021\u0001]\u0003\u0011\u0019X/\\<\t\u000byd\u0001\u0019\u0001/\u0002\rM,Xn^:r\u0011\u0019\t\t\u0001\u0004a\u00019\u0006)1/^7xe\"1\u0011Q\u0001\u0007A\u0002q\u000bqa];noN\f(\u000f\u0003\u0004\u0002\n1\u0001\r\u0001X\u0001\ngVlwo]9sgFDa!!\u0004\r\u0001\u0004a\u0016a\u00019iS\u0006\t2m\\7qkR,'i\\;oI&sg.\u001a:\u0015+I\f\u0019\"a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019#!\n\u0002(!1\u0011QC\u0007A\u0002q\u000bQa\u001e4bW\u0016DQA^\u0007A\u0002qCQ\u0001_\u0007A\u0002qCQA_\u0007A\u0002qCQ\u0001`\u0007A\u0002qCQA`\u0007A\u0002qCa!!\u0001\u000e\u0001\u0004a\u0006BBA\u0003\u001b\u0001\u0007A\f\u0003\u0004\u0002\n5\u0001\r\u0001\u0018\u0005\u0007\u0003\u001bi\u0001\u0019\u0001/\u0002\r\u0019Lg.[:i)\r)\u0014Q\u0006\u0005\u0006O:\u0001\rAM\u0001\u000eEV4g-\u001a:F]\u000e|G-\u001a:\u0016\u0005\u0005M\u0002#BA\u001b\u0003o\u0011T\"\u0001\u0013\n\u0007\u0005eBEA\u0004F]\u000e|G-\u001a:\u0002\u001b=,H\u000f];u\u000b:\u001cw\u000eZ3s+\t\ty\u0004E\u0003\u00026\u0005]R\u0007")
public class CressieReadInterval
extends Aggregator<CressieReadIntervalInput, CressieReadIntervalBuffer, BanditEstimator>
implements SynapseMLLogging {
    private final boolean empiricalBounds;
    private final String uid;
    private final double alpha;
    private final double atol;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public void logBase(String methodName) {
        SynapseMLLogging.logBase$((SynapseMLLogging)this, (String)methodName);
    }

    public void logBase(SynapseMLLogInfo info) {
        SynapseMLLogging.logBase$((SynapseMLLogging)this, (SynapseMLLogInfo)info);
    }

    public void logErrorBase(String methodName, Exception e) {
        SynapseMLLogging.logErrorBase$((SynapseMLLogging)this, (String)methodName, (Exception)e);
    }

    public void logClass() {
        SynapseMLLogging.logClass$((SynapseMLLogging)this);
    }

    public <T> T logFit(Function0<T> f) {
        return (T)SynapseMLLogging.logFit$((SynapseMLLogging)this, f);
    }

    public <T> T logTrain(Function0<T> f) {
        return (T)SynapseMLLogging.logTrain$((SynapseMLLogging)this, f);
    }

    public <T> T logTransform(Function0<T> f) {
        return (T)SynapseMLLogging.logTransform$((SynapseMLLogging)this, f);
    }

    public <T> T logVerb(String verb, Function0<T> f) {
        return (T)SynapseMLLogging.logVerb$((SynapseMLLogging)this, (String)verb, f);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String uid() {
        return this.uid;
    }

    public double alpha() {
        return this.alpha;
    }

    public double atol() {
        return this.atol;
    }

    public CressieReadIntervalBuffer zero() {
        return new CressieReadIntervalBuffer(CressieReadIntervalBuffer$.MODULE$.apply$default$1(), CressieReadIntervalBuffer$.MODULE$.apply$default$2(), CressieReadIntervalBuffer$.MODULE$.apply$default$3(), CressieReadIntervalBuffer$.MODULE$.apply$default$4(), CressieReadIntervalBuffer$.MODULE$.apply$default$5(), CressieReadIntervalBuffer$.MODULE$.apply$default$6(), CressieReadIntervalBuffer$.MODULE$.apply$default$7(), CressieReadIntervalBuffer$.MODULE$.apply$default$8(), CressieReadIntervalBuffer$.MODULE$.apply$default$9(), CressieReadIntervalBuffer$.MODULE$.apply$default$10());
    }

    public CressieReadIntervalBuffer reduce(CressieReadIntervalBuffer acc, CressieReadIntervalInput x) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        float w = x.probPred() / x.probLog();
        float countW = x.count() * w;
        float countWsq = countW * countW;
        float countWsqr = countWsq * x.reward();
        if (this.empiricalBounds) {
            tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)Math.max(acc.rewardMax(), x.reward())), (Object)BoxesRunTime.boxToFloat((float)Math.min(acc.rewardMin(), x.reward())));
        } else {
            if (x.reward() > x.rewardMax() || x.reward() < x.rewardMin()) {
                throw new IllegalArgumentException(new StringBuilder(31).append("Reward is out of bounds: ").append(x.rewardMin()).append(" < ").append(x.reward()).append(" < ").append(x.rewardMax()).toString());
            }
            tuple22 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)x.rewardMax()), (Object)BoxesRunTime.boxToFloat((float)x.rewardMin()));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        float rMax = BoxesRunTime.unboxToFloat((Object)tuple2._1());
        float rMin = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)rMax), (Object)BoxesRunTime.boxToFloat((float)rMin));
        Tuple2 tuple24 = tuple23;
        float rMax2 = BoxesRunTime.unboxToFloat((Object)tuple24._1());
        float rMin2 = BoxesRunTime.unboxToFloat((Object)tuple24._2());
        return new CressieReadIntervalBuffer(Math.min(acc.wMin(), x.wMin()), Math.max(acc.wMax(), x.wMax()), rMin2, rMax2, acc.n().$plus(x.count()), acc.sumw().$plus(countW), acc.sumwsq().$plus(countWsq), acc.sumwr().$plus(countW * x.reward()), acc.sumwsqr().$plus(countWsqr), acc.sumwsqrsq().$plus(countWsqr * x.reward()));
    }

    public CressieReadIntervalBuffer merge(CressieReadIntervalBuffer acc1, CressieReadIntervalBuffer acc2) {
        return new CressieReadIntervalBuffer(Math.min(acc1.wMin(), acc2.wMin()), Math.max(acc1.wMax(), acc2.wMax()), Math.min(acc1.rewardMin(), acc2.rewardMin()), Math.max(acc1.rewardMax(), acc2.rewardMax()), acc1.n().$plus(acc2.n()), acc1.sumw().$plus(acc2.sumw()), acc1.sumwsq().$plus(acc2.sumwsq()), acc1.sumwr().$plus(acc2.sumwr()), acc1.sumwsqr().$plus(acc2.sumwsqr()), acc1.sumwsqrsq().$plus(acc2.sumwsqrsq()));
    }

    private Option<Object> computeBoundInfinity(double n, double sign, double r, double sumw, double sumwsq, double sumwr, double sumwsqr, double sumwsqrsq, double phi) {
        double x = sign * (r + (sumwr - sumw * r) / n);
        double rSumwSumwr = r * sumw - sumwr;
        double y = rSumwSumwr * rSumwSumwr / (n * (1.0 + n)) - (r * r * sumwsq - (double)2 * r * sumwsqr + sumwsqrsq) / (1.0 + n);
        double z = phi + 1.0 / ((double)2 * n);
        if (Math.abs(y * z) < this.atol()) {
            y = 0.0;
        }
        Object object = Math.abs(y * z) < this.atol() * this.atol() ? new Some((Object)BoxesRunTime.boxToDouble((double)(x - Math.sqrt(2.0) * this.atol()))) : (z <= 0.0 && y * z >= 0.0 ? new Some((Object)BoxesRunTime.boxToDouble((double)(x - Math.sqrt((double)2 * y * z)))) : BoxedUnit.UNIT);
        return None$.MODULE$;
    }

    private Option<Object> computeBoundInner(double wfake, double n, double sign, double r, double sumw, double sumwsq, double sumwr, double sumwsqr, double sumwsqrsq, double phi) {
        Object object;
        if (RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(wfake))) {
            object = this.computeBoundInfinity(n, sign, r, sumw, sumwsq, sumwr, sumwsqr, sumwsqrsq, phi);
        } else {
            double barw = (wfake + sumw) / (1.0 + n);
            double barwsq = (wfake * wfake + sumwsq) / (1.0 + n);
            double barwr = sign * (wfake * r + sumwr) / (1.0 + n);
            double barwsqr = sign * (wfake * wfake * r + sumwsqr) / (1.0 + n);
            double barwsqrsq = (wfake * wfake * r * r + sumwsqrsq) / (1.0 + n);
            if (barwsq <= barw * barw) {
                object = None$.MODULE$;
            } else {
                double x = barwr + (1.0 - barw) * (barwsqr - barw * barwr) / (barwsq - barw * barw);
                double y = (barwsqr - barw * barwr) * (barwsqr - barw * barwr) / (barwsq - barw * barw) - (barwsqrsq - barwr * barwr);
                double z = phi + 0.0 * (1.0 - barw) * (1.0 - barw) / (barwsq - barw * barw);
                object = Math.abs(y * x) < this.atol() * this.atol() ? new Some((Object)BoxesRunTime.boxToDouble((double)(x - Math.sqrt(2.0) * this.atol()))) : (z <= 0.0 && y * z >= 0.0 ? new Some((Object)BoxesRunTime.boxToDouble((double)(x - Math.sqrt((double)2 * y * z)))) : None$.MODULE$);
            }
        }
        return object;
    }

    public BanditEstimator finish(CressieReadIntervalBuffer acc) {
        return (BanditEstimator)this.logVerb("aggregate", (Function0 & Serializable & scala.Serializable)() -> {
            BanditEstimator banditEstimator;
            double n = acc.n().toDouble();
            if (n == 0.0) {
                banditEstimator = new BanditEstimator(-1.0, -1.0);
            } else {
                double d;
                float uncwfake;
                double sumw = acc.sumw().toDouble();
                double sumwsq = acc.sumwsq().toDouble();
                double sumwr = acc.sumwr().toDouble();
                double sumwsqr = acc.sumwsqr().toDouble();
                double sumwsqrsq = acc.sumwsqrsq().toDouble();
                float f = uncwfake = sumw < n ? acc.wMax() : acc.wMin();
                if (RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(uncwfake))) {
                    d = 1.0 + 1.0 / n;
                } else {
                    double unca = ((double)uncwfake + sumw) / (1.0 + n);
                    double uncb = ((double)(uncwfake * uncwfake) + sumwsq) / (1.0 + n);
                    d = (1.0 + n) * (unca - 1.0) * (unca - 1.0) / (uncb - unca * unca);
                }
                double uncgstar = d;
                FDistribution fDistribution = new FDistribution(1.0, n);
                double delta = 1.0 - fDistribution.inverseCdf(this.alpha());
                double phi = (-uncgstar - delta) / ((double)2 * (1.0 + n));
                banditEstimator = new BanditEstimator(this.computeBound$1(acc.rewardMin(), 1, acc, n, sumw, sumwsq, sumwr, sumwsqr, sumwsqrsq, phi), this.computeBound$1(acc.rewardMax(), -1, acc, n, sumw, sumwsq, sumwr, sumwsqr, sumwsqrsq, phi));
            }
            return banditEstimator;
        });
    }

    public Encoder<CressieReadIntervalBuffer> bufferEncoder() {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CressieReadInterval.class.getClassLoader());
        public final class Com_microsoft_azure_synapse_ml_policyeval_CressieReadInterval$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("com.microsoft.azure.synapse.ml.policyeval.CressieReadIntervalBuffer").asType().toTypeConstructor();
            }

            public Com_microsoft_azure_synapse_ml_policyeval_CressieReadInterval$$typecreator1$1(CressieReadInterval $outer) {
            }
        }
        return Encoders$.MODULE$.product(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_microsoft_azure_synapse_ml_policyeval_CressieReadInterval$$typecreator1$1(null)));
    }

    public Encoder<BanditEstimator> outputEncoder() {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CressieReadInterval.class.getClassLoader());
        public final class Com_microsoft_azure_synapse_ml_policyeval_CressieReadInterval$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("com.microsoft.azure.synapse.ml.policyeval.BanditEstimator").asType().toTypeConstructor();
            }

            public Com_microsoft_azure_synapse_ml_policyeval_CressieReadInterval$$typecreator1$2(CressieReadInterval $outer) {
            }
        }
        return Encoders$.MODULE$.product(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_microsoft_azure_synapse_ml_policyeval_CressieReadInterval$$typecreator1$2(null)));
    }

    private final double computeBound$1(double r, int sign, CressieReadIntervalBuffer acc$1, double n$1, double sumw$1, double sumwsq$1, double sumwr$1, double sumwsqr$1, double sumwsqrsq$1, double phi$1) {
        Option<Object> lower = this.computeBoundInner(acc$1.wMin(), n$1, sign, r, sumw$1, sumwsq$1, sumwr$1, sumwsqr$1, sumwsqrsq$1, phi$1);
        Option<Object> upper = this.computeBoundInner(acc$1.wMax(), n$1, sign, r, sumw$1, sumwsq$1, sumwr$1, sumwsqr$1, sumwsqrsq$1, phi$1);
        double best = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)new .colon.colon(lower, (List)new .colon.colon(upper, (List)Nil$.MODULE$)).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).min((Ordering)Ordering.Double$.MODULE$));
        return Math.min((double)acc$1.rewardMax(), Math.max((double)acc$1.rewardMin(), (double)sign * best));
    }

    public CressieReadInterval(boolean empiricalBounds) {
        this.empiricalBounds = empiricalBounds;
        Logging.$init$((Logging)this);
        SynapseMLLogging.$init$((SynapseMLLogging)this);
        this.uid = Identifiable$.MODULE$.randomUID("BanditEstimatorCressieReadInterval");
        this.logClass();
        this.alpha = 0.05;
        this.atol = 1.0E-9;
    }
}

