/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.synapse.ml.policyeval;

import com.microsoft.azure.synapse.ml.logging.FeatureNames$;
import com.microsoft.azure.synapse.ml.logging.SynapseMLLogging;
import com.microsoft.azure.synapse.ml.policyeval.CressieRead$;
import com.microsoft.azure.synapse.ml.policyeval.CressieReadBuffer;
import com.microsoft.azure.synapse.ml.policyeval.CressieReadBuffer$;
import com.microsoft.azure.synapse.ml.policyeval.CressieReadInput;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.expressions.Aggregator;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichFloat$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001!4AAC\u0006\u00011!)Q\b\u0001C\u0001}!9\u0001\t\u0001b\u0001\n\u0003\n\u0005BB'\u0001A\u0003%!\tC\u0003O\u0001\u0011\u0005q\nC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003W\u0001\u0011\u0005q\u000bC\u0003]\u0001\u0011\u0005Q\fC\u0003`\u0001\u0011\u0005\u0001\rC\u0003f\u0001\u0011\u0005aMA\u0006De\u0016\u001c8/[3SK\u0006$'B\u0001\u0007\u000e\u0003)\u0001x\u000e\\5ds\u00164\u0018\r\u001c\u0006\u0003\u001d=\t!!\u001c7\u000b\u0005A\t\u0012aB:z]\u0006\u00048/\u001a\u0006\u0003%M\tQ!\u0019>ve\u0016T!\u0001F\u000b\u0002\u00135L7M]8t_\u001a$(\"\u0001\f\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001IBg\u000e\t\u00065\u0015:3FL\u0007\u00027)\u0011A$H\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001f?\u0005\u00191/\u001d7\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001eL!AJ\u000e\u0003\u0015\u0005;wM]3hCR|'\u000f\u0005\u0002)S5\t1\"\u0003\u0002+\u0017\t\u00012I]3tg&,'+Z1e\u0013:\u0004X\u000f\u001e\t\u0003Q1J!!L\u0006\u0003#\r\u0013Xm]:jKJ+\u0017\r\u001a\"vM\u001a,'\u000f\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004E_V\u0014G.\u001a\t\u0003_UJ!A\u000e\u0019\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005aZT\"A\u001d\u000b\u0005ij\u0011a\u00027pO\u001eLgnZ\u0005\u0003ye\u0012\u0001cU=oCB\u001cX-\u0014'M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005y\u0004C\u0001\u0015\u0001\u0003\r)\u0018\u000eZ\u000b\u0002\u0005B\u00111I\u0013\b\u0003\t\"\u0003\"!\u0012\u0019\u000e\u0003\u0019S!aR\f\u0002\rq\u0012xn\u001c;?\u0013\tI\u0005'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013aa\u0015;sS:<'BA%1\u0003\u0011)\u0018\u000e\u001a\u0011\u0002\ti,'o\\\u000b\u0002W\u00051!/\u001a3vG\u0016$2a\u000b*U\u0011\u0015\u0019V\u00011\u0001,\u0003\r\t7m\u0019\u0005\u0006+\u0016\u0001\raJ\u0001\u0002q\u0006)Q.\u001a:hKR\u00191\u0006\u0017.\t\u000be3\u0001\u0019A\u0016\u0002\t\u0005\u001c7-\r\u0005\u00067\u001a\u0001\raK\u0001\u0005C\u000e\u001c''\u0001\u0004gS:L7\u000f\u001b\u000b\u0003]yCQaU\u0004A\u0002-\nQBY;gM\u0016\u0014XI\\2pI\u0016\u0014X#A1\u0011\u0007\t\u001c7&D\u0001\u001e\u0013\t!WDA\u0004F]\u000e|G-\u001a:\u0002\u001b=,H\u000f];u\u000b:\u001cw\u000eZ3s+\u00059\u0007c\u00012d]\u0001")
public class CressieRead
extends Aggregator<CressieReadInput, CressieReadBuffer, Object>
implements SynapseMLLogging {
    private final String uid;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Map<String, String> getPayload(String methodName, Option<Object> numCols, Option<Object> executionSeconds, Option<Exception> exception) {
        return SynapseMLLogging.getPayload$((SynapseMLLogging)this, (String)methodName, numCols, executionSeconds, exception);
    }

    public void logBase(String methodName, Option<Object> numCols, Option<Object> executionSeconds, Option<String> featureName) {
        SynapseMLLogging.logBase$((SynapseMLLogging)this, (String)methodName, numCols, executionSeconds, featureName);
    }

    public void logBase(Map<String, String> info, Option<String> featureName) {
        SynapseMLLogging.logBase$((SynapseMLLogging)this, info, featureName);
    }

    public void logErrorBase(String methodName, Exception e) {
        SynapseMLLogging.logErrorBase$((SynapseMLLogging)this, (String)methodName, (Exception)e);
    }

    public void logClass(String featureName) {
        SynapseMLLogging.logClass$((SynapseMLLogging)this, (String)featureName);
    }

    public <T> T logFit(Function0<T> f, int columns) {
        return (T)SynapseMLLogging.logFit$((SynapseMLLogging)this, f, (int)columns);
    }

    public <T> T logTransform(Function0<T> f, int columns) {
        return (T)SynapseMLLogging.logTransform$((SynapseMLLogging)this, f, (int)columns);
    }

    public <T> T logVerb(String verb, Function0<T> f, Option<Object> columns) {
        return (T)SynapseMLLogging.logVerb$((SynapseMLLogging)this, (String)verb, f, columns);
    }

    public <T> Option<Object> logVerb$default$3() {
        return SynapseMLLogging.logVerb$default$3$((SynapseMLLogging)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String uid() {
        return this.uid;
    }

    public CressieReadBuffer zero() {
        return new CressieReadBuffer(CressieReadBuffer$.MODULE$.apply$default$1(), CressieReadBuffer$.MODULE$.apply$default$2(), CressieReadBuffer$.MODULE$.apply$default$3(), CressieReadBuffer$.MODULE$.apply$default$4(), CressieReadBuffer$.MODULE$.apply$default$5(), CressieReadBuffer$.MODULE$.apply$default$6(), CressieReadBuffer$.MODULE$.apply$default$7(), CressieReadBuffer$.MODULE$.apply$default$8());
    }

    public CressieReadBuffer reduce(CressieReadBuffer acc, CressieReadInput x) {
        float w = x.probPred() / x.probLog();
        float countW = x.count() * w;
        float countWsq = countW * countW;
        return new CressieReadBuffer(Math.min(acc.wMin(), x.wMin()), Math.max(acc.wMax(), x.wMax()), acc.n().$plus(x.count()), acc.sumw().$plus(countW), acc.sumwsq().$plus(countWsq), acc.sumwr().$plus(countW * x.reward()), acc.sumwrsqr().$plus(countWsq * x.reward()), acc.sumr().$plus(x.count() * x.reward()));
    }

    public CressieReadBuffer merge(CressieReadBuffer acc1, CressieReadBuffer acc2) {
        return new CressieReadBuffer(Math.min(acc1.wMin(), acc2.wMin()), Math.max(acc1.wMax(), acc2.wMax()), acc1.n().$plus(acc2.n()), acc1.sumw().$plus(acc2.sumw()), acc1.sumwsq().$plus(acc2.sumwsq()), acc1.sumwr().$plus(acc2.sumwr()), acc1.sumwrsqr().$plus(acc2.sumwrsqr()), acc1.sumr().$plus(acc2.sumr()));
    }

    public double finish(CressieReadBuffer acc) {
        return BoxesRunTime.unboxToDouble(this.logVerb("aggregate", (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> {
            Tuple2.mcDD.sp sp2;
            Tuple2.mcDD.sp sp3;
            float wfake;
            double n = acc.n().toDouble();
            double sumw = acc.sumw().toDouble();
            double sumwsq = acc.sumwsq().toDouble();
            double sumwr = acc.sumwr().toDouble();
            double sumwsqr = acc.sumwrsqr().toDouble();
            double sumr = acc.sumr().toDouble();
            float f = wfake = sumw < n ? acc.wMax() : acc.wMin();
            if (RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(wfake))) {
                sp3 = new Tuple2.mcDD.sp(-(1.0 + n) / n, 0.0);
            } else {
                double a = ((double)wfake + sumw) / (1.0 + n);
                double b = ((double)(wfake * wfake) + sumwsq) / (1.0 + n);
                Predef$.MODULE$.assert(a * a <= b);
                sp3 = sp2 = new Tuple2.mcDD.sp((b - a) / (a * a - b), (1.0 - a) / (a * a - b));
            }
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double gamma = sp2._1$mcD$sp();
            double beta = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(gamma, beta);
            double gamma2 = sp4._1$mcD$sp();
            double beta2 = sp4._2$mcD$sp();
            double vhat = (-gamma2 * sumwr - beta2 * sumwsqr) / (1.0 + n);
            double missing = Math.max(0.0, 1.0 - (-gamma2 * sumw - beta2 * sumwsq) / (1.0 + n));
            double rhatmissing = sumr / n;
            return vhat + missing * rhatmissing;
        }, this.logVerb$default$3()));
    }

    public Encoder<CressieReadBuffer> bufferEncoder() {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CressieRead.class.getClassLoader());
        public final class Com_microsoft_azure_synapse_ml_policyeval_CressieRead$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("com.microsoft.azure.synapse.ml.policyeval.CressieReadBuffer").asType().toTypeConstructor();
            }

            public Com_microsoft_azure_synapse_ml_policyeval_CressieRead$$typecreator1$1(CressieRead $outer) {
            }
        }
        return Encoders$.MODULE$.product(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_microsoft_azure_synapse_ml_policyeval_CressieRead$$typecreator1$1(null)));
    }

    public Encoder<Object> outputEncoder() {
        return Encoders$.MODULE$.scalaDouble();
    }

    public CressieRead() {
        Logging.$init$((Logging)this);
        SynapseMLLogging.$init$((SynapseMLLogging)this);
        this.uid = Identifiable$.MODULE$.randomUID("BanditEstimatorCressieRead");
        this.logClass(FeatureNames$.MODULE$.VowpalWabbit());
    }
}

