/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.PerformanceData;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.BulkObject;
import com.microsoft.bingads.v12.internal.bulk.BulkObjectWriter;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkKeywordBidSuggestion
extends BulkObject {
    private String keywordText;
    private Double bid;
    private PerformanceData performanceData = new PerformanceData();
    private static final List<BulkMapping<BulkKeywordBidSuggestion>> MAPPINGS;

    @Override
    public void readFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
        this.performanceData.readFromRowValues(values);
    }

    @Override
    public void writeToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
        PerformanceData.writeToRowValuesIfNotNull(this.performanceData, values);
    }

    static void writeIfNotNull(BulkKeywordBidSuggestion bidSuggestion, BulkObjectWriter writer) throws IOException {
        if (bidSuggestion != null) {
            writer.writeObjectRow(bidSuggestion);
        }
    }

    public String getKeywordText() {
        return this.keywordText;
    }

    public Double getBid() {
        return this.bid;
    }

    public PerformanceData getPerformanceData() {
        return this.performanceData;
    }

    private void setKeywordText(String keywordText) {
        this.keywordText = keywordText;
    }

    private void setBid(Double bid) {
        this.bid = bid;
    }

    private void setPerformanceData(PerformanceData performanceData) {
        this.performanceData = performanceData;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkKeywordBidSuggestion, Object>> m = new ArrayList<SimpleBulkMapping<BulkKeywordBidSuggestion, Object>>();
        m.add(new SimpleBulkMapping<BulkKeywordBidSuggestion, String>("Keyword", new Function<BulkKeywordBidSuggestion, String>(){

            @Override
            public String apply(BulkKeywordBidSuggestion t) {
                return t.getKeywordText();
            }
        }, new BiConsumer<String, BulkKeywordBidSuggestion>(){

            @Override
            public void accept(String v, BulkKeywordBidSuggestion c) {
                c.setKeywordText(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkKeywordBidSuggestion, Double>("Bid", new Function<BulkKeywordBidSuggestion, Double>(){

            @Override
            public Double apply(BulkKeywordBidSuggestion t) {
                return t.getBid();
            }
        }, new BiConsumer<String, BulkKeywordBidSuggestion>(){

            @Override
            public void accept(String v, BulkKeywordBidSuggestion c) {
                c.setBid(StringExtensions.parseOptional(v, new Function<String, Double>(){

                    @Override
                    public Double apply(String value) {
                        return Double.parseDouble(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

