/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v12.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v12.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v12.campaignmanagement.StructuredSnippetAdExtension;
import com.microsoft.bingads.v12.internal.bulk.BulkMapping;
import com.microsoft.bingads.v12.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v12.internal.bulk.RowValues;
import com.microsoft.bingads.v12.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v12.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkStructuredSnippetAdExtension
extends BulkAdExtension<StructuredSnippetAdExtension> {
    private static final List<BulkMapping<BulkStructuredSnippetAdExtension>> MAPPINGS;

    public StructuredSnippetAdExtension getStructuredSnippetAdExtension() {
        return (StructuredSnippetAdExtension)this.getAdExtension();
    }

    public void setStructuredSnippetAdExtension(StructuredSnippetAdExtension structuredSnippetAdExtension) {
        this.setAdExtension(structuredSnippetAdExtension);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        StructuredSnippetAdExtension extension = new StructuredSnippetAdExtension();
        extension.setType("StructuredSnippetAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getStructuredSnippetAdExtension(), "StructuredSnippetAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkStructuredSnippetAdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkStructuredSnippetAdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkStructuredSnippetAdExtension, String>("Structured Snippet Header", new Function<BulkStructuredSnippetAdExtension, String>(){

            @Override
            public String apply(BulkStructuredSnippetAdExtension c) {
                return c.getStructuredSnippetAdExtension().getHeader();
            }
        }, new BiConsumer<String, BulkStructuredSnippetAdExtension>(){

            @Override
            public void accept(String v, BulkStructuredSnippetAdExtension c) {
                c.getStructuredSnippetAdExtension().setHeader(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkStructuredSnippetAdExtension, String>("Structured Snippet Values", new Function<BulkStructuredSnippetAdExtension, String>(){

            @Override
            public String apply(BulkStructuredSnippetAdExtension c) {
                return StringExtensions.writeStructuredSnippetValues(";", c.getStructuredSnippetAdExtension().getValues());
            }
        }, new BiConsumer<String, BulkStructuredSnippetAdExtension>(){

            @Override
            public void accept(String v, BulkStructuredSnippetAdExtension c) {
                c.getStructuredSnippetAdExtension().setValues(StringExtensions.parseStructuredSnippetValues(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

