/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.LocationCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupLocationCriterion
extends BulkAdGroupBiddableCriterion {
    private static final List<BulkMapping<BulkAdGroupLocationCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    protected Criterion createCriterion() {
        return new LocationCriterion();
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupLocationCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupLocationCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, String>("Target", new Function<BulkAdGroupLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    Long locationId = ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getLocationId();
                    return locationId == null ? null : locationId.toString();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setLocationId(Long.parseLong(v));
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, String>("Sub Type", new Function<BulkAdGroupLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getLocationType();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setLocationType(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupLocationCriterion, String>("Name", new Function<BulkAdGroupLocationCriterion, String>(){

            @Override
            public String apply(BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    return ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).getDisplayName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupLocationCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupLocationCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof LocationCriterion) {
                    ((LocationCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setDisplayName(v);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

