/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.Label;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkLabel
extends SingleRecordBulkEntity {
    private Label label;
    private Status status;
    private static final List<BulkMapping<BulkLabel>> MAPPINGS;

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setLabel(new Label());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getLabel(), "Label");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkLabel, Object>> m = new ArrayList<SimpleBulkMapping<BulkLabel, Object>>();
        m.add(new SimpleBulkMapping<BulkLabel, Long>("Id", new Function<BulkLabel, Long>(){

            @Override
            public Long apply(BulkLabel c) {
                return c.getLabel().getId();
            }
        }, new BiConsumer<String, BulkLabel>(){

            @Override
            public void accept(String v, BulkLabel c) {
                c.getLabel().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkLabel, String>("Status", new Function<BulkLabel, String>(){

            @Override
            public String apply(BulkLabel c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkLabel>(){

            @Override
            public void accept(String v, BulkLabel c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkLabel, String>("Color", new Function<BulkLabel, String>(){

            @Override
            public String apply(BulkLabel c) {
                return c.getLabel().getColorCode();
            }
        }, new BiConsumer<String, BulkLabel>(){

            @Override
            public void accept(String v, BulkLabel c) {
                c.getLabel().setColorCode(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkLabel, String>("Description", new Function<BulkLabel, String>(){

            @Override
            public String apply(BulkLabel c) {
                return c.getLabel().getDescription();
            }
        }, new BiConsumer<String, BulkLabel>(){

            @Override
            public void accept(String v, BulkLabel c) {
                c.getLabel().setDescription(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkLabel, String>("Label", new Function<BulkLabel, String>(){

            @Override
            public String apply(BulkLabel c) {
                return c.getLabel().getName();
            }
        }, new BiConsumer<String, BulkLabel>(){

            @Override
            public void accept(String v, BulkLabel c) {
                c.getLabel().setName(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

