/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.DisclaimerAdExtension;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkDisclaimerAdExtension
extends BulkAdExtension<DisclaimerAdExtension> {
    private static final List<BulkMapping<BulkDisclaimerAdExtension>> MAPPINGS;

    public DisclaimerAdExtension getDisclaimerAdExtension() {
        return (DisclaimerAdExtension)this.getAdExtension();
    }

    public void setDisclaimerAdExtension(DisclaimerAdExtension disclaimerAdExtension) {
        this.setAdExtension(disclaimerAdExtension);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        DisclaimerAdExtension extension = new DisclaimerAdExtension();
        extension.setType("DisclaimerAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getDisclaimerAdExtension(), "DisclaimerAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkDisclaimerAdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkDisclaimerAdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkDisclaimerAdExtension, String>("Disclaimer Name", new Function<BulkDisclaimerAdExtension, String>(){

            @Override
            public String apply(BulkDisclaimerAdExtension c) {
                return StringExtensions.toOptionalBulkString(((DisclaimerAdExtension)c.getAdExtension()).getName(), ((DisclaimerAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkDisclaimerAdExtension>(){

            @Override
            public void accept(String v, BulkDisclaimerAdExtension c) {
                ((DisclaimerAdExtension)c.getAdExtension()).setName(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDisclaimerAdExtension, String>("Disclaimer Layout", new Function<BulkDisclaimerAdExtension, String>(){

            @Override
            public String apply(BulkDisclaimerAdExtension t) {
                return t.getDisclaimerAdExtension().getDisclaimerLayout();
            }
        }, new BiConsumer<String, BulkDisclaimerAdExtension>(){

            @Override
            public void accept(String v, BulkDisclaimerAdExtension c) {
                c.getDisclaimerAdExtension().setDisclaimerLayout(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDisclaimerAdExtension, String>("Disclaimer Line Text", new Function<BulkDisclaimerAdExtension, String>(){

            @Override
            public String apply(BulkDisclaimerAdExtension t) {
                return t.getDisclaimerAdExtension().getLineText();
            }
        }, new BiConsumer<String, BulkDisclaimerAdExtension>(){

            @Override
            public void accept(String v, BulkDisclaimerAdExtension c) {
                c.getDisclaimerAdExtension().setLineText(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDisclaimerAdExtension, String>("Disclaimer Popup Text", new Function<BulkDisclaimerAdExtension, String>(){

            @Override
            public String apply(BulkDisclaimerAdExtension t) {
                return t.getDisclaimerAdExtension().getPopupText();
            }
        }, new BiConsumer<String, BulkDisclaimerAdExtension>(){

            @Override
            public void accept(String v, BulkDisclaimerAdExtension c) {
                c.getDisclaimerAdExtension().setPopupText(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDisclaimerAdExtension, String>("Disclaimer Title", new Function<BulkDisclaimerAdExtension, String>(){

            @Override
            public String apply(BulkDisclaimerAdExtension t) {
                return t.getDisclaimerAdExtension().getTitle();
            }
        }, new BiConsumer<String, BulkDisclaimerAdExtension>(){

            @Override
            public void accept(String v, BulkDisclaimerAdExtension c) {
                c.getDisclaimerAdExtension().setTitle(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDisclaimerAdExtension, String>("Final Url", new Function<BulkDisclaimerAdExtension, String>(){

            @Override
            public String apply(BulkDisclaimerAdExtension c) {
                return StringExtensions.writeUrls("; ", c.getDisclaimerAdExtension().getFinalUrls(), c.getDisclaimerAdExtension().getId());
            }
        }, new BiConsumer<String, BulkDisclaimerAdExtension>(){

            @Override
            public void accept(String v, BulkDisclaimerAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getDisclaimerAdExtension().setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkDisclaimerAdExtension, String>("Mobile Final Url", new Function<BulkDisclaimerAdExtension, String>(){

            @Override
            public String apply(BulkDisclaimerAdExtension c) {
                return StringExtensions.writeUrls("; ", c.getDisclaimerAdExtension().getFinalMobileUrls(), c.getDisclaimerAdExtension().getId());
            }
        }, new BiConsumer<String, BulkDisclaimerAdExtension>(){

            @Override
            public void accept(String v, BulkDisclaimerAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                c.getDisclaimerAdExtension().setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkDisclaimerAdExtension, String>("Tracking Template", new Function<BulkDisclaimerAdExtension, String>(){

            @Override
            public String apply(BulkDisclaimerAdExtension t) {
                return StringExtensions.toOptionalBulkString(t.getDisclaimerAdExtension().getTrackingUrlTemplate(), t.getDisclaimerAdExtension().getId());
            }
        }, new BiConsumer<String, BulkDisclaimerAdExtension>(){

            @Override
            public void accept(String v, BulkDisclaimerAdExtension c) {
                c.getDisclaimerAdExtension().setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDisclaimerAdExtension, String>("Custom Parameter", new Function<BulkDisclaimerAdExtension, String>(){

            @Override
            public String apply(BulkDisclaimerAdExtension c) {
                return StringExtensions.toCustomParaBulkString(c.getDisclaimerAdExtension().getUrlCustomParameters(), c.getDisclaimerAdExtension().getId());
            }
        }, new BiConsumer<String, BulkDisclaimerAdExtension>(){

            @Override
            public void accept(String v, BulkDisclaimerAdExtension c) {
                try {
                    c.getDisclaimerAdExtension().setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkDisclaimerAdExtension, String>("Final Url Suffix", new Function<BulkDisclaimerAdExtension, String>(){

            @Override
            public String apply(BulkDisclaimerAdExtension c) {
                return StringExtensions.toOptionalBulkString(((DisclaimerAdExtension)c.getAdExtension()).getFinalUrlSuffix(), ((DisclaimerAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkDisclaimerAdExtension>(){

            @Override
            public void accept(String v, BulkDisclaimerAdExtension c) {
                ((DisclaimerAdExtension)c.getAdExtension()).setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

