/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.OAuthScope;
import com.microsoft.bingads.OAuthTokens;
import com.microsoft.bingads.internal.OAuthAuthorization;
import com.microsoft.bingads.internal.OAuthEndpointHelper;
import com.microsoft.bingads.internal.OAuthUrlParameters;
import com.microsoft.bingads.internal.URLExtensions;
import java.net.URL;
import java.util.Map;

public abstract class OAuthImplicitGrant
extends OAuthAuthorization {
    private static final String EXPIRES_IN = "expires_in";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String TOKEN = "token";
    private final String clientId;
    private final URL redirectionUri;
    private final OAuthScope oAuthScope;

    protected OAuthImplicitGrant(String clientId, URL redirectionUri, OAuthTokens oauthTokens, ApiEnvironment env, OAuthScope oAuthScope) {
        super(env);
        this.clientId = clientId;
        this.redirectionUri = redirectionUri;
        this.oAuthTokens = oauthTokens;
        this.oAuthScope = oAuthScope;
    }

    @Override
    public URL getAuthorizationEndpoint() {
        return OAuthEndpointHelper.getAuthorizationEndpoint(new OAuthUrlParameters(this.clientId, TOKEN, this.redirectionUri, this.getState()), this.getEnvironment(), this.oAuthScope, this.getTenant());
    }

    public OAuthTokens extractAccessTokenFromUrl(URL redirectionUri) {
        Map<String, String> fragmentParts = URLExtensions.parseFragment(redirectionUri);
        if (!fragmentParts.containsKey(ACCESS_TOKEN)) {
            throw new UnsupportedOperationException("Uri passed doesn't contain access_token param. Please make sure the has an access_token param in it");
        }
        if (!fragmentParts.containsKey(EXPIRES_IN)) {
            throw new UnsupportedOperationException("Uri passed doesn't contain expires_in param. Please make sure the has an expires_in param in it");
        }
        this.oAuthTokens = new OAuthTokens(fragmentParts.get(ACCESS_TOKEN), Integer.parseInt(fragmentParts.get(EXPIRES_IN)), null);
        return this.oAuthTokens;
    }
}

