/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v13.campaignmanagement.BiddableAdGroupCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupAudienceAssociation
extends BulkAdGroupBiddableCriterion {
    private String audienceName;
    private static final List<BulkMapping<BulkAdGroupAudienceAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    protected Criterion createCriterion() {
        return new AudienceCriterion();
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public BiddableAdGroupCriterion getBiddableAdGroupCriterion() {
        return this.biddableAdGroupCriterion;
    }

    public String getAudienceName() {
        return this.audienceName;
    }

    public void setAudienceName(String audienceName) {
        this.audienceName = audienceName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupAudienceAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupAudienceAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupAudienceAssociation, String>("Audience", new Function<BulkAdGroupAudienceAssociation, String>(){

            @Override
            public String apply(BulkAdGroupAudienceAssociation c) {
                return c.getAudienceName();
            }
        }, new BiConsumer<String, BulkAdGroupAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupAudienceAssociation c) {
                c.setAudienceName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupAudienceAssociation, Long>("Audience Id", new Function<BulkAdGroupAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkAdGroupAudienceAssociation c) {
                if (c.getBiddableAdGroupCriterion() instanceof BiddableAdGroupCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupAudienceAssociation>(){

            @Override
            public void accept(String v, BulkAdGroupAudienceAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

