/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.UncheckedParseException;
import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.campaignmanagement.DataExclusion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;

public class BulkDataExclusion
extends SingleRecordBulkEntity {
    private DataExclusion DataExclusion;
    private static final List<BulkMapping<BulkDataExclusion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setDataExclusion(new DataExclusion());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getDataExclusion(), "DataExclusion");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public DataExclusion getDataExclusion() {
        return this.DataExclusion;
    }

    public void setDataExclusion(DataExclusion DataExclusion2) {
        this.DataExclusion = DataExclusion2;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkDataExclusion, Object>> m = new ArrayList<SimpleBulkMapping<BulkDataExclusion, Object>>();
        m.add(new SimpleBulkMapping<BulkDataExclusion, Long>("Id", new Function<BulkDataExclusion, Long>(){

            @Override
            public Long apply(BulkDataExclusion c) {
                return c.getDataExclusion().getId();
            }
        }, new BiConsumer<String, BulkDataExclusion>(){

            @Override
            public void accept(String v, BulkDataExclusion c) {
                c.getDataExclusion().setId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDataExclusion, String>("Data Exclusion", new Function<BulkDataExclusion, String>(){

            @Override
            public String apply(BulkDataExclusion c) {
                return c.getDataExclusion().getName();
            }
        }, new BiConsumer<String, BulkDataExclusion>(){

            @Override
            public void accept(String v, BulkDataExclusion c) {
                c.getDataExclusion().setName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkDataExclusion, String>("Description", new Function<BulkDataExclusion, String>(){

            @Override
            public String apply(BulkDataExclusion c) {
                return c.getDataExclusion().getDescription();
            }
        }, new BiConsumer<String, BulkDataExclusion>(){

            @Override
            public void accept(String v, BulkDataExclusion c) {
                c.getDataExclusion().setDescription(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkDataExclusion, String>("Start Date", new Function<BulkDataExclusion, String>(){

            @Override
            public String apply(BulkDataExclusion t) {
                if (t.getDataExclusion().getStartDate() == null) {
                    return null;
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.format(t.getDataExclusion().getStartDate().getTime());
            }
        }, new BiConsumer<String, BulkDataExclusion>(){

            @Override
            public void accept(String v, BulkDataExclusion c) {
                c.getDataExclusion().setStartDate(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                    @Override
                    public Calendar apply(String t) {
                        GregorianCalendar c = new GregorianCalendar();
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            c.setTime(format.parse(t));
                        }
                        catch (ParseException ex) {
                            throw new UncheckedParseException(ex);
                        }
                        return c;
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDataExclusion, String>("End Date", new Function<BulkDataExclusion, String>(){

            @Override
            public String apply(BulkDataExclusion t) {
                if (t.getDataExclusion().getEndDate() == null) {
                    return null;
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                return format.format(t.getDataExclusion().getEndDate().getTime());
            }
        }, new BiConsumer<String, BulkDataExclusion>(){

            @Override
            public void accept(String v, BulkDataExclusion c) {
                c.getDataExclusion().setEndDate(StringExtensions.parseOptional(v, new Function<String, Calendar>(){

                    @Override
                    public Calendar apply(String t) {
                        GregorianCalendar c = new GregorianCalendar();
                        try {
                            SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                            format.setTimeZone(TimeZone.getTimeZone("UTC"));
                            c.setTime(format.parse(t));
                        }
                        catch (ParseException ex) {
                            throw new UncheckedParseException(ex);
                        }
                        return c;
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDataExclusion, String>("Campaign Type", new Function<BulkDataExclusion, String>(){

            @Override
            public String apply(BulkDataExclusion c) {
                return StringExtensions.toCampaignTypeListBulkString(",", c.getDataExclusion().getCampaignTypeFilter());
            }
        }, new BiConsumer<String, BulkDataExclusion>(){

            @Override
            public void accept(String v, BulkDataExclusion c) {
                c.getDataExclusion().setCampaignTypeFilter(StringExtensions.parseCampaignTypeList(v, ","));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDataExclusion, String>("Device Type", new Function<BulkDataExclusion, String>(){

            @Override
            public String apply(BulkDataExclusion c) {
                return StringExtensions.toDeviceTypeListBulkString(",", c.getDataExclusion().getDeviceTypeFilter());
            }
        }, new BiConsumer<String, BulkDataExclusion>(){

            @Override
            public void accept(String v, BulkDataExclusion c) {
                c.getDataExclusion().setDeviceTypeFilter(StringExtensions.parseDeviceTypeList(v, ","));
            }
        }));
        m.add(new SimpleBulkMapping<BulkDataExclusion, String>("Campaign Associations", new Function<BulkDataExclusion, String>(){

            @Override
            public String apply(BulkDataExclusion c) {
                return StringExtensions.toCampaignAssociationsBulkString(";", c.getDataExclusion().getCampaignAssociations());
            }
        }, new BiConsumer<String, BulkDataExclusion>(){

            @Override
            public void accept(String v, BulkDataExclusion c) {
                c.getDataExclusion().setCampaignAssociations(StringExtensions.parseCampaignAssociations(v, ";"));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

