/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.internal.bulk;

import com.microsoft.bingads.internal.functionalinterfaces.Predicate;
import com.microsoft.bingads.v13.internal.bulk.BulkObject;
import com.microsoft.bingads.v13.internal.bulk.BulkObjectReader;
import com.microsoft.bingads.v13.internal.bulk.BulkRecordReader;
import com.microsoft.bingads.v13.internal.bulk.FormatVersion;
import com.microsoft.bingads.v13.internal.bulk.TryResult;
import java.io.File;
import java.io.IOException;

public class SimpleBulkRecordReader
implements BulkRecordReader {
    private BulkObjectReader objectReader;
    private BulkObject nextObject;
    private boolean passedFirstRow = false;
    private boolean deleteFileOnClose;
    private File file;

    public SimpleBulkRecordReader(BulkObjectReader reader) {
        this.objectReader = reader;
    }

    @Override
    public BulkObject read() {
        TryResult<BulkObject> result = this.tryRead(BulkObject.class);
        if (result.isSuccessful()) {
            return result.getResult();
        }
        try {
            this.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public <T extends BulkObject> TryResult<T> tryRead(Class<T> klazz) {
        return this.tryRead(new Predicate<T>(){

            @Override
            public boolean test(T obj) {
                return true;
            }
        }, klazz);
    }

    @Override
    public <T extends BulkObject> TryResult<T> tryRead(Predicate<T> predicate, Class<T> klazz) {
        BulkObject peeked = this.peek();
        if (klazz.isInstance(peeked) && predicate.test((BulkObject)klazz.cast(peeked))) {
            this.nextObject = null;
            peeked.readRelatedData(this);
            return new TryResult<T>(true, klazz.cast(peeked));
        }
        return new TryResult<Object>(false, null);
    }

    private BulkObject peek() {
        if (!this.passedFirstRow) {
            BulkObject firstRowObject = this.objectReader.readNextBulkObject();
            if (firstRowObject instanceof FormatVersion) {
                String version;
                FormatVersion formatVersion = (FormatVersion)firstRowObject;
                if (formatVersion != null && !(version = formatVersion.getValue()).equals("6") && !version.equals("6.0")) {
                    throw new UnsupportedOperationException("Format version is not supported: " + version);
                }
            } else {
                this.nextObject = firstRowObject;
            }
            this.passedFirstRow = true;
        }
        if (this.nextObject != null) {
            return this.nextObject;
        }
        this.nextObject = this.objectReader.readNextBulkObject();
        return this.nextObject;
    }

    @Override
    public void close() throws IOException {
        try {
            this.objectReader.close();
        }
        finally {
            if (this.deleteFileOnClose && this.file != null && this.file.exists()) {
                this.file.delete();
            }
        }
    }
}

