/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.internal.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.DynamicColumnNameMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.SingleFieldBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.BulkEntityIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkNegativeSiteIdentifier
extends BulkEntityIdentifier {
    private Status status;
    private long entityId;
    private String entityName;
    private static List<BulkMapping<BulkNegativeSiteIdentifier>> MAPPINGS;

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    protected abstract String getParentColumnName();

    @Override
    public void readFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void writeToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public boolean isDeleteRow() {
        return this.status == Status.DELETED;
    }

    static {
        ArrayList<SingleFieldBulkMapping> m = new ArrayList<SingleFieldBulkMapping>();
        m.add(new SimpleBulkMapping<BulkNegativeSiteIdentifier, String>("Status", new Function<BulkNegativeSiteIdentifier, String>(){

            @Override
            public String apply(BulkNegativeSiteIdentifier c) {
                return StringExtensions.toStatusBulkString(c.getStatus());
            }
        }, new BiConsumer<String, BulkNegativeSiteIdentifier>(){

            @Override
            public void accept(String v, BulkNegativeSiteIdentifier c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkNegativeSiteIdentifier, String>("Parent Id", new Function<BulkNegativeSiteIdentifier, String>(){

            @Override
            public String apply(BulkNegativeSiteIdentifier c) {
                return c.getEntityId() == 0L ? null : Long.toString(c.getEntityId());
            }
        }, new BiConsumer<String, BulkNegativeSiteIdentifier>(){

            @Override
            public void accept(String v, BulkNegativeSiteIdentifier c) {
                c.setEntityId(StringExtensions.parse(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return value == null || value.isEmpty() ? 0L : Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new DynamicColumnNameMapping<BulkNegativeSiteIdentifier, String>(new Function<BulkNegativeSiteIdentifier, String>(){

            @Override
            public String apply(BulkNegativeSiteIdentifier c) {
                return c.getParentColumnName();
            }
        }, new Function<BulkNegativeSiteIdentifier, String>(){

            @Override
            public String apply(BulkNegativeSiteIdentifier c) {
                return c.getEntityName();
            }
        }, new BiConsumer<String, BulkNegativeSiteIdentifier>(){

            @Override
            public void accept(String v, BulkNegativeSiteIdentifier c) {
                c.setEntityName(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

